/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.block.entity;

import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.block.entity.DeviceBlockEntity;
import com.ultreon.devices.core.network.Connection;
import com.ultreon.devices.core.network.Router;
import com.ultreon.devices.util.Colorable;
import com.ultreon.devices.util.Tickable;
import java.util.Objects;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NetworkDeviceBlockEntity
extends DeviceBlockEntity
implements Tickable {
    private int counter;
    private Connection connection;

    public NetworkDeviceBlockEntity(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        assert (this.field_11863 != null);
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.connection != null && ++this.counter >= (Integer)DeviceConfig.BEACON_INTERVAL.get() * 2) {
            this.connection.setRouterPos(null);
            this.counter = 0;
        }
    }

    public void connect(Router router) {
        assert (this.field_11863 != null);
        if (router == null) {
            Router connectedRouter;
            if (this.connection != null && (connectedRouter = this.connection.getRouter(this.field_11863)) != null) {
                connectedRouter.removeDevice(this);
            }
            this.connection = null;
            return;
        }
        this.connection = new Connection(router);
        this.counter = 0;
        this.method_5431();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Nullable
    public Router getRouter() {
        return this.connection != null ? this.connection.getRouter(Objects.requireNonNull(this.field_11863)) : null;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public boolean receiveBeacon(Router router) {
        if (this.counter >= (Integer)DeviceConfig.BEACON_INTERVAL.get() * 2) {
            this.connect(router);
            return true;
        }
        if (this.connection != null && this.connection.getRouterId().equals(router.getId())) {
            this.connection.setRouterPos(router.getPos());
            this.counter = 0;
            return true;
        }
        return false;
    }

    public int getSignalStrength() {
        class_2338 routerPos;
        class_2338 class_23382 = routerPos = this.connection != null ? this.connection.getRouterPos() : null;
        if (routerPos != null) {
            double level;
            double distance = Math.sqrt(this.field_11867.method_10268((double)routerPos.method_10263() + 0.5, (double)routerPos.method_10264() + 0.5, (double)routerPos.method_10260() + 0.5));
            return distance > (level = (double)((Integer)DeviceConfig.SIGNAL_RANGE.get()).intValue() / 3.0) * 2.0 ? 2 : (distance > level ? 1 : 0);
        }
        return -1;
    }

    @Override
    @Nullable
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)this.getCustomName());
    }

    @Override
    public void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        if (this.connection != null) {
            tag.method_10566("connection", (class_2520)this.connection.toTag());
        }
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("connection", 10)) {
            this.connection = Connection.fromTag(tag.method_10562("connection"));
        }
    }

    public static abstract class Colored
    extends NetworkDeviceBlockEntity
    implements Colorable {
        private class_1767 color = class_1767.field_7964;

        public Colored(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
            super(pType, pWorldPosition, pBlockState);
        }

        @Override
        public void method_11014(@NotNull class_2487 tag) {
            super.method_11014(tag);
            if (tag.method_10573("color", 8)) {
                this.color = class_1767.method_7791((int)tag.method_10571("color"));
            }
        }

        @Override
        public void method_11007(@NotNull class_2487 tag) {
            super.method_11007(tag);
            tag.method_10567("color", (byte)this.color.method_7789());
        }

        @Override
        public class_2487 saveSyncTag() {
            class_2487 tag = super.saveSyncTag();
            tag.method_10567("color", (byte)this.color.method_7789());
            return tag;
        }

        @Override
        public void setColor(class_1767 color) {
            this.color = color;
        }

        @Override
        public class_1767 getColor() {
            return this.color;
        }
    }
}

