/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.block.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.print.IPrint;
import com.ultreon.devices.api.print.PrintingManager;
import com.ultreon.devices.block.PaperBlock;
import com.ultreon.devices.block.entity.PaperBlockEntity;
import com.ultreon.devices.block.entity.renderer.PrinterRenderer;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1043;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

public record PaperRenderer(class_5614.class_5615 context) implements class_827<PaperBlockEntity>
{
    private static long AA = 0L;

    private static void drawCuboid(double x, double y, double z, double width, double height, double depth, class_4597 bufferSource) {
        double v = (x /= 16.0) + (width /= 16.0) + 1.0 - (width + width);
        PaperRenderer.drawQuad(x + (1.0 - width), y /= 16.0, z /= 16.0, x + width + (1.0 - width), y + (height /= 16.0), z, class_2350.field_11043, bufferSource);
        PaperRenderer.drawQuad(x + 1.0, y, z, x + 1.0, y + height, z + (depth /= 16.0), class_2350.field_11034, bufferSource);
        PaperRenderer.drawQuad(v, y, z + depth, v, y + height, z, class_2350.field_11039, bufferSource);
        PaperRenderer.drawQuad(x + (1.0 - width), y, z + depth, x + width + (1.0 - width), y, z, class_2350.field_11033, bufferSource);
        PaperRenderer.drawQuad(x + (1.0 - width), y + height, z, x + width + (1.0 - width), y, z + depth, class_2350.field_11036, bufferSource);
    }

    private static void drawQuad(double xFrom, double yFrom, double zFrom, double xTo, double yTo, double zTo, class_2350 direction, class_4597 bufferSource) {
        double textureWidth = Math.abs(xTo - xFrom);
        double textureHeight = Math.abs(yTo - yFrom);
        double textureDepth = Math.abs(zTo - zFrom);
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23577());
    }

    private static void drawPixels(class_4587 poseStack, int[] pixels, int resolution, boolean cut, int packedLight, class_4597 bufferSource) {
        double scale = 16.0 / (double)resolution;
        class_1043 d = new class_1043(resolution, resolution, true);
        for (int i = 0; i < resolution; ++i) {
            for (int j = 0; j < resolution; ++j) {
                int r = pixels[j + i * resolution] >> 16 & 0xFF;
                int g = pixels[j + i * resolution] >> 8 & 0xFF;
                int b = pixels[j + i * resolution] & 0xFF;
                int a = (int)Math.floor(pixels[j + i * resolution] >> 24 & 0xFF);
                assert (d.method_4525() != null);
                d.method_4525().method_4305(i, j, new Color(r, g, b, a).getRGB());
            }
        }
        class_2960 resourcelocation = class_310.method_1551().method_1531().method_4617("map/" + AA, d);
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        class_4588 vertexconsumer = bufferSource.getBuffer(class_1921.method_23028((class_2960)resourcelocation));
        vertexconsumer.method_22918(matrix4f, 0.0f, 128.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22916(packedLight).method_1344();
        vertexconsumer.method_22918(matrix4f, 128.0f, 128.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22916(packedLight).method_1344();
        vertexconsumer.method_22918(matrix4f, 128.0f, 0.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22916(packedLight).method_1344();
        vertexconsumer.method_22918(matrix4f, 0.0f, 0.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22916(packedLight).method_1344();
        ++AA;
    }

    public void render(PaperBlockEntity blockEntity, float partialTick, @NotNull class_4587 pose, @NotNull class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_2487 data;
        class_2680 state = Objects.requireNonNull(blockEntity.method_10997()).method_8320(blockEntity.method_11016());
        if (blockEntity.method_11010().method_26204() != state.method_26204()) {
            Devices.LOGGER.error("Paper block mismatch: {} != {}", (Object)blockEntity.method_11010().method_26204(), (Object)state.method_26204());
            return;
        }
        pose.method_22903();
        pose.method_22904((double)blockEntity.method_11016().method_10263(), (double)blockEntity.method_11016().method_10264(), (double)blockEntity.method_11016().method_10260());
        pose.method_22904(0.5, 0.5, 0.5);
        pose.method_22907(((class_2350)state.method_11654((class_2769)PaperBlock.field_11177)).method_23224());
        pose.method_22907(new class_1158(0.0f, 0.0f, 1.0f, -blockEntity.getRotation()));
        pose.method_22904(-0.5, -0.5, -0.5);
        IPrint print = blockEntity.getPrint();
        if (print != null && (data = print.toTag()).method_10573("pixels", 11) && data.method_10573("resolution", 3)) {
            RenderSystem.setShaderTexture((int)0, (class_2960)PrinterRenderer.PaperModel.TEXTURE);
            if (!((Boolean)DeviceConfig.RENDER_PRINTED_3D.get()).booleanValue() || !data.method_10577("cut")) {
                // empty if block
            }
            pose.method_22904(0.0, 0.0, (Boolean)DeviceConfig.RENDER_PRINTED_3D.get() != false ? 0.0625 : 0.001);
            pose.method_22903();
            IPrint.Renderer renderer = PrintingManager.getRenderer(print);
            renderer.render(pose, data);
            pose.method_22909();
            pose.method_22903();
            if (((Boolean)DeviceConfig.RENDER_PRINTED_3D.get()).booleanValue() && data.method_10577("cut")) {
                class_2487 tag = print.toTag();
                PaperRenderer.drawPixels(pose, tag.method_10561("pixels"), tag.method_10550("resolution"), tag.method_10577("cut"), packedLight, bufferSource);
            }
            pose.method_22909();
        }
        pose.method_22909();
    }
}

