/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.app.Dialog;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.System;
import com.ultreon.devices.api.app.SystemAccessor;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.api.io.Drive;
import com.ultreon.devices.api.io.File;
import com.ultreon.devices.api.task.Callback;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.Settings;
import com.ultreon.devices.core.TaskBar;
import com.ultreon.devices.core.Window;
import com.ultreon.devices.core.Wrappable;
import com.ultreon.devices.core.task.TaskInstallApp;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.system.DiagnosticsApp;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.programs.system.component.FileBrowser;
import com.ultreon.devices.programs.system.task.TaskUpdateApplicationData;
import com.ultreon.devices.programs.system.task.TaskUpdateSystemData;
import com.ultreon.devices.util.GLHelper;
import dev.architectury.injectables.annotations.PlatformOnly;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class Laptop
extends class_437
implements System {
    public static final int ID = 1;
    public static final class_2960 ICON_TEXTURES = new class_2960("devices", "textures/atlas/app_icons.png");
    public static final int ICON_SIZE = 14;
    private static final class_2960 LAPTOP_FONT = Devices.res("laptop");
    private static class_327 font;
    private static final class_2960 LAPTOP_GUI;
    private static final List<Application> APPLICATIONS;
    private static boolean worldLess;
    private static Laptop instance;
    private static final List<class_2960> WALLPAPERS;
    private static final int BORDER = 10;
    private static final int DEVICE_WIDTH = 384;
    static final int SCREEN_WIDTH = 364;
    private static final int DEVICE_HEIGHT = 216;
    static final int SCREEN_HEIGHT = 196;
    private static final List<Runnable> tasks;
    private static System system;
    private static class_2338 pos;
    private static Drive mainDrive;
    private final Settings settings;
    private final TaskBar bar;
    final ArrayList<Window<?>> windows;
    private final class_2487 appData;
    private final class_2487 systemData;
    protected List<AppInfo> installedApps = new ArrayList<AppInfo>();
    private Layout context = null;
    private Wallpaper currentWallpaper;
    private int lastMouseX;
    private int lastMouseY;
    private boolean dragging = false;
    private final IntArraySet pressed = new IntArraySet();
    private final Image wallpaper;
    private final Layout wallpaperLayout;
    private BSOD bsod;

    @PlatformOnly(value={"fabric"})
    public static List<Application> getApplicationsForFabric() {
        return APPLICATIONS;
    }

    public static List<class_2960> getWallpapers() {
        return ImmutableList.copyOf(WALLPAPERS);
    }

    public static class_327 getFont() {
        if (font == null) {
            font = class_310.method_1551().field_1772;
        }
        return font;
    }

    public Laptop(LaptopBlockEntity laptop) {
        this(laptop, false);
    }

    public Laptop(LaptopBlockEntity laptop, boolean worldLess) {
        super((class_2561)class_2561.method_43470((String)"Laptop"));
        instance = this;
        this.appData = laptop.getApplicationData();
        this.systemData = laptop.getSystemData();
        this.windows = new ArrayList<Window<?>>(){

            @Override
            public Window<?> get(int index) {
                try {
                    return (Window)super.get(index);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean add(Window<?> window) {
                window.removed = false;
                return super.add(window);
            }
        };
        this.settings = Settings.fromTag(this.systemData.method_10562("Settings"));
        this.bar = new TaskBar(this);
        Wallpaper wallpaper = this.currentWallpaper = this.systemData.method_10573("CurrentWallpaper", 10) ? new Wallpaper(this.systemData.method_10562("CurrentWallpaper")) : null;
        if (this.currentWallpaper == null) {
            this.currentWallpaper = new Wallpaper(0);
        }
        system = this;
        pos = laptop.method_11016();
        this.wallpaperLayout = new Layout(364, 196);
        this.wallpaper = new Image(0, 0, 364, 196);
        if (this.currentWallpaper.isBuiltIn()) {
            this.wallpaper.setImage(WALLPAPERS.get(this.currentWallpaper.location));
        } else {
            this.wallpaper.setImage(this.currentWallpaper.url);
        }
        this.wallpaperLayout.addComponent(this.wallpaper);
        this.wallpaperLayout.handleLoad();
        Laptop.worldLess = worldLess;
    }

    public static boolean isWorldLess() {
        return worldLess;
    }

    @Nullable
    public static class_2338 getPos() {
        return pos;
    }

    public static void addWallpaper(class_2960 wallpaper) {
        if (wallpaper != null) {
            WALLPAPERS.add(wallpaper);
        }
    }

    public static System getSystem() {
        return system;
    }

    @Nullable
    public static Drive getMainDrive() {
        return mainDrive;
    }

    public static void setMainDrive(Drive mainDrive) {
        if (Laptop.mainDrive == null) {
            Laptop.mainDrive = mainDrive;
        }
    }

    public static void runLater(Runnable task) {
        tasks.add(task);
    }

    public void method_25426() {
        class_310.method_1551().field_1774.method_1462(true);
        int posX = (this.field_22789 - 384) / 2;
        int posY = (this.field_22790 - 216) / 2;
        this.bar.init(posX + 10, posY + 216 - 28);
        this.installedApps.clear();
        class_2499 list = this.systemData.method_10554("InstalledApps", 8);
        for (int i = 0; i < list.size(); ++i) {
            AppInfo info = ApplicationManager.getApplication(class_2960.method_12829((String)list.method_10608(i)));
            if (info == null) continue;
            this.installedApps.add(info);
        }
        this.installedApps.sort(AppInfo.SORT_NAME);
        if (class_310.method_1551().method_1562() == null) {
            this.installedApps.addAll(ApplicationManager.getAvailableApplications());
        }
    }

    public void method_25432() {
        class_310.method_1551().field_1774.method_1462(false);
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null) continue;
            window.close();
            --i;
        }
        this.updateSystemData();
        pos = null;
        system = null;
        mainDrive = null;
    }

    private void updateSystemData() {
        this.systemData.method_10566("CurrentWallpaper", this.currentWallpaper.serialize());
        this.systemData.method_10566("Settings", (class_2520)this.settings.toTag());
        class_2499 tagListApps = new class_2499();
        this.installedApps.forEach(info -> tagListApps.add((Object)class_2519.method_23256((String)info.getFormattedId())));
        this.systemData.method_10566("InstalledApps", (class_2520)tagListApps);
        TaskManager.sendTask(new TaskUpdateSystemData(pos, this.systemData));
    }

    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        for (Window<?> window : this.windows) {
            if (window == null) continue;
            ((Wrappable)window.content).markForLayoutUpdate();
        }
    }

    public void method_25393() {
        try {
            this.bar.onTick();
            for (int i = 0; i < this.windows.size(); ++i) {
                Window<?> window = this.windows.get(i);
                if (window == null) continue;
                window.onTick();
                if (!window.removed) continue;
            }
            FileBrowser.refreshList = false;
        }
        catch (Exception e) {
            this.bsod(e);
        }
    }

    public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partialTicks) {
        if (this.bsod != null) {
            this.renderBsod(pose, mouseX, mouseY, partialTicks);
            return;
        }
        class_4587.class_4665 last = pose.method_23760();
        try {
            this.renderLaptop(pose, mouseX, mouseY, partialTicks);
        }
        catch (NullPointerException e) {
            while (pose.method_23760() != last) {
                pose.method_22909();
            }
            RenderSystem.disableScissor();
            this.bsod(e);
        }
        catch (Exception e) {
            while (pose.method_23760() != last) {
                pose.method_22909();
            }
            RenderSystem.disableScissor();
            this.bsod(e);
        }
    }

    public void renderBsod(@NotNull class_4587 pose, int mouseX, int mouseY, float partialTicks) {
        this.renderBezels(pose, mouseX, mouseY, partialTicks);
        int posX = (this.field_22789 - 384) / 2;
        int posY = (this.field_22790 - 216) / 2;
        class_329.method_25294((class_4587)pose, (int)(posX + 10), (int)(posY + 10), (int)(posX + 384 - 10), (int)(posY + 216 - 10), (int)new Color(0, 0, 255).getRGB());
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        double scale = class_310.method_1551().method_22683().method_4495();
        PrintStream b = new PrintStream(bo);
        this.bsod.throwable.printStackTrace(b);
        String str = bo.toString();
        class_327 class_3272 = Laptop.getFont();
        Objects.requireNonNull(Laptop.getFont());
        Laptop.drawLines(pose, class_3272, str, posX + 10, posY + 10 + 9 * 2, (int)(374.0 * scale), new Color(255, 255, 255).getRGB());
        pose.method_22903();
        pose.method_22905(2.0f, 2.0f, 0.0f);
        pose.method_22904((double)((float)(posX + 10) / 2.0f), (double)((float)(posY + 10) / 2.0f), 0.0);
        Laptop.method_25303((class_4587)pose, (class_327)Laptop.getFont(), (String)"System has crashed!", (int)0, (int)0, (int)new Color(255, 255, 255).getRGB());
        pose.method_22909();
    }

    public static void drawLines(class_4587 poseStack, class_327 font, String text, int x, int y, int width, int color) {
        ArrayList lines = new ArrayList();
        font.method_27527().method_27495(class_5348.method_29430((String)text.replaceAll("\r\n", "\n").replaceAll("\r", "\n")), width, class_2583.field_24360).forEach(b -> lines.add(b.getString()));
        Objects.requireNonNull(font);
        int totalTextHeight = 9 * lines.size();
        Objects.requireNonNull(Laptop.getFont());
        float textScale = (float)(196 - 9 * 2) / (float)totalTextHeight;
        textScale = (float)(1.0 / class_310.method_1551().method_22683().method_4495());
        textScale = Math.max(0.5f, textScale);
        poseStack.method_22903();
        poseStack.method_22905(textScale, textScale, 1.0f);
        poseStack.method_22904((double)((float)x / textScale), (double)((float)(y + 3) / textScale), 0.0);
        int lineNr = 0;
        for (String s : lines) {
            String string = s.replaceAll("\t", "    ");
            Objects.requireNonNull(font);
            font.method_1729(poseStack, string, 0.0f, 0.0f + (float)(lineNr * 9), color);
            ++lineNr;
        }
        poseStack.method_22909();
    }

    public void renderBezels(@NotNull class_4587 pose, int mouseX, int mouseY, float partialTicks) {
        tasks.clear();
        this.method_25420(pose);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)LAPTOP_GUI);
        int posX = (this.field_22789 - 384) / 2;
        int posY = (this.field_22790 - 216) / 2;
        this.method_25302(pose, posX, posY, 0, 0, 10, 10);
        this.method_25302(pose, posX + 384 - 10, posY, 11, 0, 10, 10);
        this.method_25302(pose, posX + 384 - 10, posY + 216 - 10, 11, 11, 10, 10);
        this.method_25302(pose, posX, posY + 216 - 10, 0, 11, 10, 10);
        class_329.method_25293((class_4587)pose, (int)(posX + 10), (int)posY, (int)364, (int)10, (float)10.0f, (float)0.0f, (int)1, (int)10, (int)256, (int)256);
        class_329.method_25293((class_4587)pose, (int)(posX + 384 - 10), (int)(posY + 10), (int)10, (int)196, (float)11.0f, (float)10.0f, (int)10, (int)1, (int)256, (int)256);
        class_329.method_25293((class_4587)pose, (int)(posX + 10), (int)(posY + 216 - 10), (int)364, (int)10, (float)10.0f, (float)11.0f, (int)1, (int)10, (int)256, (int)256);
        class_329.method_25293((class_4587)pose, (int)posX, (int)(posY + 10), (int)10, (int)196, (float)0.0f, (float)11.0f, (int)10, (int)1, (int)256, (int)256);
        class_329.method_25293((class_4587)pose, (int)(posX + 10), (int)(posY + 10), (int)364, (int)196, (float)10.0f, (float)10.0f, (int)1, (int)1, (int)256, (int)256);
    }

    public void renderLaptop(@NotNull class_4587 pose, int mouseX, int mouseY, float partialTicks) {
        int posX = (this.field_22789 - 384) / 2;
        int posY = (this.field_22790 - 216) / 2;
        float frameTime = class_310.method_1551().method_1488();
        for (Runnable task : tasks) {
            task.run();
        }
        this.renderBezels(pose, mouseX, mouseY, partialTicks);
        Image.CACHE.forEach((s, cachedImage) -> cachedImage.delete());
        this.wallpaperLayout.render(pose, this, this.field_22787, posX + 10, posY + 10, mouseX, mouseY, true, partialTicks);
        boolean insideContext = false;
        if (this.context != null) {
            insideContext = this.isMouseInside(mouseX, mouseY, this.context.xPosition, this.context.yPosition, this.context.xPosition + this.context.width, this.context.yPosition + this.context.height);
        }
        pose.method_22903();
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            block10: {
                Window<?> window = this.windows.get(i);
                if (window == null) continue;
                class_4587.class_4665 last = pose.method_23760();
                try {
                    if (i == 0) {
                        window.render(pose, this, this.field_22787, posX + 10, posY + 10, mouseX, mouseY, !insideContext, partialTicks);
                    } else {
                        window.render(pose, this, this.field_22787, posX + 10, posY + 10, Integer.MAX_VALUE, Integer.MAX_VALUE, false, partialTicks);
                    }
                }
                catch (Exception e) {
                    while (pose.method_23760() != last) {
                        pose.method_22909();
                    }
                    RenderSystem.disableScissor();
                    e.printStackTrace();
                    Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                    message.setTitle("Error");
                    class_2487 intent = new class_2487();
                    Object t = window.content;
                    if (!(t instanceof Application)) break block10;
                    Application app = (Application)t;
                    AppInfo info = app.getInfo();
                    if (info != null) {
                        intent.method_10582("name", info.getName());
                    }
                    this.openApplication(ApplicationManager.getApplication(Devices.id("diagnostics")), intent);
                    this.closeApplication(app);
                }
            }
            pose.method_22904(0.0, 0.0, 100.0);
        }
        pose.method_22909();
        this.bar.render(pose, this, this.field_22787, posX + 10, posY + 216 - 28, mouseX, mouseY, frameTime);
        if (this.context != null) {
            this.context.render(pose, this, this.field_22787, this.context.xPosition, this.context.yPosition, mouseX, mouseY, true, frameTime);
        }
        Image.CACHE.entrySet().removeIf(entry -> {
            Image.CachedImage cachedImage = (Image.CachedImage)entry.getValue();
            if (cachedImage.isDynamic() && cachedImage.isPendingDeletion()) {
                int texture = cachedImage.getTextureId();
                if (texture != -1) {
                    RenderSystem.deleteTexture((int)texture);
                }
                return true;
            }
            return false;
        });
        super.method_25394(pose, mouseX, mouseY, frameTime);
        GLHelper.clearScissorStack();
    }

    private boolean isMouseInside(int mouseX, int mouseY, int startX, int startY, int endX, int endY) {
        return mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= endY;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        try {
            return this.mouseClickedInternal(mouseX, mouseY, mouseButton);
        }
        catch (NullPointerException e) {
            this.bsod(e);
        }
        catch (Exception e) {
            this.bsod(e);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    private void bsod(Throwable e) {
        this.bsod = new BSOD(e);
        e.printStackTrace();
    }

    public boolean mouseClickedInternal(double mouseX, double mouseY, int mouseButton) {
        this.lastMouseX = (int)mouseX;
        this.lastMouseY = (int)mouseY;
        int posX = (this.field_22789 - 364) / 2;
        int posY = (this.field_22790 - 196) / 2;
        if (this.context != null) {
            int dropdownX = this.context.xPosition;
            int dropdownY = this.context.yPosition;
            if (this.isMouseInside((int)mouseX, (int)mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                this.context.handleMouseClick((int)mouseX, (int)mouseY, mouseButton);
                return false;
            }
            this.context = null;
        }
        this.bar.handleClick(this, posX, posY + 196 - 18, (int)mouseX, (int)mouseY, mouseButton);
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null) continue;
            try {
                Window<Dialog> dialogWindow = ((Application)window.getContent()).getActiveDialog();
                if (!this.isMouseWithinWindow((int)mouseX, (int)mouseY, window) && !this.isMouseWithinWindow((int)mouseX, (int)mouseY, dialogWindow)) continue;
                this.windows.remove(i);
                --i;
                this.updateWindowStack();
                this.windows.add(0, window);
                this.windows.get(0).handleMouseClick(this, posX, posY, (int)mouseX, (int)mouseY, mouseButton);
                if (this.isMouseWithinWindowBar((int)mouseX, (int)mouseY, dialogWindow)) {
                    this.dragging = true;
                    return false;
                }
                if (!this.isMouseWithinWindowBar((int)mouseX, (int)mouseY, window) || dialogWindow != null) break;
                this.dragging = true;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                message.setTitle("Error");
                if (this.windows.size() == 0 || this.windows.get(0) == null) {
                    class_2487 intent = new class_2487();
                    AppInfo info = ((Application)window.content).getInfo();
                    if (info != null) {
                        intent.method_10582("name", info.getName());
                    }
                    this.openApplication(ApplicationManager.getApplication(Devices.id("diagnostics")), intent);
                    continue;
                }
                this.windows.get(0).openDialog(message);
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        super.method_25406(mouseX, mouseY, state);
        this.dragging = false;
        try {
            if (this.context != null) {
                int dropdownX = this.context.xPosition;
                int dropdownY = this.context.yPosition;
                if (this.isMouseInside((int)mouseX, (int)mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                    this.context.handleMouseRelease((int)mouseX, (int)mouseY, state);
                }
            } else if (this.windows.get(0) != null) {
                this.windows.get(0).handleMouseRelease((int)mouseX, (int)mouseY, state);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.windows.get(0).openDialog(message);
        }
        return true;
    }

    public void method_37070() {
    }

    public boolean method_25400(char codePoint, int modifiers) {
        boolean override = super.method_25400(codePoint, modifiers);
        try {
            if (!override && this.windows.get(0) != null) {
                this.windows.get(0).handleCharTyped(codePoint, modifiers);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.windows.get(0).openDialog(message);
        }
        return override;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean override = super.method_25404(keyCode, scanCode, modifiers);
        try {
            if (!this.pressed.contains(keyCode) && !override && this.windows.get(0) != null) {
                this.windows.get(0).handleKeyPressed(keyCode, scanCode, modifiers);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.windows.get(0).openDialog(message);
        }
        this.pressed.add(keyCode);
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.pressed.remove(keyCode);
        boolean b = super.method_16803(keyCode, scanCode, modifiers);
        try {
            if (keyCode >= 32 && keyCode < 256 && this.windows.get(0) != null) {
                this.windows.get(0).handleKeyReleased(keyCode, scanCode, modifiers);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.windows.get(0).openDialog(message);
        }
        return b;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int posX = (this.field_22789 - 364) / 2;
        int posY = (this.field_22790 - 196) / 2;
        try {
            if (this.context != null) {
                int dropdownX = this.context.xPosition;
                int dropdownY = this.context.yPosition;
                if (this.isMouseInside((int)mouseX, (int)mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                    this.context.handleMouseDrag((int)mouseX, (int)mouseY, button);
                }
                return true;
            }
            if (this.windows.get(0) != null) {
                Window<?> window = this.windows.get(0);
                Window<Dialog> dialogWindow = ((Application)window.getContent()).getActiveDialog();
                if (this.dragging) {
                    if (this.isMouseOnScreen((int)mouseX, (int)mouseY)) {
                        Objects.requireNonNullElse(dialogWindow, window).handleWindowMove(posX, posY, (int)(-((double)this.lastMouseX - mouseX)), (int)(-((double)this.lastMouseY - mouseY)));
                    } else {
                        this.dragging = false;
                    }
                } else if (this.isMouseWithinWindow((int)mouseX, (int)mouseY, window) || this.isMouseWithinWindow((int)mouseX, (int)mouseY, dialogWindow)) {
                    window.handleMouseDrag((int)mouseX, (int)mouseY, button);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
            message.setTitle("Error");
            this.windows.get(0).openDialog(message);
        }
        this.lastMouseX = (int)mouseX;
        this.lastMouseY = (int)mouseY;
        return true;
    }

    public void method_16014(double pMouseX, double pMouseY) {
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            try {
                if (this.windows.get(0) != null) {
                    this.windows.get(0).handleMouseScroll((int)mouseX, (int)mouseY, delta >= 0.0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Dialog.Message message = new Dialog.Message("An error has occurred.\nSend logs to devs.");
                message.setTitle("Error");
                this.windows.get(0).openDialog(message);
            }
        }
        return true;
    }

    public void method_30901(@NotNull class_4587 pose, @NotNull List<class_2561> tooltips, int x, int y) {
        super.method_30901(pose, tooltips, x, y);
    }

    public Pair<Application, Boolean> sendApplicationToFront(AppInfo info) {
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null || !(window.content instanceof Application) || ((Application)window.content).getInfo() != info) continue;
            this.windows.remove(i);
            this.updateWindowStack();
            this.windows.add(0, window);
            --i;
            return Pair.of((Object)((Application)window.content), (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    @Override
    public Application openApplication(AppInfo info) {
        return this.openApplication(info, (class_2487)null);
    }

    @Override
    public Application openApplication(AppInfo info, class_2487 intentTag) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        Application[] a = new Application[]{null};
        optional.ifPresent(application -> {
            a[0] = this.openApplication((Application)application, intentTag);
        });
        return a[0];
    }

    private Application openApplication(Application app, class_2487 intent) {
        if (!(app instanceof DiagnosticsApp)) {
            if (this.isApplicationNotInstalled(app.getInfo())) {
                return null;
            }
            if (this.isInvalidApplication(app.getInfo())) {
                return null;
            }
        }
        try {
            Pair<Application, Boolean> q = this.sendApplicationToFront(app.getInfo());
            if (((Boolean)q.right()).booleanValue()) {
                return (Application)q.left();
            }
            if (app instanceof SystemApp) {
                ((SystemApp)app).setLaptop(this);
            }
            if (app instanceof SystemAccessor) {
                ((SystemAccessor)((Object)app)).sendSystem(this);
            }
            Window<Application> window = new Window<Application>(app, this);
            window.init((this.field_22789 - 364) / 2, (this.field_22790 - 196) / 2, intent);
            if (this.appData.method_10545(app.getInfo().getFormattedId())) {
                app.load(this.appData.method_10562(app.getInfo().getFormattedId()));
            }
            if (app.getCurrentLayout() == null) {
                app.restoreDefaultLayout();
            }
            this.addWindow(window);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        }
        catch (Exception e) {
            e.printStackTrace();
            AppInfo info = ApplicationManager.getApplication(Devices.id("diagnostics"));
            system.openApplication(info);
        }
        return app;
    }

    @Override
    public Pair<Application, Boolean> openApplication(AppInfo info, File file) {
        if (this.isApplicationNotInstalled(info)) {
            return Pair.of(null, (Object)false);
        }
        if (this.isInvalidApplication(info)) {
            return Pair.of(null, (Object)false);
        }
        try {
            Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
            if (optional.isPresent()) {
                Application application = optional.get();
                boolean alreadyRunning = this.isApplicationRunning(info);
                this.openApplication(application, null);
                if (this.isApplicationRunning(info)) {
                    if (!application.handleFile(file)) {
                        if (!alreadyRunning) {
                            this.closeApplication(application);
                        }
                        return Pair.of((Object)application, (Object)false);
                    }
                    return Pair.of((Object)application, (Object)true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AppInfo info1 = ApplicationManager.getApplication(Devices.id("diagnostics"));
            system.openApplication(info1);
        }
        return Pair.of(null, (Object)true);
    }

    @Override
    public void closeApplication(AppInfo info) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        optional.ifPresent(this::closeApplication);
    }

    private void closeApplication(Application app) {
        for (int i = 0; i < this.windows.size(); ++i) {
            Window<?> window = this.windows.get(i);
            if (window == null || !((Application)window.content).getInfo().equals(app.getInfo())) continue;
            if (app.isDirty()) {
                class_2487 container = new class_2487();
                app.save(container);
                app.clean();
                this.appData.method_10566(app.getInfo().getFormattedId(), (class_2520)container);
                TaskManager.sendTask(new TaskUpdateApplicationData(pos.method_10263(), pos.method_10264(), pos.method_10260(), app.getInfo().getFormattedId(), container));
            }
            if (app instanceof SystemApp) {
                ((SystemApp)app).setLaptop(null);
            }
            window.handleClose();
            this.windows.remove(i);
            return;
        }
    }

    private void addWindow(Window<Application> window) {
        if (this.hasReachedWindowLimit()) {
            return;
        }
        this.updateWindowStack();
        this.windows.add(0, window);
    }

    private void updateWindowStack() {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            if (this.windows.get(i) == null || i + 1 >= this.windows.size() || i != 0 && this.windows.get(i - 1) == null || this.windows.get(i + 1) != null) continue;
            this.windows.add(i + 1, this.windows.get(i));
            this.windows.remove(i);
        }
    }

    private boolean hasReachedWindowLimit() {
        return false;
    }

    private boolean isMouseOnScreen(int mouseX, int mouseY) {
        int posX = (this.field_22789 - 364) / 2;
        int posY = (this.field_22790 - 196) / 2;
        return this.isMouseInside(mouseX, mouseY, posX, posY, posX + 364, posY + 196);
    }

    private boolean isMouseWithinWindowBar(int mouseX, int mouseY, Window<?> window) {
        if (window == null) {
            return false;
        }
        int posX = (this.field_22789 - 364) / 2;
        int posY = (this.field_22790 - 196) / 2;
        return this.isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 1, posX + window.offsetX + window.width - 13, posY + window.offsetY + 11);
    }

    private boolean isMouseWithinWindow(int mouseX, int mouseY, Window<?> window) {
        if (window == null) {
            return false;
        }
        int posX = (this.field_22789 - 364) / 2;
        int posY = (this.field_22790 - 196) / 2;
        return this.isMouseInside(mouseX, mouseY, posX + window.offsetX, posY + window.offsetY, posX + window.offsetX + window.width, posY + window.offsetY + window.height);
    }

    public boolean isMouseWithinApp(int mouseX, int mouseY, Window<?> window) {
        int posX = (this.field_22789 - 364) / 2;
        int posY = (this.field_22790 - 196) / 2;
        return this.isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 13, posX + window.offsetX + window.width - 1, posY + window.offsetY + window.height - 1);
    }

    public boolean isApplicationRunning(AppInfo info) {
        for (Window<?> window : this.windows) {
            if (window == null || ((Application)window.content).getInfo() != info) continue;
            return true;
        }
        return false;
    }

    public void nextWallpaper() {
        if (!this.currentWallpaper.isBuiltIn()) {
            return;
        }
        if (this.currentWallpaper.location + 1 < WALLPAPERS.size()) {
            this.currentWallpaper = new Wallpaper(this.currentWallpaper.location + 1);
        }
        this.wallpaperUpdated();
    }

    public void prevWallpaper() {
        if (this.currentWallpaper.location - 1 >= 0) {
            this.currentWallpaper = new Wallpaper(this.currentWallpaper.location - 1);
        }
        this.wallpaperUpdated();
    }

    private void wallpaperUpdated() {
        if (this.currentWallpaper.isBuiltIn()) {
            this.wallpaper.setImage(WALLPAPERS.get(this.currentWallpaper.location));
        } else {
            this.wallpaper.setImage(this.currentWallpaper.url);
        }
    }

    public void setWallpaper(String url) {
        this.currentWallpaper = new Wallpaper(url);
        this.wallpaperUpdated();
    }

    public void setWallpaper(int wall) {
        this.currentWallpaper = new Wallpaper(wall);
        this.wallpaperUpdated();
    }

    public Wallpaper getCurrentWallpaper() {
        return this.currentWallpaper;
    }

    public List<class_2960> getWallapapers() {
        return ImmutableList.copyOf(WALLPAPERS);
    }

    @Nullable
    public Application getApplication(String appId) {
        return APPLICATIONS.stream().filter(app -> app.getInfo().getFormattedId().equals(appId)).findFirst().orElse(null);
    }

    public List<AppInfo> getInstalledApplications() {
        return ImmutableList.copyOf(this.installedApps);
    }

    public boolean isApplicationInstalled(AppInfo info) {
        return info.isSystemApp() || this.installedApps.contains(info);
    }

    public boolean isApplicationNotInstalled(AppInfo info) {
        return !this.isApplicationInstalled(info);
    }

    private boolean isValidApplication(AppInfo info) {
        if (Devices.hasAllowedApplications()) {
            return Devices.getAllowedApplications().contains(info);
        }
        return true;
    }

    private boolean isInvalidApplication(AppInfo info) {
        return !this.isValidApplication(info);
    }

    public void installApplication(AppInfo info, @Nullable Callback<Object> callback) {
        if (this.isValidApplication(info)) {
            TaskInstallApp task = new TaskInstallApp(info, pos, true);
            task.setCallback((tag, success) -> {
                if (success) {
                    this.installedApps.add(info);
                    this.installedApps.sort(AppInfo.SORT_NAME);
                }
                if (callback != null) {
                    callback.execute(null, success);
                }
            });
            TaskManager.sendTask(task);
        }
    }

    public void removeApplication(AppInfo info, @Nullable Callback<Object> callback) {
        if (!this.isValidApplication(info)) {
            return;
        }
        TaskInstallApp task = new TaskInstallApp(info, pos, false);
        task.setCallback((tag, success) -> {
            if (success) {
                this.installedApps.remove(info);
            }
            if (callback != null) {
                callback.execute(null, success);
            }
        });
        TaskManager.sendTask(task);
    }

    public List<Application> getApplications() {
        return APPLICATIONS;
    }

    public TaskBar getTaskBar() {
        return this.bar;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void openContext(Layout layout, int x, int y) {
        layout.updateComponents(x, y);
        this.context = layout;
        layout.init();
    }

    @Override
    public boolean hasContext() {
        return this.context != null;
    }

    @Override
    public void closeContext() {
        this.context = null;
        this.dragging = false;
    }

    static {
        LAPTOP_GUI = new class_2960("devices", "textures/gui/laptop.png");
        APPLICATIONS = new ArrayList<Application>();
        WALLPAPERS = new ArrayList<class_2960>();
        tasks = new CopyOnWriteArrayList<Runnable>();
    }

    public static final class Wallpaper {
        private final String url;
        private final int location;

        public String getUrl() {
            return this.url;
        }

        public int getLocation() {
            return this.location;
        }

        private Wallpaper(class_2487 tag) {
            String a = tag.method_10558("url");
            int b = tag.method_10550("location");
            if (tag.method_10573("url", 8)) {
                this.url = a;
                this.location = -87;
            } else {
                this.url = null;
                this.location = b;
            }
        }

        private Wallpaper(String url) {
            this.url = url;
            this.location = -87;
        }

        private Wallpaper(int location) {
            this.location = location;
            this.url = null;
        }

        public boolean isBuiltIn() {
            return this.location != -87;
        }

        public class_2520 serialize() {
            class_2487 a = new class_2487();
            if (this.isBuiltIn()) {
                a.method_10569("location", this.location);
            } else {
                a.method_10582("url", this.url);
            }
            return a;
        }
    }

    private static final class BSOD {
        private final Throwable throwable;

        public BSOD(Throwable e) {
            this.throwable = e;
        }
    }
}

