/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.TrayItemAdder;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.event.LaptopEvent;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.core.network.TrayItemWifi;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.object.TrayItem;
import com.ultreon.devices.programs.system.AppStore;
import com.ultreon.devices.programs.system.FileBrowserApp;
import com.ultreon.devices.programs.system.SettingsApp;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.util.Vulnerability;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TaskBar {
    public static final class_2960 APP_BAR_GUI = new class_2960("devices:textures/gui/application_bar.png");
    public static final int BAR_HEIGHT = 18;
    private static final int APPS_DISPLAYED = 10;
    private final Laptop laptop;
    private final int offset = 0;
    private final int pingTimer = 0;
    private final List<TrayItem> trayItems = new ArrayList<TrayItem>();
    private static final Marker MARKER = MarkerFactory.getMarker((String)"TaskBar");

    public TaskBar(Laptop laptop) {
        this.laptop = laptop;
        this.trayItems.add(new Vulnerability.VulnerabilityTrayItem());
        this.trayItems.add(new FileBrowserApp.FileBrowserTrayItem());
        this.trayItems.add(new SettingsApp.SettingsTrayItem());
        this.trayItems.add(new AppStore.StoreTrayItem());
        this.trayItems.add(new TrayItemWifi());
        TrayItemAdder trayItemAdder = new TrayItemAdder(this.trayItems);
        ((LaptopEvent.SetupTrayItems)LaptopEvent.SETUP_TRAY_ITEMS.invoker()).setupTrayItems(laptop, trayItemAdder);
    }

    public void init() {
        this.trayItems.forEach(TrayItem::init);
    }

    public void setupApplications(List<Application> applications) {
        Predicate<Application> VALID_APPS = app -> {
            if (app instanceof SystemApp) {
                return true;
            }
            if (Devices.hasAllowedApplications()) {
                return Devices.getAllowedApplications().contains(app.getInfo());
            }
            return true;
        };
    }

    public void init(int posX, int posY) {
        this.init();
    }

    public void onTick() {
        this.trayItems.forEach(TrayItem::tick);
    }

    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int appIndex;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)APP_BAR_GUI);
        Color bgColor = new Color(laptop.getSettings().getColorScheme().getBackgroundColor());
        float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
        bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        RenderSystem.setShaderColor((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
        int trayItemsWidth = this.trayItems.size() * 14;
        class_332.method_25293((class_4587)pose, (int)x, (int)y, (int)1, (int)18, (float)0.0f, (float)0.0f, (int)1, (int)18, (int)256, (int)256);
        class_332.method_25293((class_4587)pose, (int)(x + 1), (int)y, (int)(328 - trayItemsWidth), (int)18, (float)1.0f, (float)0.0f, (int)1, (int)18, (int)256, (int)256);
        class_332.method_25293((class_4587)pose, (int)(x + 364 - 35 - trayItemsWidth), (int)y, (int)(35 + trayItemsWidth), (int)18, (float)2.0f, (float)0.0f, (int)1, (int)18, (int)256, (int)256);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < 10 && i < laptop.installedApps.size(); ++i) {
            AppInfo info = laptop.installedApps.get(i + 0);
            RenderUtil.drawApplicationIcon(pose, info, x + 2 + i * 16, y + 2);
            if (!laptop.isApplicationRunning(info)) continue;
            RenderSystem.setShaderTexture((int)0, (class_2960)APP_BAR_GUI);
            laptop.method_25302(pose, x + 1 + i * 16, y + 1, 35, 0, 16, 16);
        }
        assert (mc.field_1687 == null || mc.field_1724 != null);
        mc.field_1772.method_29342(pose, this.timeToString(mc.field_1687 != null ? mc.field_1687.method_8532() : 0L), (float)(x + 334), (float)(y + 5), Color.WHITE.getRGB(), true);
        int startX = x + 317;
        for (int i = 0; i < this.trayItems.size(); ++i) {
            int posX = startX - (this.trayItems.size() - 1 - i) * 14;
            if (this.isMouseInside(mouseX, mouseY, posX, y + 2, posX + 13, y + 15)) {
                class_329.method_25294((class_4587)pose, (int)posX, (int)(y + 2), (int)(posX + 14), (int)(y + 16), (int)new Color(1.0f, 1.0f, 1.0f, 0.1f).getRGB());
            }
            this.trayItems.get(i).getIcon().draw(pose, mc, posX + 2, y + 4);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)APP_BAR_GUI);
        if (this.isMouseInside(mouseX, mouseY, x + 1, y + 1, x + 236, y + 16) && (appIndex = (mouseX - x - 1) / 16) >= 0 && appIndex < 10 && appIndex < laptop.installedApps.size()) {
            laptop.method_25302(pose, x + appIndex * 16 + 1, y + 1, 35, 0, 16, 16);
            laptop.method_30901(pose, List.of(class_2561.method_43470((String)laptop.installedApps.get(appIndex).getName())), mouseX, mouseY);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void handleClick(Laptop laptop, int x, int y, int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseInside(mouseX, mouseY, x + 1, y + 1, x + 236, y + 16)) {
            Devices.LOGGER.debug(MARKER, "Clicked on task bar");
            int appIndex = (mouseX - x - 1) / 16;
            if (appIndex >= 0 && appIndex <= 10 && appIndex < laptop.installedApps.size()) {
                laptop.openApplication(laptop.installedApps.get(appIndex));
                return;
            }
        }
        int startX = x + 317;
        for (int i = 0; i < this.trayItems.size(); ++i) {
            int posX = startX - (this.trayItems.size() - 1 - i) * 14;
            if (!this.isMouseInside(mouseX, mouseY, posX, y + 2, posX + 13, y + 15)) continue;
            TrayItem trayItem = this.trayItems.get(i);
            trayItem.handleClick(mouseX, mouseY, mouseButton);
            Devices.LOGGER.debug(MARKER, "Clicked on tray item (%d): %s".formatted(i, trayItem.getClass().getSimpleName()));
            break;
        }
    }

    public boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public String timeToString(long time) {
        int hours = (int)((Math.floor((double)time / 1000.0) + 6.0) % 24.0);
        int minutes = (int)Math.floor((double)(time % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }

    public Laptop getLaptop() {
        return this.laptop;
    }
}

