/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.app.Dialog;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.core.Wrappable;
import com.ultreon.devices.gui.GuiButtonClose;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class Window<T extends Wrappable> {
    public static final class_2960 WINDOW_GUI = new class_2960("devices:textures/gui/application.png");
    public static final int Color_WINDOW_DARK = new Color(0.0f, 0.0f, 0.0f, 0.25f).getRGB();
    final Laptop laptop;
    protected GuiButtonClose btnClose;
    T content;
    int width;
    int height;
    int offsetX;
    int offsetY;
    Window<Dialog> dialogWindow = null;
    Window<? extends Wrappable> parent = null;
    protected boolean removed;

    public Window(T wrappable, Laptop laptop) {
        this.content = wrappable;
        this.laptop = laptop;
        ((Wrappable)wrappable).setWindow(this);
    }

    void setWidth(int width) {
        this.width = width + 2;
        if (this.width > 364) {
            this.width = 364;
        }
    }

    void setHeight(int height) {
        this.height = height + 14;
        if (this.height > 178) {
            this.height = 178;
        }
    }

    void init(int x, int y, @Nullable class_2487 intent) {
        try {
            this.btnClose = new GuiButtonClose(x + this.offsetX + this.width - 12, y + this.offsetY + 1);
            ((Wrappable)this.content).init(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            Dialog.Message message = new Dialog.Message("Error initializing window:\n" + e.getMessage()){

                @Override
                public void onClose() {
                    super.onClose();
                }
            };
            this.closeDialog();
            this.openDialog(message);
        }
    }

    public void onTick() {
        if (this.dialogWindow != null) {
            this.dialogWindow.onTick();
        }
        ((Wrappable)this.content).onTick();
    }

    public void render(class_4587 pose, Laptop gui, class_310 mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        if (((Wrappable)this.content).isPendingLayoutUpdate()) {
            this.setWidth(((Wrappable)this.content).getWidth());
            this.setHeight(((Wrappable)this.content).getHeight());
            this.offsetX = (364 - this.width) / 2;
            this.offsetY = (178 - this.height) / 2;
            this.updateComponents(x, y);
            ((Wrappable)this.content).clearPendingLayout();
        }
        pose.method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW_GUI);
        gui.method_25302(pose, x + this.offsetX, y + this.offsetY, 0, 0, 1, 13);
        gui.method_25302(pose, x + this.offsetX + this.width - 13, y + this.offsetY, 2, 0, 13, 13);
        gui.method_25302(pose, x + this.offsetX + this.width - 1, y + this.offsetY + this.height - 1, 14, 14, 1, 1);
        gui.method_25302(pose, x + this.offsetX, y + this.offsetY + this.height - 1, 0, 14, 1, 1);
        class_332.method_25293((class_4587)pose, (int)(x + this.offsetX + 1), (int)(y + this.offsetY), (int)(this.width - 14), (int)13, (float)1.0f, (float)0.0f, (int)1, (int)13, (int)256, (int)256);
        class_332.method_25293((class_4587)pose, (int)(x + this.offsetX + this.width - 1), (int)(y + this.offsetY + 13), (int)1, (int)(this.height - 14), (float)14.0f, (float)13.0f, (int)1, (int)1, (int)256, (int)256);
        class_332.method_25293((class_4587)pose, (int)(x + this.offsetX + 1), (int)(y + this.offsetY + this.height - 1), (int)(this.width - 2), (int)1, (float)1.0f, (float)14.0f, (int)13, (int)1, (int)256, (int)256);
        class_332.method_25293((class_4587)pose, (int)(x + this.offsetX), (int)(y + this.offsetY + 13), (int)1, (int)(this.height - 14), (float)0.0f, (float)13.0f, (int)1, (int)1, (int)256, (int)256);
        class_332.method_25293((class_4587)pose, (int)(x + this.offsetX + 1), (int)(y + this.offsetY + 13), (int)(this.width - 2), (int)(this.height - 14), (float)1.0f, (float)13.0f, (int)13, (int)1, (int)256, (int)256);
        String windowTitle = ((Wrappable)this.content).getWindowTitle();
        if (mc.field_1772.method_1727(windowTitle) > this.width - 2 - 13 - 3) {
            windowTitle = mc.field_1772.method_27523(windowTitle, this.width - 2 - 13 - 3);
        }
        mc.field_1772.method_29342(pose, windowTitle, (float)(x + this.offsetX + 3), (float)(y + this.offsetY + 3), Color.WHITE.getRGB(), true);
        this.btnClose.method_25359(pose, mouseX, mouseY, partialTicks);
        RenderSystem.disableBlend();
        ((Wrappable)this.content).render(pose, gui, mc, x + this.offsetX + 1, y + this.offsetY + 13, mouseX, mouseY, active && this.dialogWindow == null, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.dialogWindow != null) {
            class_329.method_25294((class_4587)pose, (int)(x + this.offsetX), (int)(y + this.offsetY), (int)(x + this.offsetX + this.width), (int)(y + this.offsetY + this.height), (int)Color_WINDOW_DARK);
            this.dialogWindow.render(pose, gui, mc, x, y, mouseX, mouseY, active, partialTicks);
        }
        pose.method_22909();
    }

    @Deprecated
    public void handleKeyTyped(char character, int code) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyTyped(character, code);
            return;
        }
        ((Wrappable)this.content).handleKeyTyped(character, code);
    }

    @Deprecated
    public void handleKeyReleased(char character, int code) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyReleased(character, code);
            return;
        }
        ((Wrappable)this.content).handleKeyReleased(character, code);
    }

    public void handleCharTyped(char codePoint, int modifiers) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleCharTyped(codePoint, modifiers);
            return;
        }
        ((Wrappable)this.content).handleCharTyped(codePoint, modifiers);
    }

    public void handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyPressed(keyCode, scanCode, modifiers);
            return;
        }
        ((Wrappable)this.content).handleKeyPressed(keyCode, scanCode, modifiers);
    }

    public void handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyReleased(keyCode, scanCode, modifiers);
            return;
        }
        ((Wrappable)this.content).handleKeyReleased(keyCode, scanCode, modifiers);
    }

    public void handleWindowMove(int screenStartX, int screenStartY, int mouseDX, int mouseDY) {
        int newX = this.offsetX + mouseDX;
        int newY = this.offsetY + mouseDY;
        this.offsetX = newX >= 0 && newX <= 364 - this.width ? newX : (newX < 0 ? 0 : 364 - this.width);
        this.offsetY = newY >= 0 && newY <= 178 - this.height ? newY : (newY < 0 ? 0 : 178 - this.height);
        this.updateComponents(screenStartX, screenStartY);
    }

    void handleMouseClick(Laptop gui, int x, int y, int mouseX, int mouseY, int mouseButton) {
        if (this.btnClose.isHovered()) {
            if (this.content instanceof Application) {
                gui.closeApplication(((Application)this.content).getInfo());
                return;
            }
            if (this.parent != null) {
                this.parent.closeDialog();
            }
        }
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseClick(gui, x, y, mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseClick(mouseX, mouseY, mouseButton);
    }

    void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseDrag(mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseDrag(mouseX, mouseY, mouseButton);
    }

    void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseRelease(mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseRelease(mouseX, mouseY, mouseButton);
    }

    void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseScroll(mouseX, mouseY, direction);
            return;
        }
        ((Wrappable)this.content).handleMouseScroll(mouseX, mouseY, direction);
    }

    public void handleClose() {
        ((Wrappable)this.content).onClose();
    }

    private void updateComponents(int x, int y) {
        ((Wrappable)this.content).updateComponents(x + this.offsetX + 1, y + this.offsetY + 13);
        this.btnClose.field_22760 = x + this.offsetX + this.width - 12;
        this.btnClose.field_22761 = y + this.offsetY + 1;
    }

    public void openDialog(Dialog dialog) {
        if (this.dialogWindow != null) {
            this.dialogWindow.openDialog(dialog);
        } else {
            this.dialogWindow = new Window<Dialog>(dialog, null);
            this.dialogWindow.init(0, 0, null);
            this.dialogWindow.setParent(this);
        }
    }

    public void closeDialog() {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleClose();
            this.dialogWindow = null;
        }
    }

    public Window<Dialog> getDialogWindow() {
        return this.dialogWindow;
    }

    public final void close() {
        this.removed = true;
        if (this.content instanceof Application) {
            this.laptop.closeApplication(((Application)this.content).getInfo());
            return;
        }
        if (this.parent != null) {
            this.parent.closeDialog();
        }
    }

    public Window getParent() {
        return this.parent;
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public T getContent() {
        return this.content;
    }
}

