/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.io;

import com.ultreon.devices.Devices;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.io.Drive;
import com.ultreon.devices.api.io.Folder;
import com.ultreon.devices.api.task.Callback;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.core.io.ServerFolder;
import com.ultreon.devices.core.io.action.FileAction;
import com.ultreon.devices.core.io.drive.AbstractDrive;
import com.ultreon.devices.core.io.drive.ExternalDrive;
import com.ultreon.devices.core.io.drive.InternalDrive;
import com.ultreon.devices.core.io.task.TaskGetFiles;
import com.ultreon.devices.core.io.task.TaskGetMainDrive;
import com.ultreon.devices.core.io.task.TaskSendAction;
import com.ultreon.devices.init.DeviceItems;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class FileSystem {
    public static final Pattern PATTERN_FILE_NAME = Pattern.compile("^[\\w'. ]{1,32}$");
    public static final Pattern PATTERN_DIRECTORY = Pattern.compile("^(/)|(/[\\w'. ]{1,32})*$");
    public static final String DIR_ROOT = "/";
    public static final String DIR_APPLICATION_DATA = "/Application Data";
    public static final String DIR_HOME = "/Home";
    public static final String LAPTOP_DRIVE_NAME = "Root";
    private AbstractDrive mainDrive = null;
    private final Map<UUID, AbstractDrive> additionalDrives = new HashMap<UUID, AbstractDrive>();
    private AbstractDrive attachedDrive = null;
    private class_1767 attachedDriveColor = class_1767.field_7964;
    private final LaptopBlockEntity blockEntity;

    public FileSystem(LaptopBlockEntity blockEntity, class_2487 tag) {
        this.blockEntity = blockEntity;
        this.load(tag);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendAction(Drive drive, FileAction action, @Nullable Callback<Response> callback) {
        if (Laptop.getPos() != null) {
            System.out.println("Sending action " + action + " to " + drive);
            TaskSendAction task = new TaskSendAction(drive, action);
            task.setCallback((tag, success) -> {
                System.out.println("Action " + action + " sent to " + drive + ": " + success);
                if (callback != null) {
                    assert (tag != null);
                    System.out.println("Callback: " + tag.method_10558("response"));
                    callback.execute(Response.fromTag(tag.method_10562("response")), success);
                }
            });
            TaskManager.sendTask(task);
        } else {
            System.out.println("Sending action " + action + " to " + drive + " failed: Laptop not found");
        }
    }

    public static void getApplicationFolder(Application app, Callback<Folder> callback) {
        if (Devices.hasAllowedApplications() && !Devices.getAllowedApplications().contains(app.getInfo())) {
            callback.execute(null, false);
            return;
        }
        if (Laptop.getMainDrive() == null) {
            TaskGetMainDrive task = new TaskGetMainDrive(Laptop.getPos());
            task.setCallback((tag, success) -> {
                if (success) {
                    FileSystem.setupApplicationFolder(app, callback);
                } else {
                    callback.execute(null, false);
                }
            });
            TaskManager.sendTask(task);
        } else {
            FileSystem.setupApplicationFolder(app, callback);
        }
    }

    private static void setupApplicationFolder(Application app, Callback<Folder> callback) {
        assert (Laptop.getMainDrive() != null);
        Folder folder = Laptop.getMainDrive().getFolder(DIR_APPLICATION_DATA);
        if (folder != null) {
            if (folder.hasFolder(app.getInfo().getFormattedId())) {
                Folder appFolder = folder.getFolder(app.getInfo().getFormattedId());
                assert (appFolder != null);
                if (appFolder.isSynced()) {
                    callback.execute(appFolder, true);
                } else {
                    TaskGetFiles task = new TaskGetFiles(appFolder, Laptop.getPos());
                    task.setCallback((tag, success) -> {
                        assert (tag != null);
                        if (success && tag.method_10573("files", 9)) {
                            class_2499 files = tag.method_10554("files", 10);
                            appFolder.syncFiles(files);
                            callback.execute(appFolder, true);
                        } else {
                            callback.execute(null, false);
                        }
                    });
                    TaskManager.sendTask(task);
                }
            } else {
                Folder appFolder = new Folder(app.getInfo().getFormattedId());
                folder.add(appFolder, (response, success) -> {
                    if (response != null && response.getStatus() == 1) {
                        callback.execute(appFolder, true);
                    } else {
                        callback.execute(null, false);
                    }
                });
            }
        } else {
            System.out.println("Application data folder is not initialized");
            callback.execute(null, false);
        }
    }

    public static Response createSuccessResponse() {
        return new Response(1);
    }

    public static Response createResponse(int status, String message) {
        return new Response(status, message);
    }

    private void load(class_2487 tag) {
        System.out.println(tag);
        if (tag.method_10573("main_drive", 10)) {
            this.mainDrive = InternalDrive.fromTag(tag.method_10562("main_drive"));
        }
        if (tag.method_10573("drives", 9)) {
            class_2499 list = tag.method_10554("drives", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 driveTag = list.method_10602(i);
                AbstractDrive drive = InternalDrive.fromTag(driveTag.method_10562("drive"));
                this.additionalDrives.put(drive.getUuid(), drive);
            }
        }
        if (tag.method_10573("external_drive", 10)) {
            this.attachedDrive = ExternalDrive.fromTag(tag.method_10562("external_drive"));
        }
        if (tag.method_10573("external_drive_color", 1)) {
            this.attachedDriveColor = class_1767.method_7791((int)tag.method_10571("external_drive_color"));
        }
        this.setupDefault();
    }

    private void setupDefault() {
        if (this.mainDrive == null) {
            InternalDrive drive = new InternalDrive(LAPTOP_DRIVE_NAME);
            ServerFolder root = drive.getRoot(this.blockEntity.method_10997());
            root.add(this.createProtectedFolder("Home"), false);
            root.add(this.createProtectedFolder("Application Data"), false);
            this.mainDrive = drive;
            this.blockEntity.method_5431();
        }
    }

    private ServerFolder createProtectedFolder(String name) {
        try {
            Constructor constructor = ServerFolder.class.getDeclaredConstructor(String.class, Boolean.TYPE);
            constructor.setAccessible(true);
            return (ServerFolder)constructor.newInstance(name, true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Response readAction(String driveUuid, FileAction action, class_1937 level) {
        UUID uuid = UUID.fromString(driveUuid);
        AbstractDrive drive = this.getAvailableDrives(level, true).get(uuid);
        if (drive != null) {
            Response response = drive.handleFileAction(this, action, level);
            if (response.getStatus() == 1) {
                this.blockEntity.method_5431();
            }
            return response;
        }
        return FileSystem.createResponse(7, "Drive unavailable or missing");
    }

    public AbstractDrive getMainDrive() {
        return this.mainDrive;
    }

    public Map<UUID, AbstractDrive> getAvailableDrives(@Nullable class_1937 level, boolean includeMain) {
        LinkedHashMap<UUID, AbstractDrive> drives = new LinkedHashMap<UUID, AbstractDrive>();
        if (includeMain) {
            drives.put(this.mainDrive.getUuid(), this.mainDrive);
        }
        drives.putAll(this.additionalDrives);
        return drives;
    }

    public boolean setAttachedDrive(class_1799 flashDrive) {
        class_2487 flashDriveTag;
        AbstractDrive drive;
        if (this.attachedDrive == null && (drive = ExternalDrive.fromTag((flashDriveTag = this.getExternalDriveTag(flashDrive)).method_10562("drive"))) != null) {
            drive.setName(flashDrive.method_7954().getString());
            this.attachedDrive = drive;
            this.attachedDriveColor = class_1767.method_7791((int)flashDriveTag.method_10571("color"));
            this.blockEntity.getPipeline().method_10567("external_drive_color", (byte)this.attachedDriveColor.method_7789());
            this.blockEntity.sync();
            return true;
        }
        return false;
    }

    public AbstractDrive getAttachedDrive() {
        return this.attachedDrive;
    }

    public class_1767 getAttachedDriveColor() {
        return this.attachedDriveColor;
    }

    @Nullable
    public class_1799 removeAttachedDrive() {
        if (this.attachedDrive != null) {
            class_1799 stack = new class_1799((class_1935)DeviceItems.getFlashDriveByColor(this.attachedDriveColor), 1);
            stack.method_7977((class_2561)class_2561.method_43470((String)this.attachedDrive.getName()));
            stack.method_7948().method_10566("drive", (class_2520)this.attachedDrive.toTag());
            this.attachedDrive = null;
            return stack;
        }
        return null;
    }

    private class_2487 getExternalDriveTag(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            tag = new class_2487();
            tag.method_10566("drive", (class_2520)new ExternalDrive(stack.method_7954().getString()).toTag());
            stack.method_7980(tag);
        } else if (tag.method_10573("drive", 10)) {
            tag.method_10566("drive", (class_2520)new ExternalDrive(stack.method_7954().getString()).toTag());
        }
        return tag;
    }

    public class_2487 toTag() {
        class_2487 fileSystemTag = new class_2487();
        if (this.mainDrive != null) {
            fileSystemTag.method_10566("main_drive", (class_2520)this.mainDrive.toTag());
        }
        class_2499 list = new class_2499();
        this.additionalDrives.forEach((k, v) -> list.add((Object)v.toTag()));
        fileSystemTag.method_10566("drives", (class_2520)list);
        if (this.attachedDrive != null) {
            fileSystemTag.method_10566("external_drive", (class_2520)this.attachedDrive.toTag());
            fileSystemTag.method_10567("external_drive_color", (byte)this.attachedDriveColor.method_7789());
        }
        return fileSystemTag;
    }

    public static class Response {
        private final int status;
        private String message = "";

        private Response(int status) {
            this.status = status;
        }

        private Response(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public static Response fromTag(class_2487 responseTag) {
            return new Response(responseTag.method_10550("status"), responseTag.method_10558("message"));
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public class_2487 toTag() {
            class_2487 responseTag = new class_2487();
            responseTag.method_10569("status", this.status);
            responseTag.method_10582("message", this.message);
            return responseTag;
        }
    }

    public static final class Status {
        public static final int FAILED = 0;
        public static final int SUCCESSFUL = 1;
        public static final int FILE_INVALID = 2;
        public static final int FILE_IS_PROTECTED = 3;
        public static final int FILE_EXISTS = 4;
        public static final int FILE_INVALID_NAME = 5;
        public static final int FILE_INVALID_DATA = 6;
        public static final int DRIVE_UNAVAILABLE = 7;
    }
}

