/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.io;

import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.io.MimeType;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.ServerFolder;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ServerFile {
    public static final Comparator<ServerFile> SORT_BY_NAME = (f1, f2) -> {
        if (f1.isFolder() && !f2.isFolder()) {
            return -1;
        }
        if (!f1.isFolder() && f2.isFolder()) {
            return 1;
        }
        return f1.name.compareTo(f2.name);
    };
    private MimeType mimeType = MimeType.APPLICATION_OCTET_STREAM;
    protected ServerFolder parent;
    protected String name;
    protected String openingApp;
    protected class_2487 data;
    protected boolean protect = false;
    protected long lastModified;
    protected long lastAccessed;
    protected long creationTime;

    protected ServerFile() {
    }

    public ServerFile(String name, Application app, class_2487 data) {
        this(name, app.getInfo().getFormattedId(), data, false);
    }

    public ServerFile(String name, String openingAppId, class_2487 data) {
        this(name, openingAppId, data, false);
    }

    public ServerFile(String name, String openingAppId, MimeType mimeType, class_2487 data) {
        this(name, openingAppId, data, mimeType, false);
    }

    private ServerFile(String name, String openingAppId, class_2487 data, boolean protect) {
        this(name, openingAppId, data, MimeType.APPLICATION_OCTET_STREAM, protect);
    }

    private ServerFile(String name, String openingAppId, class_2487 data, MimeType mimeType, boolean protect) {
        this.name = name;
        this.openingApp = openingAppId;
        this.data = data;
        this.mimeType = mimeType;
        this.protect = protect;
        this.lastModified = this.creationTime = System.currentTimeMillis();
        this.lastAccessed = this.creationTime;
    }

    private ServerFile(String name, boolean protect, class_2487 tag) {
        this.openingApp = tag.method_10558("openingApp");
        this.name = name;
        this.data = tag.method_10562("data");
        this.creationTime = tag.method_10537("creationTime");
        this.lastModified = tag.method_10537("lastModified");
        this.lastAccessed = tag.method_10537("lastAccessed");
        this.protect = protect;
        this.mimeType = MimeType.of(tag.method_10562("mimeType"));
    }

    public String getName() {
        return this.name;
    }

    public FileSystem.Response rename(String name) {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot rename a protected file");
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(name).matches()) {
            return FileSystem.createResponse(5, "Invalid file name");
        }
        this.name = name;
        this.lastModified = System.currentTimeMillis();
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public String getOpeningApp() {
        return this.openingApp;
    }

    public FileSystem.Response setData(class_2487 data) {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot set data on a protected file");
        }
        if (data == null) {
            return FileSystem.createResponse(6, "Invalid data");
        }
        this.data = data;
        this.lastModified = System.currentTimeMillis();
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public class_2487 getData() {
        class_2487 data1 = this.data.method_10553();
        this.lastAccessed = System.currentTimeMillis();
        return data1;
    }

    @Nullable
    public ServerFolder getParent() {
        return this.parent;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public boolean isFolder() {
        return false;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public boolean isForApplication(Application app) {
        return this.openingApp != null && this.openingApp.equals(app.getInfo().getFormattedId());
    }

    public FileSystem.Response delete() {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot delete a protected file");
        }
        if (this.parent != null) {
            return this.parent.delete(this);
        }
        return FileSystem.createResponse(2, "Invalid file");
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("openingApp", this.openingApp);
        tag.method_10544("lastModified", this.lastModified);
        tag.method_10544("lastAccessed", this.lastAccessed);
        tag.method_10544("creationTime", this.creationTime);
        tag.method_10566("data", (class_2520)this.data);
        return tag;
    }

    public static ServerFile fromTag(String name, class_2487 tag) {
        return new ServerFile(name, false, tag);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerFile)) {
            return false;
        }
        return ((ServerFile)obj).name.equalsIgnoreCase(this.name);
    }

    public ServerFile copy() {
        return new ServerFile(this.name, this.openingApp, this.data.method_10553());
    }

    void onCreate() {
        this.creationTime = System.currentTimeMillis();
    }
}

