/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.io;

import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.ServerFile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class ServerFolder
extends ServerFile {
    private List<ServerFile> files = new ArrayList<ServerFile>();
    private final Object interrupt = new Object();

    public ServerFolder(String name) {
        this(name, false);
    }

    private ServerFolder(String name, boolean protect) {
        this.name = name;
        this.protect = protect;
    }

    private ServerFolder(String name, boolean protect, class_2487 tag) {
        this.name = name;
        this.protect = protect;
        this.creationTime = tag.method_10537("creationTime");
        this.lastModified = tag.method_10537("lastModified");
        this.lastAccessed = tag.method_10537("lastAccessed");
    }

    public static ServerFolder fromTag(String name, class_2487 folderTag) {
        ServerFolder folder = new ServerFolder(name, false, folderTag);
        if (folderTag.method_10573("protected", 1)) {
            folder.protect = folderTag.method_10577("protected");
        }
        class_2487 fileList = folderTag.method_10562("files");
        for (String fileName : fileList.method_10541()) {
            class_2487 fileTag = fileList.method_10562(fileName);
            if (fileTag.method_10545("files")) {
                folder.add(ServerFolder.fromTag(fileName, fileTag), false);
                continue;
            }
            folder.add(ServerFile.fromTag(fileName, fileTag), false);
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem.Response add(ServerFile file, boolean override) {
        if (file == null) {
            return FileSystem.createResponse(2, "Illegal file");
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(file.getName()).matches()) {
            return FileSystem.createResponse(5, "Invalid file name");
        }
        Object object = this.interrupt;
        synchronized (object) {
            ServerFile child = this.getFile(file.name);
            if (child != null) {
                if (!override) {
                    return FileSystem.createResponse(4, "A file with that name already exists");
                }
                if (child.isProtected()) {
                    return FileSystem.createResponse(3, "Unable to override protected files");
                }
                this.files.remove(child);
            }
            this.files.add(file);
            file.parent = this;
            file.onCreate();
        }
        return FileSystem.createSuccessResponse();
    }

    public FileSystem.Response delete(String name) {
        return this.delete(this.getFile(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem.Response delete(ServerFile file) {
        if (file == null) {
            return FileSystem.createResponse(2, "Illegal file");
        }
        Object object = this.interrupt;
        synchronized (object) {
            if (!this.files.contains(file)) {
                return FileSystem.createResponse(2, "The file does not exist in this folder");
            }
            if (file.isProtected()) {
                return FileSystem.createResponse(3, "Cannot delete protected files");
            }
            file.parent = null;
            this.files.remove(file);
        }
        return FileSystem.createSuccessResponse();
    }

    public boolean hasFile(String name) {
        return this.files.stream().anyMatch(file -> file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public ServerFile getFile(String name) {
        return this.files.stream().filter(file -> file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public boolean hasFolder(String name) {
        return this.files.stream().anyMatch(file -> file.isFolder() && file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public ServerFolder getFolder(String name) {
        return this.files.stream().filter(file -> file.isFolder() && file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<ServerFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<ServerFile> files) {
        this.files = files;
    }

    public List<ServerFile> search(Predicate<ServerFile> conditions, boolean includeSubServerFolders) {
        class_2371 found = class_2371.method_10211();
        this.search((List<ServerFile>)found, conditions, includeSubServerFolders);
        return found;
    }

    private void search(List<ServerFile> results, Predicate<ServerFile> conditions, boolean includeSubServerFolders) {
        this.files.forEach(file -> {
            if (file.isFolder()) {
                if (includeSubServerFolders) {
                    ((ServerFolder)file).search(results, conditions, true);
                }
            } else if (conditions.test((ServerFile)file)) {
                results.add((ServerFile)file);
            }
        });
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public class_2487 toTag() {
        class_2487 folderTag = new class_2487();
        class_2487 fileList = new class_2487();
        this.files.forEach(file -> fileList.method_10566(file.getName(), (class_2520)file.toTag()));
        folderTag.method_10566("files", (class_2520)fileList);
        if (this.protect) {
            folderTag.method_10556("protected", true);
        }
        folderTag.method_10544("creationTime", this.creationTime);
        folderTag.method_10544("lastModified", this.lastModified);
        folderTag.method_10544("lastAccessed", this.lastAccessed);
        return folderTag;
    }

    @Override
    public FileSystem.Response setData(@Nonnull class_2487 data) {
        return FileSystem.createResponse(6, "Data can not be set to a folder");
    }

    @Override
    public ServerFile copy() {
        ServerFolder folder = new ServerFolder(this.name);
        this.files.forEach(f -> {
            ServerFile copy = f.copy();
            copy.protect = false;
            folder.add(copy, false);
        });
        return folder;
    }

    public ServerFolder copyStructure() {
        ServerFolder folder = new ServerFolder(this.name, this.protect);
        this.files.forEach(f -> {
            if (f.isFolder()) {
                folder.add(((ServerFolder)f).copyStructure(), false);
            }
        });
        return folder;
    }
}

