/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.io.drive;

import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.ServerFile;
import com.ultreon.devices.core.io.ServerFolder;
import com.ultreon.devices.core.io.action.FileAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDrive {
    protected String name;
    protected UUID uuid;
    protected ServerFolder root;

    AbstractDrive() {
    }

    AbstractDrive(String name) {
        this.name = name;
        this.uuid = UUID.randomUUID();
        this.root = AbstractDrive.createProtectedFolder("Root");
    }

    private static ServerFolder createProtectedFolder(String name) {
        try {
            Constructor constructor = ServerFolder.class.getDeclaredConstructor(String.class, Boolean.TYPE);
            constructor.setAccessible(true);
            return (ServerFolder)constructor.newInstance(name, true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ServerFolder getRoot(class_1937 level) {
        return this.root;
    }

    public FileSystem.Response handleFileAction(FileSystem fileSystem, FileAction action, class_1937 level) {
        class_2487 actionData = action.getData();
        ServerFolder folder = this.getFolder(actionData.method_10558("directory"));
        if (folder != null) {
            class_2487 data = actionData.method_10562("data");
            switch (action.getType()) {
                case NEW: {
                    if (data.method_10573("files", 10)) {
                        return folder.add(ServerFolder.fromTag(actionData.method_10558("file_name"), data), actionData.method_10577("override"));
                    }
                    return folder.add(ServerFile.fromTag(actionData.method_10558("file_name"), data), data.method_10577("override"));
                }
                case DELETE: {
                    return folder.delete(actionData.method_10558("file_name"));
                }
                case RENAME: {
                    ServerFile file = folder.getFile(actionData.method_10558("file_name"));
                    if (file != null) {
                        return file.rename(actionData.method_10558("new_file_name"));
                    }
                    return FileSystem.createResponse(2, "File not found on server. Please refresh!");
                }
                case DATA: {
                    ServerFile file = folder.getFile(actionData.method_10558("file_name"));
                    if (file != null) {
                        return file.setData(actionData.method_10562("data"));
                    }
                    return FileSystem.createResponse(2, "File not found on server. Please refresh!");
                }
                case COPY_CUT: {
                    ServerFile file = folder.getFile(actionData.method_10558("file_name"));
                    if (file != null) {
                        UUID uuid = UUID.fromString(actionData.method_10558("destination_drive"));
                        AbstractDrive drive = fileSystem.getAvailableDrives(level, true).get(uuid);
                        if (drive != null) {
                            ServerFolder destination = drive.getFolder(actionData.method_10558("destination_folder"));
                            if (destination != null) {
                                for (ServerFolder temp = destination; temp != null; temp = temp.getParent()) {
                                    if (temp != file) continue;
                                    return FileSystem.createResponse(0, "Destination folder can't be a subfolder");
                                }
                                FileSystem.Response response = destination.add(file.copy(), actionData.method_10577("override"));
                                if (response.getStatus() != 1) {
                                    return response;
                                }
                                if (actionData.method_10577("cut")) {
                                    return file.delete();
                                }
                                return FileSystem.createSuccessResponse();
                            }
                            return FileSystem.createResponse(2, "Destination folder not found on server. Please refresh!");
                        }
                        return FileSystem.createResponse(7, "Drive unavailable. Please refresh!");
                    }
                    return FileSystem.createResponse(2, "File not found on server. Please refresh!");
                }
            }
        }
        return FileSystem.createResponse(7, "Invalid directory");
    }

    public abstract class_2487 toTag();

    public abstract Type getType();

    @Nullable
    public ServerFolder getFolder(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The path can not be null");
        }
        if (!FileSystem.PATTERN_DIRECTORY.matcher(path).matches()) {
            throw new IllegalArgumentException("The path \"" + path + "\" does not follow the correct format");
        }
        if (path.equals("/")) {
            return this.root;
        }
        ServerFolder prev = this.root;
        String[] folders = path.split("/");
        if (folders.length > 0 && folders.length <= 10) {
            for (int i = 1; i < folders.length; ++i) {
                ServerFolder temp = prev.getFolder(folders[i]);
                if (temp == null) {
                    return null;
                }
                prev = temp;
            }
            return prev;
        }
        return null;
    }

    public ServerFolder getDriveStructure() {
        return this.root.copyStructure();
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL,
        NETWORK;

    }
}

