/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.io.task;

import com.ultreon.devices.api.io.Folder;
import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.ServerFile;
import com.ultreon.devices.core.io.ServerFolder;
import com.ultreon.devices.core.io.drive.AbstractDrive;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

public class TaskGetFiles
extends Task {
    private String uuid;
    private String path;
    private class_2338 pos;
    private List<ServerFile> files;

    public TaskGetFiles() {
        super("get_files");
    }

    public TaskGetFiles(Folder folder, class_2338 pos) {
        this();
        this.uuid = folder.getDrive().getUUID().toString();
        this.path = folder.getPath();
        this.pos = pos;
    }

    protected static String compileDirectory(ServerFile file) {
        if (file.getParent() == null || file.getParent().getParent() == null) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (ServerFolder parent = file.getParent(); parent != null; parent = parent.getParent()) {
            builder.insert(0, "/" + parent.getName());
            if (parent.getParent() == null) continue;
            return builder.toString();
        }
        return builder.toString();
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10582("uuid", this.uuid);
        tag.method_10582("path", this.path);
        tag.method_10544("pos", this.pos.method_10063());
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092((long)tag.method_10537("pos"))).method_12201(class_2338.method_10092((long)tag.method_10537("pos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof LaptopBlockEntity) {
            ServerFolder found;
            LaptopBlockEntity laptop = (LaptopBlockEntity)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            UUID uuid = UUID.fromString(tag.method_10558("uuid"));
            AbstractDrive serverDrive = fileSystem.getAvailableDrives(level, true).get(uuid);
            if (serverDrive != null && (found = serverDrive.getFolder(tag.method_10558("path"))) != null) {
                this.files = found.getFiles().stream().filter(f -> !f.isFolder()).collect(Collectors.toList());
                this.setSuccessful();
            }
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        if (this.files != null) {
            class_2499 list = new class_2499();
            this.files.forEach(f -> {
                class_2487 fileTag = new class_2487();
                fileTag.method_10582("file_name", f.getName());
                fileTag.method_10566("data", (class_2520)f.toTag());
                list.add((Object)fileTag);
            });
            tag.method_10566("files", (class_2520)list);
        }
    }

    @Override
    public void processResponse(class_2487 tag) {
    }
}

