/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.io.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.drive.AbstractDrive;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

public class TaskSetupFileBrowser
extends Task {
    private class_2338 pos;
    private boolean includeMain;
    private AbstractDrive mainDrive;
    private Map<UUID, AbstractDrive> availableDrives;

    public TaskSetupFileBrowser() {
        super("get_file_system");
    }

    public TaskSetupFileBrowser(class_2338 pos, boolean includeMain) {
        this();
        this.pos = pos;
        this.includeMain = includeMain;
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10544("pos", this.pos.method_10063());
        tag.method_10556("include_main", this.includeMain);
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092((long)tag.method_10537("pos"))).method_12201(class_2338.method_10092((long)tag.method_10537("pos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof LaptopBlockEntity) {
            LaptopBlockEntity laptop = (LaptopBlockEntity)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            if (tag.method_10577("include_main")) {
                this.mainDrive = fileSystem.getMainDrive();
            }
            this.availableDrives = fileSystem.getAvailableDrives(level, false);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        if (this.isSucessful()) {
            if (this.mainDrive != null) {
                class_2487 mainDriveTag = new class_2487();
                mainDriveTag.method_10582("name", this.mainDrive.getName());
                mainDriveTag.method_10582("uuid", this.mainDrive.getUuid().toString());
                mainDriveTag.method_10582("type", this.mainDrive.getType().toString());
                tag.method_10566("main_drive", (class_2520)mainDriveTag);
                tag.method_10566("structure", (class_2520)this.mainDrive.getDriveStructure().toTag());
            }
            class_2499 driveList = new class_2499();
            this.availableDrives.forEach((k, v) -> {
                class_2487 driveTag = new class_2487();
                driveTag.method_10582("name", v.getName());
                driveTag.method_10582("uuid", v.getUuid().toString());
                driveTag.method_10582("type", v.getType().toString());
                driveList.add((Object)driveTag);
            });
            tag.method_10566("available_drives", (class_2520)driveList);
        }
    }

    @Override
    public void processResponse(class_2487 tag) {
    }
}

