/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.network;

import com.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import com.ultreon.devices.core.Device;
import com.ultreon.devices.core.network.Router;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkDevice
extends Device {
    private NetworkDevice() {
    }

    public NetworkDevice(NetworkDeviceBlockEntity device) {
        super(device);
    }

    public NetworkDevice(@NotNull UUID id, @NotNull String name, @NotNull Router router) {
        super(id, name);
    }

    public boolean isConnected(class_1937 level) {
        if (this.pos == null) {
            return false;
        }
        class_2586 blockEntity = level.method_8321(this.pos);
        if (blockEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
            Router router = device.getRouter();
            return router != null && router.getId().equals(this.getId());
        }
        return false;
    }

    @Override
    @Nullable
    public NetworkDeviceBlockEntity getDevice(@NotNull class_1937 level) {
        if (this.pos == null) {
            return null;
        }
        class_2586 blockEntity = level.method_8321(this.pos);
        if (blockEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
            return device;
        }
        return null;
    }

    @Override
    public class_2487 toTag(boolean includePos) {
        class_2487 tag = super.toTag(includePos);
        if (includePos && this.pos != null) {
            tag.method_10544("pos", this.pos.method_10063());
        }
        return tag;
    }

    public static NetworkDevice fromTag(class_2487 tag) {
        NetworkDevice device = new NetworkDevice();
        device.id = UUID.fromString(tag.method_10558("id"));
        device.name = tag.method_10558("name");
        if (tag.method_10573("pos", 4)) {
            device.pos = class_2338.method_10092((long)tag.method_10537("pos"));
        }
        return device;
    }
}

