/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.network;

import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import com.ultreon.devices.core.network.NetworkDevice;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class Router {
    private final Map<UUID, NetworkDevice> NETWORK_DEVICES = new HashMap<UUID, NetworkDevice>();
    private int timer;
    private UUID routerId;
    private class_2338 pos;

    public Router(class_2338 pos) {
        this.pos = pos;
    }

    public void tick(class_1937 level) {
        if (++this.timer >= (Integer)DeviceConfig.BEACON_INTERVAL.get()) {
            this.sendBeacon(level);
            this.timer = 0;
        }
    }

    public boolean addDevice(UUID id, String name) {
        if (this.NETWORK_DEVICES.size() >= (Integer)DeviceConfig.MAX_DEVICES.get()) {
            return this.NETWORK_DEVICES.containsKey(id);
        }
        if (!this.NETWORK_DEVICES.containsKey(id)) {
            this.NETWORK_DEVICES.put(id, new NetworkDevice(id, name, this));
        }
        this.timer = (Integer)DeviceConfig.BEACON_INTERVAL.get();
        return true;
    }

    public boolean addDevice(NetworkDeviceBlockEntity device) {
        if (this.NETWORK_DEVICES.size() >= (Integer)DeviceConfig.MAX_DEVICES.get()) {
            return this.NETWORK_DEVICES.containsKey(device.getId());
        }
        if (!this.NETWORK_DEVICES.containsKey(device.getId())) {
            this.NETWORK_DEVICES.put(device.getId(), new NetworkDevice(device));
        }
        return true;
    }

    public boolean isDeviceRegistered(NetworkDeviceBlockEntity device) {
        return this.NETWORK_DEVICES.containsKey(device.getId());
    }

    public boolean isDeviceConnected(NetworkDeviceBlockEntity device) {
        return this.isDeviceRegistered(device) && this.NETWORK_DEVICES.get(device.getId()).getPos() != null;
    }

    public void removeDevice(NetworkDeviceBlockEntity device) {
        this.NETWORK_DEVICES.remove(device.getId());
    }

    @Nullable
    public NetworkDeviceBlockEntity getDevice(class_1937 level, UUID id) {
        return this.NETWORK_DEVICES.containsKey(id) ? this.NETWORK_DEVICES.get(id).getDevice(level) : null;
    }

    public Collection<NetworkDevice> getNetworkDevices() {
        return this.NETWORK_DEVICES.values();
    }

    public Collection<NetworkDevice> getConnectedDevices(class_1937 level) {
        this.sendBeacon(level);
        return this.NETWORK_DEVICES.values().stream().filter(device -> device.getPos() != null).toList();
    }

    public Collection<NetworkDevice> getConnectedDevices(class_1937 level, Class<? extends NetworkDeviceBlockEntity> type) {
        Predicate<NetworkDevice> DEVICE_TYPE = networkDevice -> {
            if (networkDevice.getPos() == null) {
                return false;
            }
            class_2586 blockEntity = level.method_8321(networkDevice.getPos());
            if (blockEntity instanceof NetworkDeviceBlockEntity) {
                NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
                return type.isAssignableFrom(device.getClass());
            }
            return false;
        };
        return this.getConnectedDevices(level).stream().filter(DEVICE_TYPE).toList();
    }

    private void sendBeacon(class_1937 level) {
        if (level.field_9236) {
            return;
        }
        this.NETWORK_DEVICES.forEach((uuid, device) -> device.setPos(null));
        int range = (Integer)DeviceConfig.SIGNAL_RANGE.get();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    NetworkDeviceBlockEntity device2;
                    class_2338 currentPos = new class_2338(this.pos.method_10263() + x, this.pos.method_10264() + y, this.pos.method_10260() + z);
                    class_2586 blockEntity = level.method_8321(currentPos);
                    if (!(blockEntity instanceof NetworkDeviceBlockEntity) || !this.NETWORK_DEVICES.containsKey((device2 = (NetworkDeviceBlockEntity)blockEntity).getId()) || !device2.receiveBeacon(this)) continue;
                    this.NETWORK_DEVICES.get(device2.getId()).setPos(currentPos);
                }
            }
        }
    }

    public UUID getId() {
        if (this.routerId == null) {
            this.routerId = UUID.randomUUID();
        }
        return this.routerId;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    public class_2487 toTag(boolean includePos) {
        class_2487 tag = new class_2487();
        tag.method_25927("id", this.getId());
        class_2499 deviceList = new class_2499();
        this.NETWORK_DEVICES.forEach((id, device) -> deviceList.add((Object)device.toTag(includePos)));
        tag.method_10566("network_devices", (class_2520)deviceList);
        return tag;
    }

    public static Router fromTag(class_2338 pos, class_2487 tag) {
        Router router = new Router(pos);
        router.routerId = tag.method_25926("id");
        class_2499 deviceList = tag.method_10554("network_devices", 10);
        for (int i = 0; i < deviceList.size(); ++i) {
            NetworkDevice device = NetworkDevice.fromTag(deviceList.method_10602(i));
            router.NETWORK_DEVICES.put(device.getId(), device);
        }
        return router;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Router)) {
            return false;
        }
        Router router = (Router)obj;
        return router.getId().equals(this.getId());
    }
}

