/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.core.network;

import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.ItemList;
import com.ultreon.devices.api.app.renderer.ListItemRenderer;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.block.entity.DeviceBlockEntity;
import com.ultreon.devices.block.entity.RouterBlockEntity;
import com.ultreon.devices.core.Device;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.core.network.task.TaskConnect;
import com.ultreon.devices.core.network.task.TaskPing;
import com.ultreon.devices.object.TrayItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class TrayItemWifi
extends TrayItem {
    private int pingTimer;

    public TrayItemWifi() {
        super(Icons.WIFI_NONE);
    }

    private static Layout createWifiMenu(TrayItem item) {
        Layout.Context layout = new Layout.Context(100, 100);
        layout.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(0.65f, 0.65f, 0.65f, 0.9f).getRGB()));
        ItemList<Device> itemListRouters = new ItemList<Device>(5, 5, 90, 4);
        itemListRouters.setItems(TrayItemWifi.getRouters());
        itemListRouters.setListItemRenderer(new ListItemRenderer<Device>(16){

            @Override
            public void render(class_4587 pose, Device device, class_332 gui, class_310 mc, int x, int y, int width, int height, boolean selected) {
                class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? Color.DARK_GRAY.getRGB() : Color.GRAY.getRGB()));
                RenderUtil.drawStringClipped(pose, device.getName(), x + 16, y + 4, 70, Color.WHITE.getRGB(), false);
                if (device.getPos() == null) {
                    return;
                }
                class_2338 laptopPos = Laptop.getPos();
                assert (laptopPos != null);
                double distance = Math.sqrt(device.getPos().method_10268((double)laptopPos.method_10263() + 0.5, (double)laptopPos.method_10264() + 0.5, (double)laptopPos.method_10260() + 0.5));
                if (distance > 20.0) {
                    Icons.WIFI_LOW.draw(pose, mc, x + 3, y + 3);
                } else if (distance > 10.0) {
                    Icons.WIFI_MED.draw(pose, mc, x + 3, y + 3);
                } else {
                    Icons.WIFI_HIGH.draw(pose, mc, x + 3, y + 3);
                }
            }
        });
        itemListRouters.sortBy((o1, o2) -> {
            class_2338 laptopPos = Laptop.getPos();
            assert (o1.getPos() != null);
            assert (laptopPos != null);
            double distance1 = Math.sqrt(o1.getPos().method_10268((double)laptopPos.method_10263() + 0.5, (double)laptopPos.method_10264() + 0.5, (double)laptopPos.method_10260() + 0.5));
            assert (o2.getPos() != null);
            double distance2 = Math.sqrt(o2.getPos().method_10268((double)laptopPos.method_10263() + 0.5, (double)laptopPos.method_10264() + 0.5, (double)laptopPos.method_10260() + 0.5));
            return Double.compare(distance1, distance2);
        });
        layout.addComponent(itemListRouters);
        Button buttonConnect = new Button(79, 79, Icons.CHECK);
        buttonConnect.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && itemListRouters.getSelectedItem() != null) {
                TaskConnect connect = new TaskConnect(Laptop.getPos(), ((Device)itemListRouters.getSelectedItem()).getPos());
                connect.setCallback((tag, success) -> {
                    if (success) {
                        item.setIcon(Icons.WIFI_HIGH);
                        Laptop.getSystem().closeContext();
                    }
                });
                TaskManager.sendTask(connect);
            }
        });
        layout.addComponent(buttonConnect);
        return layout;
    }

    private static List<Device> getRouters() {
        ArrayList<Device> routers = new ArrayList<Device>();
        class_638 level = class_310.method_1551().field_1687;
        if (Laptop.isWorldLess()) {
            return new ArrayList<Device>();
        }
        class_2338 laptopPos = Laptop.getPos();
        int range = (Integer)DeviceConfig.SIGNAL_RANGE.get();
        for (int y = -range; y < range + 1; ++y) {
            for (int z = -range; z < range + 1; ++z) {
                for (int x = -range; x < range + 1; ++x) {
                    assert (laptopPos != null);
                    class_2338 pos = new class_2338(laptopPos.method_10263() + x, laptopPos.method_10264() + y, laptopPos.method_10260() + z);
                    assert (level != null);
                    class_2586 tileEntity = level.method_8321(pos);
                    if (!(tileEntity instanceof RouterBlockEntity)) continue;
                    routers.add(new Device((DeviceBlockEntity)tileEntity));
                }
            }
        }
        return routers;
    }

    @Override
    public void init() {
        this.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (Laptop.getSystem().hasContext()) {
                Laptop.getSystem().closeContext();
            } else {
                Laptop.getSystem().openContext(TrayItemWifi.createWifiMenu(this), mouseX - 100, mouseY - 100);
            }
        });
        this.runPingTask();
    }

    @Override
    public void tick() {
        if (++this.pingTimer >= (Integer)DeviceConfig.PING_RATE.get()) {
            this.runPingTask();
            this.pingTimer = 0;
        }
    }

    private void runPingTask() {
        TaskPing task = new TaskPing(Laptop.getPos());
        task.setCallback((tag, success) -> {
            if (success) {
                assert (tag != null);
                int strength = tag.method_10550("strength");
                switch (strength) {
                    case 2: {
                        this.setIcon(Icons.WIFI_LOW);
                        break;
                    }
                    case 1: {
                        this.setIcon(Icons.WIFI_MED);
                        break;
                    }
                    case 0: {
                        this.setIcon(Icons.WIFI_HIGH);
                        break;
                    }
                    default: {
                        this.setIcon(Icons.WIFI_NONE);
                        break;
                    }
                }
            } else {
                this.setIcon(Icons.WIFI_NONE);
            }
        });
        TaskManager.sendTask(task);
    }
}

