/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.datagen;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ultreon.devices.init.DeviceItems;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1074;
import net.minecraft.class_1076;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import org.apache.commons.io.IOUtils;

public class DevicesLanguageGenerator
extends FabricLanguageProvider {
    private final String languageCode;
    private final class_1076 l;

    protected DevicesLanguageGenerator(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
        this.languageCode = "en_us";
        this.l = new class_1076(this.languageCode);
    }

    protected DevicesLanguageGenerator(FabricDataGenerator dataGenerator, String languageCode) {
        super(dataGenerator, languageCode);
        this.languageCode = languageCode;
        this.l = new class_1076(this.languageCode);
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        if (this.languageCode.equals("en_pt")) {
            this.createTranslationsForPirateSpeak(translationBuilder);
        } else if (this.languageCode.startsWith("en_")) {
            this.createTranslationsForEnglish(translationBuilder);
        } else if (!this.languageCode.startsWith("nl_")) {
            if (this.languageCode.equals("lol_us")) {
                this.createTranslationsForLOLCAT(translationBuilder);
            } else if (this.languageCode.startsWith("ja_")) {
                this.createTranslationsForJapanese(translationBuilder);
            }
        }
    }

    private void createTranslationsForPirateSpeak(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.createTranslationsFromTemplate(translationBuilder, "en_pt");
    }

    private void createTranslationsForJapanese(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.createTranslationsFromTemplate(translationBuilder, "ja");
    }

    private JsonObject getJSON(Path path) {
        try {
            FileInputStream d = new FileInputStream(path.toFile());
            JsonObject json = (JsonObject)new Gson().fromJson(IOUtils.toString((InputStream)d, (Charset)StandardCharsets.UTF_8), JsonObject.class);
            if (!path.endsWith("en.json")) {
                JsonObject eng = this.getJSON((Path)this.dataGenerator.getModContainer().findPath("translations/en.json").get());
                for (String s : eng.keySet()) {
                    if (json.has(s)) continue;
                    eng.add(s, eng.get(s));
                }
            }
            return json;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createTranslationsFromTemplate(FabricLanguageProvider.TranslationBuilder translationBuilder, String file) {
        JsonObject pathode = this.getJSON((Path)this.dataGenerator.getModContainer().findPath("translations/" + file + ".json").get());
        DeviceItems.LAPTOPS.getMap().forEach((dye, item) -> {
            String laptop = pathode.get("laptop").getAsString();
            String laptop_block = String.format(pathode.get("laptop_block").getAsString(), laptop, this.get((class_1767)dye));
            translationBuilder.add(((class_1792)item.get()).method_7876(), laptop_block);
        });
        DeviceItems.PRINTERS.getMap().forEach((dye, item) -> {
            String printer = pathode.get("printer").getAsString();
            String printer_block = String.format(pathode.get("printer_block").getAsString(), printer, this.get((class_1767)dye));
            translationBuilder.add(((class_1792)item.get()).method_7876(), printer_block);
        });
        DeviceItems.FLASH_DRIVE.getMap().forEach((dye, item) -> {
            String flash_drive = pathode.get("flash_drive").getAsString();
            String flash_drive_item = String.format(pathode.get("flash_drive_item").getAsString(), flash_drive, this.get((class_1767)dye));
            translationBuilder.add(((class_1792)item.get()).method_7876(), flash_drive_item);
        });
        DeviceItems.ROUTERS.getMap().forEach((dye, item) -> {
            String router = pathode.get("router").getAsString();
            String router_block = String.format(pathode.get("router_block").getAsString(), router, this.get((class_1767)dye));
            translationBuilder.add(((class_1792)item.get()).method_7876(), router_block);
        });
        DeviceItems.OFFICE_CHAIRS.getMap().forEach((dye, item) -> {
            String office_chair = pathode.get("office_chair").getAsString();
            String office_chair_block = String.format(pathode.get("office_chair_block").getAsString(), office_chair, this.get((class_1767)dye));
            translationBuilder.add(((class_1792)item.get()).method_7876(), office_chair_block);
        });
    }

    private void createTranslationsForLOLCAT(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.createTranslationsFromTemplate(translationBuilder, "lol");
    }

    private void createTranslationsForDutch(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.createTranslationsFromTemplate(translationBuilder, "nl_nl");
    }

    private void createTranslationsForEnglish(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        try {
            translationBuilder.add((Path)this.dataGenerator.getModContainer().findPath("en_us_existing.json").orElseThrow());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createTranslationsFromTemplate(translationBuilder, "en");
    }

    private String get(class_1767 dye) {
        if (this.differentLanguageCode()) {
            return this.grabIt("color.minecraft." + dye.method_7792());
        }
        return class_1074.method_4662((String)("color.minecraft." + dye.method_7792()), (Object[])new Object[0]);
    }

    private String grabIt(String key) {
        try {
            String string = String.format("/assets/minecraft/lang/%s.json", this.languageCode);
            File d = Paths.get("lang/" + this.languageCode + ".json", new String[0]).toFile();
            BufferedReader q = new BufferedReader(new FileReader(d));
            JsonObject gg = (JsonObject)new Gson().fromJson((Reader)q, JsonObject.class);
            return gg.get(key).getAsString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean differentLanguageCode() {
        return !this.languageCode.startsWith("en_") && !this.languageCode.equals("en_pt");
    }
}

