/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.init;

import com.ultreon.devices.Devices;
import com.ultreon.devices.ModDeviceTypes;
import com.ultreon.devices.init.DeviceBlocks;
import com.ultreon.devices.item.BasicItem;
import com.ultreon.devices.item.ColoredDeviceItem;
import com.ultreon.devices.item.ComponentItem;
import com.ultreon.devices.item.EthernetCableItem;
import com.ultreon.devices.item.FlashDriveItem;
import com.ultreon.devices.item.MotherboardItem;
import com.ultreon.devices.util.DyeableRegistration;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import org.jetbrains.annotations.Nullable;

public class DeviceItems {
    private static final Registrar<class_1792> REGISTER = Devices.REGISTRIES.get().get(class_2378.field_25108);
    public static final DyeableRegistration<class_1792> LAPTOPS = new DyeableRegistration<class_1792>(){

        @Override
        public RegistrySupplier<class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_laptop"), () -> new ColoredDeviceItem((class_2248)DeviceBlocks.LAPTOPS.of(color).get(), new class_1792.class_1793().method_7892(Devices.TAB_DEVICE), color, ModDeviceTypes.LAPTOP));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<class_1792> PRINTERS = new DyeableRegistration<class_1792>(){

        @Override
        public RegistrySupplier<class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_printer"), () -> new ColoredDeviceItem((class_2248)DeviceBlocks.PRINTERS.of(color).get(), new class_1792.class_1793().method_7892(Devices.TAB_DEVICE), color, ModDeviceTypes.PRINTER));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<class_1792> ROUTERS = new DyeableRegistration<class_1792>(){

        @Override
        public RegistrySupplier<class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_router"), () -> new ColoredDeviceItem((class_2248)DeviceBlocks.ROUTERS.of(color).get(), new class_1792.class_1793().method_7892(Devices.TAB_DEVICE), color, ModDeviceTypes.ROUTER));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<class_1792> OFFICE_CHAIRS = new DyeableRegistration<class_1792>(){

        @Override
        public RegistrySupplier<class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_office_chair"), () -> new ColoredDeviceItem((class_2248)DeviceBlocks.OFFICE_CHAIRS.of(color).get(), new class_1792.class_1793().method_7892(Devices.TAB_DEVICE), color, ModDeviceTypes.SEAT));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<class_1792> FLASH_DRIVE = new DyeableRegistration<class_1792>(){

        @Override
        public RegistrySupplier<class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_flash_drive"), () -> new FlashDriveItem(class_1767.field_7952));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final RegistrySupplier<class_1747> PAPER = REGISTER.register(Devices.id("paper"), () -> new class_1747((class_2248)DeviceBlocks.PAPER.get(), new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<BasicItem> PLASTIC_UNREFINED = REGISTER.register(Devices.id("plastic_unrefined"), () -> new BasicItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<BasicItem> PLASTIC = REGISTER.register(Devices.id("plastic"), () -> new BasicItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<BasicItem> PLASTIC_FRAME = REGISTER.register(Devices.id("plastic_frame"), () -> new BasicItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<BasicItem> WHEEL = REGISTER.register(Devices.id("wheel"), () -> new BasicItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_CIRCUIT_BOARD = REGISTER.register(Devices.id("circuit_board"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_MOTHERBOARD = REGISTER.register(Devices.id("motherboard"), () -> new MotherboardItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_CPU = REGISTER.register(Devices.id("cpu"), () -> new MotherboardItem.Component(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_RAM = REGISTER.register(Devices.id("ram"), () -> new MotherboardItem.Component(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_GPU = REGISTER.register(Devices.id("gpu"), () -> new MotherboardItem.Component(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_WIFI = REGISTER.register(Devices.id("wifi"), () -> new MotherboardItem.Component(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_HARD_DRIVE = REGISTER.register(Devices.id("hard_drive"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_FLASH_CHIP = REGISTER.register(Devices.id("flash_chip"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_SOLID_STATE_DRIVE = REGISTER.register(Devices.id("solid_state_drive"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_BATTERY = REGISTER.register(Devices.id("battery"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_SCREEN = REGISTER.register(Devices.id("screen"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_CONTROLLER_UNIT = REGISTER.register(Devices.id("controller_unit"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_SMALL_ELECTRIC_MOTOR = REGISTER.register(Devices.id("small_electric_motor"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<ComponentItem> COMPONENT_CARRIAGE = REGISTER.register(Devices.id("carriage"), () -> new ComponentItem(new class_1792.class_1793().method_7892(Devices.TAB_DEVICE)));
    public static final RegistrySupplier<EthernetCableItem> ETHERNET_CABLE = REGISTER.register(Devices.id("ethernet_cable"), () -> new EthernetCableItem());

    public static Stream<class_1792> getAllItems() {
        return REGISTER.getIds().stream().map(arg_0 -> REGISTER.get(arg_0));
    }

    @Nullable
    public static FlashDriveItem getFlashDriveByColor(class_1767 color) {
        return DeviceItems.getAllFlashDrives().stream().filter(item -> item.getColor() == color).findFirst().orElse(null);
    }

    public static List<FlashDriveItem> getAllFlashDrives() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof FlashDriveItem).map(item -> (FlashDriveItem)item.method_8389()).toList();
    }

    public static List<ColoredDeviceItem> getAllLaptops() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof ColoredDeviceItem).map(item -> (ColoredDeviceItem)item.method_8389()).filter(item -> item.getDeviceType() == ModDeviceTypes.LAPTOP).toList();
    }

    public static List<ColoredDeviceItem> getAllPrinters() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof ColoredDeviceItem).map(item -> (ColoredDeviceItem)item.method_8389()).filter(item -> item.getDeviceType() == ModDeviceTypes.PRINTER).toList();
    }

    public static List<ColoredDeviceItem> getAllRouters() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof ColoredDeviceItem).map(item -> (ColoredDeviceItem)item.method_8389()).filter(item -> item.getDeviceType() == ModDeviceTypes.ROUTER).toList();
    }

    public static void register() {
    }
}

