/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.network.task;

import com.google.common.collect.ImmutableList;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.network.Packet;
import com.ultreon.devices.object.AppInfo;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SyncApplicationPacket
extends Packet<SyncApplicationPacket> {
    private final List<AppInfo> allowedApps;

    public SyncApplicationPacket(class_2540 buf) {
        int size = buf.readInt();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            String appId = buf.method_19772();
            AppInfo info = ApplicationManager.getApplication(class_2960.method_12829((String)appId));
            if (info != null) {
                builder.add((Object)info);
                continue;
            }
            Devices.LOGGER.error("Missing application '" + appId + "'");
        }
        this.allowedApps = builder.build();
    }

    public SyncApplicationPacket(List<AppInfo> allowedApps) {
        this.allowedApps = allowedApps;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.writeInt(this.allowedApps.size());
        for (AppInfo appInfo : this.allowedApps) {
            buf.method_10812(appInfo.getId());
        }
    }

    @Override
    public boolean onMessage(Supplier<NetworkManager.PacketContext> ctx) {
        Devices.setAllowedApps(this.allowedApps);
        return true;
    }
}

