/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.object;

import com.ultreon.devices.api.io.File;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_2487;

public class Picture {
    public int[] pixels;
    public Size size;
    private File source;
    private final String name;
    private final String author;

    public Picture(String name, String author, Size size) {
        this.name = name;
        this.author = author;
        this.pixels = new int[size.width * size.height];
        this.size = size;
        this.init();
    }

    public static Picture fromFile(File file) {
        class_2487 data = file.getData();
        assert (data != null);
        Picture picture = new Picture(data.method_10558("Name"), data.method_10558("Author"), Objects.requireNonNull(Size.getFromSize(data.method_10550("Resolution"))));
        picture.source = file;
        picture.pixels = data.method_10561("Pixels");
        return picture;
    }

    private void init() {
        Arrays.fill(this.pixels, new Color(1.0f, 1.0f, 1.0f, 0.0f).getRGB());
    }

    public File getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public int getPixelWidth() {
        return this.size.pixelWidth;
    }

    public int getPixelHeight() {
        return this.size.pixelHeight;
    }

    public int[] copyPixels() {
        int[] copiedPixels = new int[this.pixels.length];
        System.arraycopy(this.pixels, 0, copiedPixels, 0, this.pixels.length);
        return copiedPixels;
    }

    public String toString() {
        return this.name;
    }

    public void writeToNBT(class_2487 tagCompound) {
        tagCompound.method_10582("Name", this.getName());
        tagCompound.method_10582("Author", this.getAuthor());
        tagCompound.method_10539("Pixels", this.pixels);
        tagCompound.method_10569("Resolution", this.size.width);
    }

    public static enum Size {
        X16(16, 16, 8, 8),
        X32(32, 32, 4, 4);

        public int width;
        public int height;
        public int pixelWidth;
        public int pixelHeight;

        private Size(int width, int height, int pixelWidth, int pixelHeight) {
            this.width = width;
            this.height = height;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
        }

        public static Size getFromSize(int size) {
            if (size == 16) {
                return X16;
            }
            if (size == 32) {
                return X32;
            }
            return null;
        }
    }
}

