/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.object;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.Game;
import com.ultreon.devices.object.tiles.Tile;
import com.ultreon.devices.util.KeyboardHelper;
import com.ultreon.devices.util.Vec2d;
import java.util.Objects;
import net.minecraft.class_1158;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_881;

public class Player {
    private static final class_2960 boatTextures = new class_2960("textures/entity/boat/oak.png");
    boolean canMove = false;
    private final Game game;
    private double posX;
    private double posY;
    private double posXPrev;
    private double posYPrev;
    private double speed;
    private int rotation;
    private int rotationPrev;
    private final Vec2d direction;
    private final Vec2d velocity;
    private final class_881 boatModel;
    private class_1690 boat;

    public static class_5617.class_5618 createEntityRendererContext() {
        return null;
    }

    public Player(Game game) {
        this.game = game;
        this.direction = new Vec2d(0.0, 0.0);
        this.velocity = new Vec2d(0.0, 0.0);
        this.boatModel = new class_881(Player.createEntityRendererContext(), false);
        assert (class_310.method_1551().field_1724 != null);
        boolean slim = class_310.method_1551().field_1724.method_3121().equals("slim");
        if (Laptop.isWorldLess()) {
            this.boat = new class_1690((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687), 0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        Tile tile;
        this.rotationPrev = this.rotation;
        this.posXPrev = this.posX;
        this.posYPrev = this.posY;
        if (KeyboardHelper.isKeyDown(265)) {
            this.speed += 0.5;
            if (this.speed >= 3.0) {
                this.speed = 3.0;
            }
            if (KeyboardHelper.isKeyDown(42) || KeyboardHelper.isKeyDown(54)) {
                this.speed += 2.0;
            }
        } else {
            this.speed /= 1.1;
        }
        if (KeyboardHelper.isKeyDown(263)) {
            this.rotation -= 8;
        }
        if (KeyboardHelper.isKeyDown(262)) {
            this.rotation += 8;
        }
        if ((tile = this.game.getTile(Game.Layer.BACKGROUND, this.getPosX(), this.getPosY())) != null && tile.isSlow()) {
            this.speed *= 0.1;
        }
        this.direction.x = Math.cos(Math.toRadians(this.rotation));
        this.direction.y = Math.sin(Math.toRadians(this.rotation));
        this.direction.normalise();
        this.velocity.x = this.direction.x * this.speed;
        this.velocity.y = this.direction.y * this.speed;
        this.canMove = this.canMove();
        if (this.canMove) {
            this.posX += this.velocity.x;
            this.posY += this.velocity.y;
        } else {
            this.speed = 0.0;
        }
    }

    public boolean canMove() {
        if (this.posX + this.velocity.x <= 0.0) {
            return false;
        }
        if (this.posY + this.velocity.y <= 0.0) {
            return false;
        }
        if (this.posX + this.velocity.x >= (double)(this.game.mapWidth * 8)) {
            return false;
        }
        return !(this.posY + this.velocity.y >= (double)(this.game.mapHeight * 6));
    }

    public int getPosX() {
        return (int)(this.posX / 8.0);
    }

    public int getPosY() {
        return (int)(this.posY / 6.0);
    }

    public void render(class_4587 pose, int x, int y, float partialTicks) {
        float scale = 0.5f;
        double px = (double)x + this.posXPrev + (this.posX - this.posXPrev) * (double)partialTicks;
        double py = (double)y + this.posYPrev + (this.posY - this.posYPrev) * (double)partialTicks;
        float rot = (float)this.rotationPrev + (float)(this.rotation - this.rotationPrev) * partialTicks;
        pose.method_22903();
        pose.method_22904((double)((float)px), (double)((float)py), 3.0);
        pose.method_22905(-scale, -scale, -scale);
        pose.method_22907(new class_1158(180.0f, 0.0f, 0.0f, 1.0f));
        pose.method_22907(new class_1158(90.0f, 1.0f, 0.0f, 0.0f));
        pose.method_22904(0.0, -3.0, 0.0);
        pose.method_22907(new class_1158(-90.0f, 1.0f, 0.0f, 0.0f));
        pose.method_22907(new class_1158(rot, 0.0f, 1.0f, 0.0f));
        RenderSystem.setShaderTexture((int)0, (class_2960)boatTextures);
        class_310.method_1551().method_1561().method_3954((class_1297)this.boat, 0.0, 0.0, 0.0, 0.0f, partialTicks, pose, (class_4597)class_4597.method_22991((class_287)class_289.method_1348().method_1349()), 1);
        this.boatModel.method_3888(this.boat, 0.0f, 0.0f, pose, (class_4597)class_310.method_1551().method_22940().method_23000(), 1);
        pose.method_22909();
        pose.method_22903();
        pose.method_22904((double)((float)px), (double)((float)py), 3.0);
        pose.method_22905(-scale, scale, scale);
        pose.method_22907(new class_1158(90.0f, 1.0f, 0.0f, 0.0f));
        pose.method_22904(0.0, 5.0, 0.0);
        pose.method_22907(new class_1158(90.0f, 1.0f, 0.0f, 0.0f));
        pose.method_22907(new class_1158(180.0f, 0.0f, 0.0f, 1.0f));
        pose.method_22907(new class_1158(rot - 90.0f, 0.0f, 1.0f, 0.0f));
        pose.method_22904(0.0, -12.0, 5.0);
        pose.method_22909();
    }
}

