/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.object;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.api.app.listener.ClickListener;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.Game;
import com.ultreon.devices.object.tiles.Tile;
import com.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class TileGrid
extends Component {
    private Label labelCurrentCategory;
    private Button btnNextCategory;
    private Button btnPrevCategory;
    private int currentCategory = 0;
    private List<Tile> tabTiles = new ArrayList<Tile>();
    private Game game;

    public TileGrid(int left, int top, Game game) {
        super(left, top);
        this.game = game;
    }

    @Override
    public void init(Layout layout) {
        this.labelCurrentCategory = new Label("", this.left + 14, this.top + 2);
        layout.addComponent(this.labelCurrentCategory);
        this.btnNextCategory = new Button(this.left + 81, this.top, Icons.CHEVRON_RIGHT);
        this.btnNextCategory.setPadding(1);
        this.btnNextCategory.setClickListener(new ClickListener(){

            @Override
            public void onClick(int mouseX, int mouseY, int mouseButton) {
                if (TileGrid.this.currentCategory < Tile.Category.values().length - 1) {
                    ++TileGrid.this.currentCategory;
                    TileGrid.this.updateTiles();
                }
            }
        });
        layout.addComponent(this.btnNextCategory);
        this.btnPrevCategory = new Button(this.left, this.top, Icons.CHEVRON_LEFT);
        this.btnPrevCategory.setPadding(1);
        this.btnPrevCategory.setClickListener(new ClickListener(){

            @Override
            public void onClick(int mouseX, int mouseY, int mouseButton) {
                if (TileGrid.this.currentCategory > 0) {
                    --TileGrid.this.currentCategory;
                    TileGrid.this.updateTiles();
                }
            }
        });
        layout.addComponent(this.btnPrevCategory);
        this.updateTiles();
    }

    @Override
    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        int i;
        try {
            class_289.method_1348().method_1349().method_1326();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TileGrid.method_25294((class_4587)pose, (int)this.xPosition, (int)(this.yPosition + 15), (int)(this.xPosition + 93), (int)(this.yPosition + 100), (int)Color.DARK_GRAY.getRGB());
        TileGrid.method_25294((class_4587)pose, (int)(this.xPosition + 1), (int)(this.yPosition + 16), (int)(this.xPosition + 92), (int)(this.yPosition + 99), (int)Color.GRAY.getRGB());
        RenderSystem.setShaderTexture((int)0, (class_2960)Game.ICONS);
        for (i = 0; i < this.tabTiles.size(); ++i) {
            Tile tile = this.tabTiles.get(i);
            int tileX = i % 6 * 15 + this.xPosition + 3;
            int tileY = i / 6 * 15 + this.yPosition + 18;
            if (GuiHelper.isMouseInside(mouseX, mouseY, tileX - 1, tileY - 1, tileX + 12, tileY + 12) || this.game.getCurrentTile() == tile) {
                TileGrid.method_25294((class_4587)pose, (int)(tileX - 1), (int)(tileY - 1), (int)(tileX + 13), (int)(tileY + 13), (int)Color.WHITE.getRGB());
            } else {
                TileGrid.method_25294((class_4587)pose, (int)(tileX - 1), (int)(tileY - 1), (int)(tileX + 13), (int)(tileY + 13), (int)Color.LIGHT_GRAY.getRGB());
            }
            pose.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.drawRectWithTexture(pose, tileX, tileY, tile.x * 16, tile.y * 16, 12, 12, 16.0f, 16.0f);
            pose.method_22909();
        }
        if (GuiHelper.isMouseInside(mouseX, mouseX, this.xPosition, this.yPosition, this.xPosition + 60, this.yPosition + 60)) {
            for (i = 0; i < this.tabTiles.size(); ++i) {
                int tileX = i % 6 * 15 + this.xPosition + 2;
                int tileY = i / 6 * 15 + this.yPosition + 17;
                if (!GuiHelper.isMouseInside(mouseX, mouseY, tileX, tileY, tileX + 14, tileY + 14)) continue;
                TileGrid.method_25294((class_4587)pose, (int)(tileX - 1), (int)(tileY - 1), (int)(tileX + 13), (int)(tileY + 13), (int)Color.WHITE.getRGB());
            }
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        for (int i = 0; i < this.tabTiles.size(); ++i) {
            int x = i % 6 * 15 + this.xPosition + 3;
            int y = i / 6 * 15 + this.yPosition + 18;
            if (!GuiHelper.isMouseInside(mouseX, mouseY, x - 1, y - 1, x + 12, y + 12)) continue;
            this.game.setCurrentTile(this.tabTiles.get(i));
            return;
        }
    }

    public void updateTiles() {
        this.tabTiles.clear();
        Tile.Category category = Tile.Category.values()[this.currentCategory];
        this.labelCurrentCategory.setText(category.name);
        for (Tile tile : Game.getRegisteredtiles().values()) {
            if (tile.getCategory() != category) continue;
            this.tabTiles.add(tile);
        }
    }
}

