/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.object.tiles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.object.Game;
import com.ultreon.devices.object.tiles.Tile;
import net.minecraft.class_4587;

public class TileBlock
extends Tile {
    public TileBlock(int id, int x, int y) {
        super(id, x, y);
    }

    public TileBlock(int id, int x, int y, int topX, int topY) {
        super(id, x, y, topX, topY);
    }

    @Override
    public void render(class_4587 pose, Game game, int x, int y, Game.Layer layer) {
        if (layer == Game.Layer.BACKGROUND) {
            super.render(pose, game, x, y, layer);
            if (!game.isFullTile(layer, x, y + 1) && this != Tile.water) {
                RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
                RenderUtil.drawRectWithTexture(pose, game.xPosition + x * 8, game.yPosition + y * 6 + 6, layer.zLevel, this.x * 16, this.y * 16, 8, 2, 16.0f, 4.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            return;
        }
        if (game.getTile(layer.up(), x, y - 1) != this || layer == Game.Layer.FOREGROUND) {
            RenderUtil.drawRectWithTexture(pose, game.xPosition + x * 8, game.yPosition + y * 6 - 6, layer.zLevel, this.topX * 16, this.topY * 16, 8, 6, 16.0f, 16.0f);
        }
        RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        RenderUtil.drawRectWithTexture(pose, game.xPosition + x * 8, game.yPosition + y * 6, layer.zLevel, this.x * 16, this.y * 16, 8, 6, 16.0f, 16.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderForeground(class_4587 pose, Game game, int x, int y, Game.Layer layer) {
        if (layer != Game.Layer.BACKGROUND || this == Tile.water) {
            return;
        }
        Tile tileDown = game.getTile(layer, x, y + 1);
        if (game.getTile(layer, x, y + 1) == Tile.water) {
            RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            RenderUtil.drawRectWithTexture(pose, game.xPosition + x * 8, game.yPosition + y * 6 + 6, layer.zLevel, this.x * 16, this.y * 16, 8, 1, 16.0f, 2.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

