/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.auction;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.app.Dialog;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.Inventory;
import com.ultreon.devices.api.app.component.ItemList;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.api.app.component.NumberSelector;
import com.ultreon.devices.api.app.renderer.ListItemRenderer;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.api.utils.BankUtil;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.programs.auction.AuctionManager;
import com.ultreon.devices.programs.auction.object.AuctionItem;
import com.ultreon.devices.programs.auction.task.TaskAddAuction;
import com.ultreon.devices.programs.auction.task.TaskBuyItem;
import com.ultreon.devices.programs.auction.task.TaskGetAuctions;
import com.ultreon.devices.programs.system.layout.StandardLayout;
import com.ultreon.devices.util.TimeUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class MineBayApp
extends Application {
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("textures/gui/container/generic_54.png");
    private static final class_2960 MINEBAY_ASSETS = new class_2960("devices:textures/gui/minebay.png");
    private static final class_1799 EMERALD = new class_1799((class_1935)class_1802.field_8687);
    private final String[] categories = new String[]{"Building", "Combat", "Tools", "Food", "Materials", "Redstone", "Alchemy", "Rare", "Misc"};
    private Layout layoutMyAuctions;
    private ItemList<AuctionItem> items;
    private Layout layoutSelectItem;
    private Inventory inventory;
    private Button buttonAddCancel;
    private Button buttonAddNext;
    private Layout layoutAmountAndPrice;
    private Label labelAmount;
    private NumberSelector selectorAmount;
    private Label labelPrice;
    private NumberSelector selectorPrice;
    private Button buttonAmountAndPriceBack;
    private Button buttonAmountAndPriceCancel;
    private Button buttonAmountAndPriceNext;
    private Layout layoutDuration;
    private Label labelHours;
    private Label labelMinutes;
    private Label labelSeconds;
    private NumberSelector selectorHours;
    private NumberSelector selectorMinutes;
    private NumberSelector selectorSeconds;
    private Button buttonDurationBack;
    private Button buttonDurationCancel;
    private Button buttonDurationAdd;

    @Override
    public void onTick() {
        super.onTick();
        AuctionManager.INSTANCE.tick();
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        StandardLayout layoutMain = new StandardLayout(class_124.field_1067 + "Icons", 330, 153, this, null);
        this.setCurrentLayout(layoutMain);
        this.getCurrentLayout().setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + 25), (int)Color.GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 24), (int)(x + width), (int)(y + 25), (int)Color.DARK_GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 25), (int)(x + 95), (int)(y + height), (int)Color.LIGHT_GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)(x + 94), (int)(y + 25), (int)(x + 95), (int)(y + height), (int)Color.GRAY.getRGB());
            RenderSystem.setShaderTexture((int)0, (class_2960)MINEBAY_ASSETS);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.drawRectWithTexture(pose, x + 5, y + 6, 0.0f, 0.0f, 61, 11, 61.0f, 12.0f);
        });
        Button btnAddItem = new Button(70, 5, "Add Item");
        btnAddItem.setSize(60, 15);
        btnAddItem.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutSelectItem));
        layoutMain.addComponent(btnAddItem);
        Button btnViewItem = new Button(135, 5, "Your Auctions");
        btnViewItem.setSize(80, 15);
        btnViewItem.setClickListener((mouseX, mouseY, mouseButton) -> {
            assert (class_310.method_1551().field_1724 != null);
            TaskGetAuctions task = new TaskGetAuctions(class_310.method_1551().field_1724.method_5667());
            task.setCallback((nbt, success) -> {
                this.items.removeAll();
                for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                    this.items.addItem(item);
                }
            });
            TaskManager.sendTask(task);
        });
        layoutMain.addComponent(btnViewItem);
        Label labelBalance = new Label("Balance", 295, 3);
        labelBalance.setAlignment(1);
        layoutMain.addComponent(labelBalance);
        Label labelMoney = new Label("$0", 295, 13);
        labelMoney.setAlignment(1);
        labelMoney.setScale(1.0);
        labelMoney.setShadow(false);
        layoutMain.addComponent(labelMoney);
        Label labelCategories = new Label("Categories", 5, 29);
        labelCategories.setShadow(false);
        layoutMain.addComponent(labelCategories);
        ItemList<String> categories = new ItemList<String>(5, 40, 70, 7);
        for (String category : this.categories) {
            categories.addItem(category);
        }
        layoutMain.addComponent(categories);
        Label labelItems = new Label("Items", 100, 29);
        labelItems.setShadow(false);
        layoutMain.addComponent(labelItems);
        this.items = new ItemList(100, 40, 180, 4);
        this.items.setListItemRenderer(new ListItemRenderer<AuctionItem>(20){

            @Override
            public void render(class_4587 pose, AuctionItem e, class_332 gui, class_310 mc, int x, int y, int width, int height, boolean selected) {
                if (selected) {
                    class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.DARK_GRAY.getRGB());
                } else {
                    class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.GRAY.getRGB());
                }
                RenderUtil.renderItem(x + 2, y + 2, e.getStack(), true);
                pose.method_22903();
                pose.method_22904((double)(x + 24), (double)(y + 4), 0.0);
                pose.method_22905(0.666f, 0.666f, 0.0f);
                mc.field_1772.method_30883(pose, e.getStack().method_7954(), 0.0f, 0.0f, Color.WHITE.getRGB());
                mc.field_1772.method_1729(pose, TimeUtil.getTotalRealTime(e.getTimeLeft()), 0.0f, 11.0f, Color.LIGHT_GRAY.getRGB());
                pose.method_22909();
                String price = "$" + e.getPrice();
                mc.field_1772.method_1729(pose, price, (float)(x - mc.field_1772.method_1727(price) + width - 5), (float)(y + 6), Color.YELLOW.getRGB());
            }
        });
        layoutMain.addComponent(this.items);
        Button btnBuy = new Button(100, 127, "Buy");
        btnBuy.setSize(50, 15);
        btnBuy.setClickListener((mouseX, mouseY, mouseButton) -> {
            Dialog.Confirmation dialog = new Dialog.Confirmation();
            dialog.setPositiveText("Buy");
            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> {
                int index = this.items.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                AuctionItem item = this.items.getItem(index);
                if (item != null) {
                    TaskBuyItem task = new TaskBuyItem(item.getId());
                    task.setCallback((nbt, success) -> {
                        if (success) {
                            this.items.removeItem(index);
                        }
                    });
                    TaskManager.sendTask(task);
                }
            });
            dialog.setNegativeText("Cancel");
            dialog.setNegativeListener((mouseX1, mouseY1, mouseButton1) -> dialog.close());
            this.openDialog(dialog);
        });
        layoutMain.addComponent(btnBuy);
        this.layoutSelectItem = new Layout(172, 87);
        this.layoutSelectItem.setTitle("Add Item");
        this.layoutSelectItem.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + 22), (int)Color.LIGHT_GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 22), (int)(x + width), (int)(y + 23), (int)Color.DARK_GRAY.getRGB());
            mc.field_1772.method_1720(pose, "Select an Item...", (float)(x + 5), (float)(y + 7), Color.WHITE.getRGB());
        });
        this.inventory = new Inventory(5, 28);
        this.inventory.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.inventory.getSelectedSlotIndex() != -1) {
                assert (class_310.method_1551().field_1724 != null);
                class_1799 stack = class_310.method_1551().field_1724.method_31548().method_5438(this.inventory.getSelectedSlotIndex());
                if (!stack.method_7960()) {
                    this.buttonAddNext.setEnabled(true);
                    this.selectorAmount.setMax(stack.method_7947());
                    this.selectorAmount.setNumber(stack.method_7947());
                } else {
                    this.buttonAddNext.setEnabled(false);
                }
            }
        });
        this.layoutSelectItem.addComponent(this.inventory);
        this.buttonAddCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        this.buttonAddCancel.setToolTip("Cancel", "Go back to main page");
        this.buttonAddCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.restoreDefaultLayout());
        this.layoutSelectItem.addComponent(this.buttonAddCancel);
        this.buttonAddNext = new Button(154, 4, MINEBAY_ASSETS, 16, 12, 8, 8);
        this.buttonAddNext.setToolTip("Next Page", "Set price and amount");
        this.buttonAddNext.setEnabled(false);
        this.buttonAddNext.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.selectorAmount.updateButtons();
            this.selectorPrice.updateButtons();
            this.setCurrentLayout(this.layoutAmountAndPrice);
        });
        this.layoutSelectItem.addComponent(this.buttonAddNext);
        this.layoutAmountAndPrice = new Layout(172, 87);
        this.layoutAmountAndPrice.setTitle("Add Item");
        this.layoutAmountAndPrice.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + 22), (int)Color.LIGHT_GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 22), (int)(x + width), (int)(y + 23), (int)Color.DARK_GRAY.getRGB());
            mc.field_1772.method_1720(pose, "Set amount and price...", (float)(x + 5), (float)(y + 7), Color.WHITE.getRGB());
            int offsetX = 14;
            int offsetY = 40;
            class_329.method_25294((class_4587)pose, (int)(x + offsetX), (int)(y + offsetY), (int)(x + offsetX + 38), (int)(y + offsetY + 38), (int)Color.BLACK.getRGB());
            class_329.method_25294((class_4587)pose, (int)(x + offsetX + 1), (int)(y + offsetY + 1), (int)(x + offsetX + 37), (int)(y + offsetY + 37), (int)Color.DARK_GRAY.getRGB());
            offsetX = 90;
            class_329.method_25294((class_4587)pose, (int)(x + offsetX), (int)(y + offsetY), (int)(x + offsetX + 38), (int)(y + offsetY + 38), (int)Color.BLACK.getRGB());
            class_329.method_25294((class_4587)pose, (int)(x + offsetX + 1), (int)(y + offsetY + 1), (int)(x + offsetX + 37), (int)(y + offsetY + 37), (int)Color.DARK_GRAY.getRGB());
            if (this.inventory.getSelectedSlotIndex() != -1) {
                assert (mc.field_1724 != null);
                class_1799 stack = mc.field_1724.method_31548().method_5438(this.inventory.getSelectedSlotIndex());
                if (!stack.method_7960()) {
                    pose.method_22903();
                    pose.method_22904((double)(x + 17), (double)(y + 43), 0.0);
                    pose.method_22905(2.0f, 2.0f, 0.0f);
                    RenderUtil.renderItem(0, 0, stack, false);
                    pose.method_22909();
                }
            }
            pose.method_22903();
            pose.method_22904((double)(x + 92), (double)(y + 43), 0.0);
            pose.method_22905(2.0f, 2.0f, 0.0f);
            RenderUtil.renderItem(0, 0, EMERALD, false);
            pose.method_22909();
        });
        this.buttonAmountAndPriceBack = new Button(122, 4, MINEBAY_ASSETS, 8, 12, 8, 8);
        this.buttonAmountAndPriceBack.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutSelectItem));
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceBack);
        this.buttonAmountAndPriceCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        this.buttonAmountAndPriceCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.restoreDefaultLayout());
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceCancel);
        this.buttonAmountAndPriceNext = new Button(154, 4, MINEBAY_ASSETS, 16, 12, 8, 8);
        this.buttonAmountAndPriceNext.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutDuration));
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceNext);
        this.labelAmount = new Label("Amount", 16, 30);
        this.layoutAmountAndPrice.addComponent(this.labelAmount);
        this.selectorAmount = new NumberSelector(55, 42, 18);
        this.selectorAmount.setMax(64);
        this.layoutAmountAndPrice.addComponent(this.selectorAmount);
        this.labelPrice = new Label("Price", 96, 30);
        this.layoutAmountAndPrice.addComponent(this.labelPrice);
        this.selectorPrice = new NumberSelector(131, 42, 24);
        this.selectorPrice.setMax(999);
        this.layoutAmountAndPrice.addComponent(this.selectorPrice);
        this.layoutDuration = new Layout(172, 87);
        this.layoutDuration.setTitle("Add Item");
        this.layoutDuration.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + 22), (int)Color.LIGHT_GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 22), (int)(x + width), (int)(y + 23), (int)Color.DARK_GRAY.getRGB());
            mc.field_1772.method_1720(pose, "Set duration...", (float)(x + 5), (float)(y + 7), Color.WHITE.getRGB());
        });
        this.buttonDurationBack = new Button(122, 4, MINEBAY_ASSETS, 8, 12, 8, 8);
        this.buttonDurationBack.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutAmountAndPrice));
        this.layoutDuration.addComponent(this.buttonDurationBack);
        this.buttonDurationCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        this.buttonDurationCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(layoutMain));
        this.layoutDuration.addComponent(this.buttonDurationCancel);
        this.buttonDurationAdd = new Button(154, 4, MINEBAY_ASSETS, 24, 12, 8, 8);
        this.buttonDurationAdd.setClickListener((mouseX, mouseY, mouseButton) -> {
            Dialog.Confirmation dialog = new Dialog.Confirmation();
            dialog.setMessageText("Are you sure you want to auction this item?");
            dialog.setPositiveText("Yes");
            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> {
                int ticks = (int)TimeUtil.getRealTimeToTicks(this.selectorHours.getNumber(), this.selectorMinutes.getNumber(), this.selectorSeconds.getNumber());
                TaskAddAuction task = new TaskAddAuction(this.inventory.getSelectedSlotIndex(), this.selectorAmount.getNumber(), this.selectorPrice.getNumber(), ticks);
                task.setCallback((nbt, success) -> {
                    if (success) {
                        List<AuctionItem> auctionItems = AuctionManager.INSTANCE.getItems();
                        this.items.addItem(auctionItems.get(auctionItems.size() - 1));
                    }
                });
                TaskManager.sendTask(task);
                dialog.close();
                this.init(intent);
            });
            this.openDialog(dialog);
        });
        this.layoutDuration.addComponent(this.buttonDurationAdd);
        this.labelHours = new Label("Hrs", 45, 30);
        this.layoutDuration.addComponent(this.labelHours);
        this.labelMinutes = new Label("Mins", 76, 30);
        this.layoutDuration.addComponent(this.labelMinutes);
        this.labelSeconds = new Label("Secs", 105, 30);
        this.layoutDuration.addComponent(this.labelSeconds);
        DecimalFormat format = new DecimalFormat("00");
        this.selectorHours = new NumberSelector(45, 42, 20);
        this.selectorHours.setMax(23);
        this.selectorHours.setMin(0);
        this.selectorHours.setFormat(format);
        this.layoutDuration.addComponent(this.selectorHours);
        this.selectorMinutes = new NumberSelector(76, 42, 20);
        this.selectorMinutes.setMax(59);
        this.selectorMinutes.setMin(0);
        this.selectorMinutes.setFormat(format);
        this.layoutDuration.addComponent(this.selectorMinutes);
        this.selectorSeconds = new NumberSelector(107, 42, 20);
        this.selectorSeconds.setMax(59);
        this.selectorSeconds.setMin(1);
        this.selectorSeconds.setFormat(format);
        this.layoutDuration.addComponent(this.selectorSeconds);
        BankUtil.getBalance((nbt, success) -> {
            if (success) {
                labelMoney.setText("$" + Objects.requireNonNull(nbt, "Expected to get a tag from the get-balance task response.").method_10550("balance"));
            }
        });
        TaskGetAuctions task = new TaskGetAuctions();
        task.setCallback((nbt, success) -> {
            this.items.removeAll();
            for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                this.items.addItem(item);
            }
        });
        TaskManager.sendTask(task);
    }

    @Override
    public void load(class_2487 tagCompound) {
    }

    @Override
    public void save(class_2487 tagCompound) {
    }
}

