/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.email.object;

import com.ultreon.devices.api.io.File;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class Email {
    private final String subject;
    private String author;
    private final String message;
    private final File attachment;
    private boolean read;

    public Email(String subject, String message, @Nullable File file) {
        this.subject = subject;
        this.message = message;
        this.attachment = file;
        this.read = false;
    }

    public Email(String subject, String author, String message, @Nullable File attachment) {
        this(subject, message, attachment);
        this.author = author;
    }

    public static Email readFromNBT(class_2487 nbt) {
        File attachment = null;
        if (nbt.method_10573("attachment", 10)) {
            class_2487 fileTag = nbt.method_10562("attachment");
            attachment = File.fromTag(fileTag.method_10558("file_name"), fileTag.method_10562("data"));
        }
        Email email = new Email(nbt.method_10558("subject"), nbt.method_10558("author"), nbt.method_10558("message"), attachment);
        email.setRead(nbt.method_10577("read"));
        return email;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMessage() {
        return this.message;
    }

    public File getAttachment() {
        return this.attachment;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void save(class_2487 nbt) {
        nbt.method_10582("subject", this.subject);
        if (this.author != null) {
            nbt.method_10582("author", this.author);
        }
        nbt.method_10582("message", this.message);
        nbt.method_10556("read", this.read);
        if (this.attachment != null) {
            class_2487 fileTag = new class_2487();
            fileTag.method_10582("file_name", this.attachment.getName());
            fileTag.method_10566("data", (class_2520)this.attachment.toTag());
            nbt.method_10566("attachment", (class_2520)fileTag);
        }
    }
}

