/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.gitweb.component.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public abstract class ContainerBox
extends Component {
    public static final int WIDTH = 128;
    protected static final class_2960 CONTAINER_BOXES_TEXTURE = new class_2960("devices", "textures/gui/container_boxes.png");
    protected List<Slot> slots = new ArrayList<Slot>();
    protected int boxU;
    protected int boxV;
    protected int height;
    protected class_1799 icon;
    protected String title;

    public ContainerBox(int left, int top, int boxU, int boxV, int height, class_1799 icon, String title) {
        super(left, top);
        this.boxU = boxU;
        this.boxV = boxV;
        this.height = height;
        this.icon = icon;
        this.title = title;
    }

    @Override
    protected void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (class_2960)CONTAINER_BOXES_TEXTURE);
        RenderUtil.drawRectWithTexture(pose, x, y + 12, this.boxU, this.boxV, 128, this.height, 128.0f, this.height, 256, 256);
        int contentOffset = (128 - (Laptop.getFont().method_1727(this.title) + 8 + 4)) / 2;
        pose.method_22903();
        pose.method_22904((double)(x + contentOffset), (double)y, 0.0);
        pose.method_22905(0.5f, 0.5f, 0.5f);
        RenderUtil.renderItem(x + contentOffset - 5, y - 4, this.icon, false);
        pose.method_22909();
        RenderUtil.drawStringClipped(pose, this.title, x + contentOffset + 8 + 4, y, 110, Color.WHITE.getRGB(), true);
        this.slots.forEach(slot -> slot.render(x, y + 12));
    }

    @Override
    protected void renderOverlay(class_4587 pose, Laptop laptop, class_310 mc, int mouseX, int mouseY, boolean windowActive) {
        this.slots.forEach(slot -> slot.renderOverlay(pose, laptop, this.xPosition, this.yPosition + 12, mouseX, mouseY));
    }

    protected static class Slot {
        private final int slotX;
        private final int slotY;
        private final class_1799 stack;

        public Slot(int slotX, int slotY, class_1799 stack) {
            this.slotX = slotX;
            this.slotY = slotY;
            this.stack = stack;
        }

        public void render(int x, int y) {
            RenderUtil.renderItem(x + this.slotX, y + this.slotY, this.stack, true);
        }

        public void renderOverlay(class_4587 pose, Laptop laptop, int x, int y, int mouseX, int mouseY) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + this.slotX, y + this.slotY, 16, 16) && !this.stack.method_7960()) {
                laptop.method_32634(pose, laptop.method_25408(this.stack), Optional.empty(), mouseX, mouseY);
            }
        }

        public class_1799 getStack() {
            return this.stack;
        }
    }
}

