/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.gitweb.module;

import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.programs.gitweb.component.GitWebFrame;
import com.ultreon.devices.programs.gitweb.module.Module;
import java.util.Map;
import java.util.Objects;

public class HeaderModule
extends Module {
    @Override
    public String[] getRequiredData() {
        return new String[]{"text"};
    }

    @Override
    public String[] getOptionalData() {
        return new String[]{"scale", "padding", "align"};
    }

    @Override
    public int calculateHeight(Map<String, String> data, int width) {
        if (data.containsKey("scale")) {
            double d = Double.parseDouble(data.get("scale"));
            Objects.requireNonNull(Laptop.getFont());
            return (int)(d * 9.0 + (double)((data.containsKey("padding") ? Integer.parseInt(data.get("padding")) : 5) * 2));
        }
        Objects.requireNonNull(Laptop.getFont());
        return 9 + (data.containsKey("padding") ? Integer.parseInt(data.get("padding")) : 5) * 2;
    }

    @Override
    public void generate(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
        int padding = data.containsKey("padding") ? Integer.parseInt(data.get("padding")) : 5;
        String s = GitWebFrame.parseFormatting(data.get("text"));
        Label label = new Label(s, width / 2, padding);
        label.setAlignment(2);
        double scale = 1.0;
        if (data.containsKey("scale")) {
            scale = Double.parseDouble(data.get("scale"));
        }
        label.setScale(scale);
        String align = data.getOrDefault("align", "center");
        if ("left".equals(align)) {
            label.left = padding;
            label.setAlignment(0);
        } else if ("right".equals(align)) {
            label.left = width - padding;
            label.setAlignment(1);
        }
        layout.addComponent(label);
    }
}

