/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.gitweb.module;

import com.jab125.apoint.api.APoint;
import com.jab125.apoint.api.APointRuntime;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.programs.gitweb.component.GitWebFrame;
import com.ultreon.devices.programs.gitweb.layout.ModuleLayout;
import com.ultreon.devices.programs.gitweb.module.Module;
import java.util.HashMap;
import java.util.Map;

public class ScriptModule
extends Module {
    @Override
    public String[] getRequiredData() {
        return new String[]{"script", "runtime"};
    }

    @Override
    public String[] getOptionalData() {
        return new String[0];
    }

    @Override
    public int calculateHeight(Map<String, String> data, int width) {
        return 1;
    }

    @Override
    public void generate(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
        String script = data.get("script").replaceAll("scriptModule:newLine", "\n").replaceAll("scriptModule:equals", "=");
        if (data.get("runtime").equals("apoint")) {
            this.initAPointRuntime(frame);
            System.out.println(script);
            frame.aPointRuntime.parse(script);
        } else if (data.get("runtime").equals("ulang")) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        String script = "VAL str paragraph\nVAL str text\nVAL str \"Hello World!\"\nMODIFY\n";
        System.out.println(script.replaceAll("\n", "scriptModule:newLine").replaceAll("=", "scriptModule:equals"));
    }

    private void initAPointRuntime(GitWebFrame frame) {
        if (frame.aPointRuntime == null) {
            APointRuntime runtime = APoint.createRuntime();
            runtime.removeCommand("METHOD:STATIC");
            runtime.removeCommand("METHOD");
            runtime.removeCommand("FIELD:STATIC");
            runtime.addCommand("RANDOM", params -> runtime.setPointer(runtime.getOut(), (Object)Math.random()));
            runtime.addCommand("MODIFY", params -> {
                String id = (String)runtime.getVals().get(0);
                String key = (String)runtime.getVals().get(1);
                String value = (String)runtime.getVals().get(2);
                for (Component component : frame.layout.components) {
                    if (!(component instanceof ModuleLayout)) continue;
                    ModuleLayout moduleLayout = (ModuleLayout)component;
                    if (!id.equals(moduleLayout.entry.getId())) continue;
                    HashMap<String, String> newData = new HashMap<String, String>(moduleLayout.entry.getData());
                    newData.put(key, value);
                    moduleLayout.entry.setData(newData);
                    moduleLayout.modify();
                }
            });
            frame.aPointRuntime = runtime;
        }
    }

    public static void setTimeout(Runnable runnable, int delay) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                runnable.run();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }).start();
    }

    @Override
    public void tick(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
    }

    @Override
    public void modify(GitWebFrame frame, ModuleLayout layout, int width, Map<String, String> data) {
        this.generate(frame, layout, width, data);
    }
}

