/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.snake.layout;

import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.programs.snake.SnakeApp;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;

public class SnakeLayout
extends Layout {
    public SnakeLayout(SnakeApp app) {
        super(150, 150);
        Button button = new Button(1, 1, Icons.ARROW_LEFT);
        button.setClickListener((mouseX, mouseY, mouseButton) -> app.setCurrentLayout(app.titleScreen));
        this.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(x + height), (int)new Color(0, 0, 0).getRGB()));
        this.addComponent(button);
        this.addComponent(new Grid(0, 0));
    }

    @Override
    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        super.render(pose, laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
    }

    @Override
    public void handleLoad() {
        super.handleLoad();
    }

    @Override
    public void handleTick() {
        super.handleTick();
    }

    public static class Grid
    extends Component {
        private ArrayList<Pos2d> snakePos = new ArrayList<Pos2d>(){

            @Override
            public Pos2d get(int index) {
                try {
                    return (Pos2d)super.get(index);
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        private Direction2d direction2d = Direction2d.UP;
        private int speed = 5;
        private int tick = 0;
        private Pos2d applePos;

        public Grid(int left, int top) {
            super(left, top);
            Pos2d initialPos = new Pos2d(5, 5);
            initialPos.first = true;
            Pos2d lastInitPos = new Pos2d(5, 7);
            lastInitPos.last = true;
            this.snakePos.add(lastInitPos);
            this.snakePos.add(new Pos2d(5, 6));
            this.snakePos.add(initialPos);
            this.applePos = new Pos2d((int)(Math.random() * 15.0), (int)(Math.random() * 15.0));
            boolean clean = false;
            while (!clean) {
                for (Pos2d pos : this.snakePos) {
                    if (!pos.samePos(this.applePos)) continue;
                    this.applePos = new Pos2d((int)(Math.random() * 15.0), (int)(Math.random() * 15.0));
                }
                boolean isC = true;
                for (Pos2d pos : this.snakePos) {
                    if (!pos.samePos(this.applePos)) continue;
                    isC = false;
                }
                if (!isC) continue;
                clean = true;
            }
        }

        @Override
        protected void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            super.render(pose, laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
            Color black = new Color(0.0f, 0.0f, 0.0f, 0.5f);
            int intBlack = black.getRGB();
            int white = new Color(255, 255, 255).getRGB();
            int red = new Color(255, 0, 0).getRGB();
            for (int i = 0; i < this.snakePos.size(); ++i) {
                this.renderConnectedSnakePart(pose, x, y, white, i);
            }
            class_329.method_25294((class_4587)pose, (int)(x + this.applePos.x * 10), (int)(y + this.applePos.y * 10), (int)(x + this.applePos.x * 10 + 10), (int)(y + this.applePos.y * 10 + 10), (int)red);
        }

        private void renderConnectedSnakePart(class_4587 pose, int x, int y, int color, int index) {
            Pos2d pos = this.snakePos.get(index);
            class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10 + 1), (int)(y + pos.y * 10 + 1), (int)(x + pos.x * 10 + 10 - 1), (int)(y + pos.y * 10 + 10 - 1), (int)color);
            if (this.snakePos.get(index + 1) != null && this.snakePos.get(index).right().samePos(this.snakePos.get(index + 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10 + 10 - 1), (int)(y + pos.y * 10 + 1), (int)(x + pos.x * 10 + 10), (int)(y + pos.y * 10 + 10 - 1), (int)color);
            }
            if (this.snakePos.get(index - 1) != null && this.snakePos.get(index).right().samePos(this.snakePos.get(index - 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10 + 10 - 1), (int)(y + pos.y * 10 + 1), (int)(x + pos.x * 10 + 10), (int)(y + pos.y * 10 + 10 - 1), (int)color);
            }
            if (this.snakePos.get(index + 1) != null && this.snakePos.get(index).left().samePos(this.snakePos.get(index + 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10), (int)(y + pos.y * 10 + 1), (int)(x + pos.x * 10 + 1), (int)(y + pos.y * 10 + 10 - 1), (int)color);
            }
            if (this.snakePos.get(index - 1) != null && this.snakePos.get(index).left().samePos(this.snakePos.get(index - 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10), (int)(y + pos.y * 10 + 1), (int)(x + pos.x * 10 + 1), (int)(y + pos.y * 10 + 10 - 1), (int)color);
            }
            if (this.snakePos.get(index + 1) != null && this.snakePos.get(index).down().samePos(this.snakePos.get(index + 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10 + 1), (int)(y + pos.y * 10 + 10 - 1), (int)(x + pos.x * 10 + 10 - 1), (int)(y + pos.y * 10 + 10), (int)color);
            }
            if (this.snakePos.get(index - 1) != null && this.snakePos.get(index).down().samePos(this.snakePos.get(index - 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10 + 1), (int)(y + pos.y * 10 + 10 - 1), (int)(x + pos.x * 10 + 10 - 1), (int)(y + pos.y * 10 + 10), (int)color);
            }
            if (this.snakePos.get(index + 1) != null && this.snakePos.get(index).up().samePos(this.snakePos.get(index + 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10 + 1), (int)(y + pos.y * 10), (int)(x + pos.x * 10 + 10 - 1), (int)(y + pos.y * 10 + 1), (int)color);
            }
            if (this.snakePos.get(index - 1) != null && this.snakePos.get(index).up().samePos(this.snakePos.get(index - 1))) {
                class_329.method_25294((class_4587)pose, (int)(x + pos.x * 10 + 1), (int)(y + pos.y * 10), (int)(x + pos.x * 10 + 10 - 1), (int)(y + pos.y * 10 + 1), (int)color);
            }
        }

        @Override
        public void handleKeyPressed(int keyCode, int scanCode, int modifiers) {
            super.handleKeyPressed(keyCode, scanCode, modifiers);
            switch (keyCode) {
                case 87: {
                    this.up();
                    break;
                }
                case 83: {
                    this.down();
                    break;
                }
                case 65: {
                    this.left();
                    break;
                }
                case 68: {
                    this.right();
                }
            }
        }

        private void up() {
            System.out.println("UP");
            this.direction2d = Direction2d.UP;
        }

        private void down() {
            System.out.println("DOWN");
            this.direction2d = Direction2d.DOWN;
        }

        private void left() {
            System.out.println("LEFT");
            this.direction2d = Direction2d.LEFT;
        }

        private void right() {
            System.out.println("RIGHT");
            this.direction2d = Direction2d.RIGHT;
        }

        @Override
        protected void handleTick() {
            super.handleTick();
            if (this.tick > this.speed) {
                this.tick = 0;
                Pos2d newPos = null;
                Pos2d newLastPos = null;
                Pos2d first = this.snakePos.get(this.snakePos.size() - 1);
                newPos = first.dir(this.direction2d);
                for (Pos2d pos : this.snakePos) {
                    if (!newPos.samePos(pos)) continue;
                    this.speed = 999999999;
                    return;
                }
                if (newPos.x < 0 || newPos.x > 14 || newPos.y < 0 || newPos.y > 15) {
                    this.speed = 999999999;
                    return;
                }
                newPos.setFirst();
                Pos2d last = this.findLastPos();
                this.snakePos.remove(last);
                newLastPos = this.findLastPos();
                newLastPos.setLast();
                assert (newPos != null);
                this.snakePos.add(newPos);
                if (this.applePos.samePos(this.snakePos.get(this.snakePos.size() - 1))) {
                    this.newApplePos();
                    Pos2d newLast = new Pos2d(newLastPos.x, newLastPos.y);
                    newLast.setLast();
                    this.snakePos.add(0, newLast);
                }
            }
            ++this.tick;
        }

        private Pos2d findLastPos() {
            return this.snakePos.get(0);
        }

        private void newApplePos() {
            this.applePos = new Pos2d((int)(Math.random() * 15.0), (int)(Math.random() * 15.0));
            boolean clean = false;
            while (!clean) {
                for (Pos2d pos : this.snakePos) {
                    if (!pos.samePos(this.applePos)) continue;
                    this.applePos = new Pos2d((int)(Math.random() * 15.0), (int)(Math.random() * 15.0));
                }
                boolean isC = true;
                for (Pos2d pos : this.snakePos) {
                    if (!pos.samePos(this.applePos)) continue;
                    isC = false;
                }
                if (!isC) continue;
                clean = true;
            }
        }

        private static enum Direction2d {
            LEFT,
            RIGHT,
            UP,
            DOWN;

        }

        private class Pos2d {
            private int x;
            private int y;
            private boolean last;
            private boolean first;

            public Pos2d(int x, int y) {
                this.x = x;
                this.y = y;
            }

            private boolean samePos(Pos2d pos) {
                return pos.x == this.x && pos.y == this.y;
            }

            private Pos2d dir(Direction2d direction2d) {
                return switch (direction2d) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction2d.UP -> this.up();
                    case Direction2d.DOWN -> this.down();
                    case Direction2d.LEFT -> this.left();
                    case Direction2d.RIGHT -> this.right();
                };
            }

            private Pos2d up() {
                return new Pos2d(this.x, this.y - 1);
            }

            private Pos2d down() {
                return new Pos2d(this.x, this.y + 1);
            }

            private Pos2d left() {
                return new Pos2d(this.x - 1, this.y);
            }

            private Pos2d right() {
                return new Pos2d(this.x + 1, this.y);
            }

            private void setLast() {
                for (Pos2d pos2d : Grid.this.snakePos) {
                    if (!pos2d.last) continue;
                    pos2d.last = false;
                }
                this.last = true;
            }

            private void setFirst() {
                for (Pos2d pos2d : Grid.this.snakePos) {
                    if (!pos2d.first) continue;
                    pos2d.first = false;
                }
                this.first = true;
            }
        }
    }
}

