/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.ScrollableLayout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.api.app.component.Spinner;
import com.ultreon.devices.api.utils.OnlineRequest;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.object.TrayItem;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.programs.system.component.AppGrid;
import com.ultreon.devices.programs.system.layout.LayoutAppPage;
import com.ultreon.devices.programs.system.layout.LayoutSearchApps;
import com.ultreon.devices.programs.system.object.AppEntry;
import com.ultreon.devices.programs.system.object.RemoteEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;

public class AppStore
extends SystemApp {
    public static final String CERTIFICATES_BASE_URL = "https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master";
    public static final int LAYOUT_WIDTH = 250;
    public static final int LAYOUT_HEIGHT = 150;
    public List<AppEntry> certifiedApps = new ArrayList<AppEntry>();
    public List<AppEntry> localAppList = new ArrayList<AppEntry>();
    private Layout layoutMain;
    private AppInfo queuedApp;

    @Override
    public void init(@Nullable class_2487 intent) {
        this.layoutMain = new Layout(250, 150);
        int q = ApplicationManager.getAvailableApplications().size();
        int rows = (int)Math.round(Math.ceil((double)q / 3.0));
        ScrollableLayout homePageLayout = new ScrollableLayout(0, 0, 250, 208 + 80 * rows, 150);
        homePageLayout.setScrollSpeed(10);
        homePageLayout.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getBackgroundColor());
            int offset = 60;
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + offset), (int)(x + 250), (int)(y + offset + 1), (int)color.brighter().getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + offset + 1), (int)(x + 250), (int)(y + offset + 19), (int)color.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + offset + 19), (int)(x + 250), (int)(y + offset + 20), (int)color.darker().getRGB());
            offset = 172;
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + offset), (int)(x + 250), (int)(y + offset + 1), (int)color.brighter().getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + offset + 1), (int)(x + 250), (int)(y + offset + 19), (int)color.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + offset + 19), (int)(x + 250), (int)(y + offset + 20), (int)color.darker().getRGB());
        });
        Image imageBanner = new Image(0, 0, 250, 60);
        imageBanner.setImage(new class_2960("devices", "textures/gui/app_market_background.png"));
        imageBanner.setDrawFull(true);
        homePageLayout.addComponent(imageBanner);
        Button btnSearch = new Button(5, 5, Icons.SEARCH);
        btnSearch.setToolTip("Search", "Find a specific application");
        btnSearch.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(new LayoutSearchApps(this, this.getCurrentLayout()));
            }
        });
        homePageLayout.addComponent(btnSearch);
        Button btnManageApps = new Button(23, 5, Icons.HAMMER);
        btnManageApps.setToolTip("Manage Apps", "Manage your installed applications");
        homePageLayout.addComponent(btnManageApps);
        Image image = new Image(5, 33, 20, 20, Icons.SHOP);
        homePageLayout.addComponent(image);
        Label labelBanner = new Label("App Market", 32, 35);
        labelBanner.setScale(2.0);
        homePageLayout.addComponent(labelBanner);
        Label labelCertified = new Label(class_124.field_1068 + class_124.field_1067.toString() + "Certified Apps", 10, 66);
        homePageLayout.addComponent(labelCertified);
        Label labelCertifiedDesc = new Label(class_124.field_1080 + "Verified by Ultreon Team", 240, 66);
        labelCertifiedDesc.setAlignment(1);
        labelCertifiedDesc.setScale(1.0);
        labelCertifiedDesc.setShadow(false);
        homePageLayout.addComponent(labelCertifiedDesc);
        Spinner spinner = new Spinner(119, 120);
        homePageLayout.addComponent(spinner);
        OnlineRequest.getInstance().make("https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/certified_apps.json", (success, response) -> {
            this.certifiedApps.clear();
            spinner.setVisible(false);
            if (success) {
                class_310.method_1551().method_18859(() -> {
                    AppGrid grid = new AppGrid(0, 81, 3, 1, this);
                    this.certifiedApps.addAll(this.parseJson(response));
                    this.shuffleAndShrink(this.certifiedApps, 3).forEach(grid::addEntry);
                    homePageLayout.addComponent(grid);
                    grid.reloadIcons();
                });
            }
        });
        Label labelOther = new Label(class_124.field_1068 + class_124.field_1067.toString() + "Other Apps", 10, 178);
        homePageLayout.addComponent(labelOther);
        Label labelOtherDesc = new Label(class_124.field_1080 + "Community Created", 240, 178);
        labelOtherDesc.setAlignment(1);
        labelOtherDesc.setScale(1.0);
        labelOtherDesc.setShadow(false);
        homePageLayout.addComponent(labelOtherDesc);
        AppGrid other = new AppGrid(0, 192, 3, rows, this);
        this.shuffleAndShrink(ApplicationManager.getAvailableApplications(), q).forEach(a -> this.localAppList.add(other.addEntry((AppInfo)a)));
        homePageLayout.addComponent(other);
        this.layoutMain.addComponent(homePageLayout);
        this.setCurrentLayout(this.layoutMain);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.queuedApp != null) {
            for (AppEntry appEntry : this.localAppList) {
                if (!appEntry.id().equals(this.queuedApp.getId().toString())) continue;
                this.openApplication(appEntry);
                this.queuedApp = null;
                break;
            }
        }
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }

    public void queueOpen(AppInfo info) {
        this.queuedApp = info;
    }

    public List<RemoteEntry> parseJson(String json) {
        ArrayList<RemoteEntry> entries = new ArrayList<RemoteEntry>();
        JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
        Gson gson = new Gson();
        array.forEach(element -> entries.add((RemoteEntry)gson.fromJson(element, new TypeToken<RemoteEntry>(){}.getType())));
        return entries;
    }

    public void openApplication(AppEntry entry) {
        LayoutAppPage layout = new LayoutAppPage(this.getLaptop(), entry, this);
        this.setCurrentLayout(layout);
        Button btnPrevious = new Button(2, 2, Icons.ARROW_LEFT);
        btnPrevious.setClickListener((mouseX1, mouseY1, mouseButton1) -> this.setCurrentLayout(this.layoutMain));
        layout.addComponent(btnPrevious);
    }

    private <T> List<T> shuffleAndShrink(List<T> list, int newSize) {
        Collections.shuffle(list);
        return list.subList(0, Math.min(list.size(), newSize));
    }

    public static class StoreTrayItem
    extends TrayItem {
        public StoreTrayItem() {
            super(Icons.SHOP);
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication(Devices.id("app_store"));
            if (info != null) {
                Laptop.getSystem().openApplication(info);
            }
        }
    }
}

