/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.app.Dialog;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.api.app.component.Text;
import com.ultreon.devices.api.app.component.TextField;
import com.ultreon.devices.api.task.Callback;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.api.utils.BankUtil;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.programs.system.task.TaskDeposit;
import com.ultreon.devices.programs.system.task.TaskWithdraw;
import com.ultreon.devices.util.InventoryUtil;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class BankApp
extends Application {
    private static final class_1799 EMERALD = new class_1799((class_1935)class_1802.field_8687);
    private static final class_2960 BANK_ASSETS = new class_2960("devices:textures/gui/bank.png");
    private Layout layoutStart;
    private Label labelTeller;
    private Text textWelcome;
    private Button btnDepositWithdraw;
    private Button btnTransfer;
    private Layout layoutMain;
    private Label labelBalance;
    private Label labelAmount;
    private TextField amountField;
    private Button btnOne;
    private Button btnTwo;
    private Button btnThree;
    private Button btnFour;
    private Button btnFive;
    private Button btnSix;
    private Button btnSeven;
    private Button btnEight;
    private Button btnNine;
    private Button btnZero;
    private Button btnClear;
    private Button buttonDeposit;
    private Button buttonWithdraw;
    private Label labelEmeraldAmount;
    private Label labelInventory;
    private int emeraldAmount;
    private int rotation;

    @Override
    public void onTick() {
        super.onTick();
        ++this.rotation;
        if (this.rotation >= 100) {
            this.rotation = 0;
        }
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        this.layoutStart = new Layout();
        this.layoutStart.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            assert (class_310.method_1551().field_1687 != null);
            pose.method_22903();
            RenderSystem.enableDepthTest();
            pose.method_22904((double)(x + 25), (double)(y + 33), 15.0);
            pose.method_22905(-2.5f, -2.5f, -2.5f);
            float scaleX = (float)(mouseX - x - 25) / (float)width;
            float scaleY = (float)(mouseY - y - 20) / (float)height;
            class_4597.class_4598 buffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            class_1646 villager = (class_1646)class_1299.field_6077.method_5883((class_1937)class_310.method_1551().field_1687);
            assert (villager != null);
            villager.method_7195(new class_3850(class_3854.field_17073, class_3852.field_17062, 1));
            villager.method_7231().method_16921(class_3852.field_17062);
            pose.method_22903();
            pose.method_22905(scaleX, scaleY, 1.0f);
            pose.method_22909();
            RenderSystem.disableDepthTest();
            pose.method_22909();
            RenderSystem.setShaderTexture((int)0, (class_2960)BANK_ASSETS);
            RenderUtil.drawRectWithTexture(pose, x + 46, y + 19, 0.0f, 0.0f, 146, 52, 146.0f, 52.0f);
        });
        this.labelTeller = new Label(class_124.field_1054 + "Casey The Teller", 60, 7);
        this.layoutStart.addComponent(this.labelTeller);
        assert (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 != null);
        this.textWelcome = new Text(class_124.field_1074 + "Hello " + class_310.method_1551().field_1724.method_7334().getName() + ", welcome to The Emerald Bank! How can I help you?", 62, 25, 125);
        this.layoutStart.addComponent(this.textWelcome);
        this.btnDepositWithdraw = new Button(54, 74, "View Account");
        this.btnDepositWithdraw.setSize(76, 20);
        this.btnDepositWithdraw.setToolTip("View Account", "Shows your balance");
        this.layoutStart.addComponent(this.btnDepositWithdraw);
        this.btnTransfer = new Button(133, 74, "Transfer");
        this.btnTransfer.setSize(58, 20);
        this.btnTransfer.setToolTip("Transfer", "Withdraw and deposit emeralds");
        this.btnTransfer.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(this.layoutMain);
            }
        });
        this.layoutStart.addComponent(this.btnTransfer);
        this.setCurrentLayout(this.layoutStart);
        this.layoutMain = new Layout(120, 143){

            @Override
            public void handleTick() {
                super.handleTick();
                int amount = InventoryUtil.getItemAmount((class_1657)class_310.method_1551().field_1724, class_1802.field_8687);
                BankApp.this.labelEmeraldAmount.setText("x " + amount);
            }
        };
        this.layoutMain.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + 40), (int)Color.GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 39), (int)(x + width), (int)(y + 40), (int)Color.DARK_GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)(x + 62), (int)(y + 103), (int)(x + 115), (int)(y + 138), (int)Color.BLACK.getRGB());
            class_329.method_25294((class_4587)pose, (int)(x + 63), (int)(y + 104), (int)(x + 114), (int)(y + 113), (int)Color.DARK_GRAY.getRGB());
            class_329.method_25294((class_4587)pose, (int)(x + 63), (int)(y + 114), (int)(x + 114), (int)(y + 137), (int)Color.GRAY.getRGB());
            RenderUtil.renderItem(x + 65, y + 118, EMERALD, false);
        });
        this.labelBalance = new Label("Balance", 60, 5);
        this.labelBalance.setAlignment(2);
        this.labelBalance.setShadow(false);
        this.layoutMain.addComponent(this.labelBalance);
        this.labelAmount = new Label("Loading balance...", 60, 18);
        this.labelAmount.setAlignment(2);
        this.labelAmount.setScale(2.0);
        this.layoutMain.addComponent(this.labelAmount);
        this.amountField = new TextField(5, 45, 110);
        this.amountField.setText("0");
        this.amountField.setEditable(false);
        this.layoutMain.addComponent(this.amountField);
        for (int i = 0; i < 9; ++i) {
            int posX = 5 + i % 3 * 19;
            int posY = 65 + i / 3 * 19;
            Button button = new Button(posX, posY, Integer.toString(i + 1));
            button.setSize(16, 16);
            this.addNumberClickListener(button, this.amountField, i + 1);
            this.layoutMain.addComponent(button);
        }
        this.btnZero = new Button(5, 122, "0");
        this.btnZero.setSize(16, 16);
        this.addNumberClickListener(this.btnZero, this.amountField, 0);
        this.layoutMain.addComponent(this.btnZero);
        this.btnClear = new Button(24, 122, "Clr");
        this.btnClear.setSize(35, 16);
        this.btnClear.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.amountField.setText("0");
            }
        });
        this.layoutMain.addComponent(this.btnClear);
        this.buttonDeposit = new Button(62, 65, "Deposit");
        this.buttonDeposit.setSize(53, 16);
        this.buttonDeposit.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.amountField.getText().equals("0")) {
                    return;
                }
                try {
                    int amount = Integer.parseInt(this.amountField.getText());
                    this.deposit(amount, (tag, success) -> {
                        if (success) {
                            assert (tag != null);
                            int balance = tag.method_10550("balance");
                            this.labelAmount.setText("$" + balance);
                            this.amountField.setText("0");
                        }
                    });
                }
                catch (NumberFormatException e) {
                    this.amountField.setText("0");
                    this.openDialog(new Dialog.Message("Invalid amount. The maximum that you can deposit is 2147483647"));
                }
            }
        });
        this.layoutMain.addComponent(this.buttonDeposit);
        this.buttonWithdraw = new Button(62, 84, "Withdraw");
        this.buttonWithdraw.setSize(53, 16);
        this.buttonWithdraw.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.amountField.getText().equals("0")) {
                    return;
                }
                try {
                    int amount = Integer.parseInt(this.amountField.getText());
                    this.withdraw(amount, (tag, success) -> {
                        if (success) {
                            assert (tag != null);
                            int balance = tag.method_10550("balance");
                            this.labelAmount.setText("$" + balance);
                            this.amountField.setText("0");
                        }
                    });
                }
                catch (NumberFormatException e) {
                    this.amountField.setText("0");
                    this.openDialog(new Dialog.Message("Invalid amount. The maximum that you can withdraw is 2147483647"));
                }
            }
        });
        this.layoutMain.addComponent(this.buttonWithdraw);
        this.labelEmeraldAmount = new Label("x 0", 83, 123);
        this.layoutMain.addComponent(this.labelEmeraldAmount);
        this.labelInventory = new Label("Wallet", 74, 105);
        this.labelInventory.setShadow(false);
        this.layoutMain.addComponent(this.labelInventory);
        BankUtil.getBalance((tag, success) -> {
            if (success) {
                assert (tag != null);
                int balance = tag.method_10550("balance");
                this.labelAmount.setText("$" + balance);
            }
        });
    }

    public void addNumberClickListener(Button btn, TextField field, int number) {
        btn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (!(mouseButton != 0 || field.getText().equals("0") && number == 0)) {
                if (field.getText().equals("0")) {
                    field.clear();
                }
                field.writeText(Integer.toString(number));
            }
        });
    }

    private void deposit(int amount, Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskDeposit(amount).setCallback(callback));
    }

    private void withdraw(int amount, Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskWithdraw(amount).setCallback(callback));
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }
}

