/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system;

import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.Text;
import com.ultreon.devices.api.app.listener.ClickListener;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.system.SystemApp;
import java.awt.Color;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public final class DiagnosticsApp
extends SystemApp {
    private String messageText;
    private final AppInfo appInfo;
    private final Application application;
    private ClickListener positiveListener;

    public DiagnosticsApp() {
        this.messageText = "Unknown app crashed";
        this.appInfo = null;
        this.application = null;
    }

    public DiagnosticsApp(AppInfo appInfo) {
        Object messageText;
        this.appInfo = appInfo;
        try {
            messageText = "App Crashed:\n" + appInfo.getName();
        }
        catch (Exception e) {
            messageText = "App Crashed";
        }
        this.messageText = messageText;
        this.application = null;
    }

    public DiagnosticsApp(Application app) {
        String messageText;
        AppInfo appInfo;
        try {
            appInfo = app.getInfo();
        }
        catch (Exception e) {
            appInfo = null;
        }
        this.appInfo = appInfo;
        try {
            messageText = appInfo == null ? "App Crashed" : "App Crashed:\n" + this.appInfo.getName();
        }
        catch (Exception e) {
            messageText = "App Crashed";
        }
        this.messageText = messageText;
        this.application = app;
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        String applicationName = null;
        if (intent != null) {
            applicationName = intent.method_10558("applicationName");
        }
        this.messageText = applicationName == null ? "App Crashed" : "App Crashed:\n" + applicationName;
        Layout layoutMain = new Layout(150, 40);
        int textHeight = class_310.method_1551().field_1772.method_1713(this.messageText, this.getWidth() - 10);
        layoutMain.height += textHeight;
        layoutMain.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.LIGHT_GRAY.getRGB()));
        Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
        this.addComponent(message);
        Button buttonPositive = new Button(this.getWidth() - 41, this.getHeight() - 20, "Close");
        buttonPositive.setSize(36, 16);
        buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.positiveListener != null) {
                this.positiveListener.onClick(mouseX, mouseY, mouseButton);
            }
            this.getWindow().close();
        });
        this.addComponent(buttonPositive);
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }

    public void setPositiveListener(ClickListener positiveListener) {
        this.positiveListener = positiveListener;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public Application getApplication() {
        return this.application;
    }
}

