/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system;

import com.ultreon.devices.Devices;
import com.ultreon.devices.Reference;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.Dialog;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.ScrollableLayout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.CheckBox;
import com.ultreon.devices.api.app.component.ComboBox;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.api.app.component.Text;
import com.ultreon.devices.api.app.renderer.ItemRenderer;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.core.Settings;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.object.TrayItem;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.programs.system.component.Palette;
import com.ultreon.devices.programs.system.object.ColorScheme;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class SettingsApp
extends SystemApp {
    private Button backBtn;
    private Layout layoutMain;
    private Layout layoutGeneral;
    private CheckBox checkBoxShowApps;
    private Layout layoutPersonalise;
    private Layout layoutWallpaper;
    private Button prevWallpaperBtn;
    private Button nextWallpaperBtn;
    private Button urlWallpaperBtn;
    private Layout layoutColorScheme;
    private Button buttonColorSchemeApply;
    private final Stack<Layout> predecessor = new Stack();

    private void resetColorSchemeClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            Laptop.getSystem().getSettings().getColorScheme().resetDefault();
        }
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        this.backBtn = new Button(2, 2, Icons.ARROW_LEFT);
        this.backBtn.setVisible(false);
        this.backBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.predecessor.size() > 0) {
                    this.setCurrentLayout(this.predecessor.pop());
                }
                if (this.predecessor.isEmpty()) {
                    this.backBtn.setVisible(false);
                }
            }
        });
        this.layoutMain = this.addMainLayout();
        this.setCurrentLayout(this.layoutMain);
    }

    private Menu addMainLayout() {
        Menu layoutMain = new Menu("Home");
        Button aboutButton = new Button(5, 26, "About", Icons.INFO);
        aboutButton.setSize(90, 20);
        aboutButton.setClickListener((__, ___, ____) -> {
            Menu qq = new Menu("About");
            qq.addComponent(this.backBtn);
            ScrollableLayout l = new ScrollableLayout(layoutMain.width, layoutMain.height, 124);
            l.top = 26;
            l = ScrollableLayout.create(0, 26, layoutMain.width, 124, MessageFormat.format("Version: {0} ({1})\n", Reference.getVerInfo()[0], Reference.getVerInfo()[1]));
            qq.addComponent(l);
            this.showMenu(qq);
        });
        layoutMain.addComponent(aboutButton);
        Button buttonColorScheme = new Button(5, 50, "Personalise", Icons.EDIT);
        buttonColorScheme.setSize(90, 20);
        buttonColorScheme.setToolTip("Personalise", "Change the wallpaper, UI colors, and more!");
        buttonColorScheme.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.showMenu(this.layoutPersonalise);
            }
        });
        layoutMain.addComponent(buttonColorScheme);
        this.layoutGeneral = new Menu("General");
        this.layoutGeneral.addComponent(this.backBtn);
        this.checkBoxShowApps = new CheckBox("Show All Apps", 5, 5);
        this.checkBoxShowApps.setSelected(Settings.isShowAllApps());
        this.checkBoxShowApps.setClickListener(this::showAllAppsClick);
        this.layoutGeneral.addComponent(this.checkBoxShowApps);
        this.layoutPersonalise = this.createPersonaliseLayout();
        return layoutMain;
    }

    private Layout createPersonaliseLayout() {
        Menu layoutPersonalise = new Menu("Personalise");
        layoutPersonalise.addComponent(this.backBtn);
        Button buttonWallpaper = new Button(5, 26, "Wallpaper", Icons.EDIT);
        buttonWallpaper.setSize(90, 20);
        buttonWallpaper.setToolTip("Wallpaper", "Manage the wallpaper.");
        buttonWallpaper.setClickListener(this::wallpaperClick);
        layoutPersonalise.addComponent(buttonWallpaper);
        this.layoutWallpaper = this.addWallpaperLayout();
        Button buttonReset = new Button(6, 100, "Reset Color Scheme");
        buttonReset.setClickListener(this::resetColorSchemeClick);
        buttonReset.top = layoutPersonalise.height - buttonReset.getHeight() - 5;
        layoutPersonalise.addComponent(buttonReset);
        layoutPersonalise.addComponent(this.backBtn);
        this.layoutColorScheme = this.createColorSchemeLayout();
        Button buttonColorScheme = new Button(6, 80, "Color scheme");
        buttonColorScheme.setClickListener(this::colorSchemeClick);
        buttonColorScheme.top = layoutPersonalise.height - buttonColorScheme.getHeight() - 25;
        layoutPersonalise.addComponent(buttonColorScheme);
        return layoutPersonalise;
    }

    private Layout createColorSchemeLayout() {
        Menu layoutColorScheme = new Menu("UI Colors");
        layoutColorScheme.addComponent(this.backBtn);
        ComboBox.Custom<Integer> comboBoxTextColor = this.createColorPicker(145, 26);
        comboBoxTextColor.setValue(Laptop.getSystem().getSettings().getColorScheme().getTextColor());
        layoutColorScheme.addComponent(comboBoxTextColor);
        ComboBox.Custom<Integer> comboBoxTextSecondaryColor = this.createColorPicker(145, 44);
        comboBoxTextSecondaryColor.setValue(Laptop.getSystem().getSettings().getColorScheme().getTextSecondaryColor());
        layoutColorScheme.addComponent(comboBoxTextSecondaryColor);
        ComboBox.Custom<Integer> comboBoxHeaderColor = this.createColorPicker(145, 62);
        comboBoxHeaderColor.setValue(Laptop.getSystem().getSettings().getColorScheme().getHeaderColor());
        layoutColorScheme.addComponent(comboBoxHeaderColor);
        ComboBox.Custom<Integer> comboBoxBackgroundColor = this.createColorPicker(145, 80);
        comboBoxBackgroundColor.setValue(Laptop.getSystem().getSettings().getColorScheme().getBackgroundColor());
        layoutColorScheme.addComponent(comboBoxBackgroundColor);
        ComboBox.Custom<Integer> comboBoxBackgroundSecondaryColor = this.createColorPicker(145, 98);
        comboBoxBackgroundSecondaryColor.setValue(Laptop.getSystem().getSettings().getColorScheme().getBackgroundSecondaryColor());
        layoutColorScheme.addComponent(comboBoxBackgroundSecondaryColor);
        ComboBox.Custom<Integer> comboBoxItemBackgroundColor = this.createColorPicker(145, 116);
        comboBoxItemBackgroundColor.setValue(Laptop.getSystem().getSettings().getColorScheme().getItemBackgroundColor());
        layoutColorScheme.addComponent(comboBoxItemBackgroundColor);
        ComboBox.Custom<Integer> comboBoxItemHighlightColor = this.createColorPicker(145, 134);
        comboBoxItemHighlightColor.setValue(Laptop.getSystem().getSettings().getColorScheme().getItemHighlightColor());
        layoutColorScheme.addComponent(comboBoxItemHighlightColor);
        this.buttonColorSchemeApply = new Button(5, 79, Icons.CHECK);
        this.buttonColorSchemeApply.setEnabled(false);
        this.buttonColorSchemeApply.setToolTip("Apply", "Set these colors as the new color scheme");
        this.buttonColorSchemeApply.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                ColorScheme colorScheme = Laptop.getSystem().getSettings().getColorScheme();
                colorScheme.setTextColor((Integer)comboBoxTextColor.getValue());
                colorScheme.setTextSecondaryColor((Integer)comboBoxTextSecondaryColor.getValue());
                colorScheme.setHeaderColor((Integer)comboBoxHeaderColor.getValue());
                colorScheme.setBackgroundColor((Integer)comboBoxBackgroundColor.getValue());
                colorScheme.setBackgroundSecondaryColor((Integer)comboBoxBackgroundSecondaryColor.getValue());
                colorScheme.setItemBackgroundColor((Integer)comboBoxItemBackgroundColor.getValue());
                colorScheme.setItemHighlightColor((Integer)comboBoxItemHighlightColor.getValue());
                this.buttonColorSchemeApply.setEnabled(false);
            }
        });
        layoutColorScheme.addComponent(this.buttonColorSchemeApply);
        return layoutColorScheme;
    }

    private Layout addWallpaperLayout() {
        Menu wallpaperLayout = new Menu("Wallpaper");
        Image image = new Image(6, 29, 128, 99);
        image.setBorderThickness(1);
        image.setBorderVisible(true);
        image.setImage(Objects.requireNonNull(this.getLaptop()).getCurrentWallpaper());
        wallpaperLayout.addComponent(image);
        this.prevWallpaperBtn = new Button(135, 27, Icons.ARROW_LEFT);
        this.prevWallpaperBtn.setSize(25, 20);
        this.prevWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Laptop laptop = this.getLaptop();
            if (laptop != null) {
                laptop.prevWallpaper();
                image.setImage(this.getLaptop().getCurrentWallpaper());
            }
        });
        this.prevWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
        wallpaperLayout.addComponent(this.prevWallpaperBtn);
        this.nextWallpaperBtn = new Button(165, 27, Icons.ARROW_RIGHT);
        this.nextWallpaperBtn.setSize(25, 20);
        this.nextWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Laptop laptop = this.getLaptop();
            if (laptop != null) {
                laptop.nextWallpaper();
                image.setImage(this.getLaptop().getCurrentWallpaper());
            }
        });
        this.nextWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
        wallpaperLayout.addComponent(this.nextWallpaperBtn);
        Button resetWallpaperBtn = new Button(6, 100, "Reset Wallpaper");
        resetWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.getLaptop().setWallpaper(0);
                image.setImage(this.getLaptop().getCurrentWallpaper());
                this.prevWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                this.nextWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
            }
        });
        resetWallpaperBtn.top = wallpaperLayout.height - resetWallpaperBtn.getHeight() - 5;
        wallpaperLayout.addComponent(resetWallpaperBtn);
        wallpaperLayout.addComponent(this.backBtn);
        this.urlWallpaperBtn = new Button(135, 52, "Load", Icons.EARTH);
        this.urlWallpaperBtn.setSize(55, 20);
        this.urlWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Dialog.Input dialog = new Dialog.Input("Enter the URL of the image");
            dialog.setResponseHandler((success, string) -> {
                if (this.getLaptop() != null) {
                    this.getLaptop().setWallpaper((String)string);
                    image.setImage(this.getLaptop().getCurrentWallpaper());
                    this.prevWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                    this.nextWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                }
                return success;
            });
            this.openDialog(dialog);
        });
        wallpaperLayout.addComponent(this.urlWallpaperBtn);
        Text wallpaperText = new Text("Wallpaper", image.left + 3, image.top + 3, image.componentWidth - 6);
        wallpaperText.setShadow(true);
        wallpaperText.setTextColor(new Color(this.getLaptop().getSettings().getColorScheme().getTextColor()));
        wallpaperLayout.addComponent(wallpaperText);
        return wallpaperLayout;
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }

    private void showMenu(Layout layout) {
        this.predecessor.push(this.getCurrentLayout());
        this.backBtn.setVisible(true);
        this.setCurrentLayout(layout);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.predecessor.clear();
    }

    private void wallpaperClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.showMenu(this.layoutWallpaper);
        }
    }

    private void colorSchemeClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.showMenu(this.layoutColorScheme);
        }
    }

    private void showAllAppsClick(int mouseX, int mouseY, int mouseButton) {
        Settings.setShowAllApps(this.checkBoxShowApps.isSelected());
        Laptop laptop = this.getLaptop();
        assert (laptop != null);
        laptop.getTaskBar().setupApplications(laptop.getApplications());
    }

    public ComboBox.Custom<Integer> createColorPicker(int left, int top) {
        ComboBox.Custom<Integer> colorPicker = new ComboBox.Custom<Integer>(left, top, 50, 100, 100);
        colorPicker.setValue(Color.RED.getRGB());
        colorPicker.setItemRenderer(new ItemRenderer<Integer>(){

            @Override
            public void render(class_4587 pose, Integer integer, class_332 gui, class_310 mc, int x, int y, int width, int height) {
                if (integer != null) {
                    class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)integer);
                }
            }
        });
        colorPicker.setChangeListener((oldValue, newValue) -> {
            if (this.buttonColorSchemeApply != null) {
                this.buttonColorSchemeApply.setEnabled(true);
            }
        });
        Palette palette = new Palette(5, 5, colorPicker);
        Layout.Context layout = colorPicker.getLayout();
        layout.addComponent(palette);
        return colorPicker;
    }

    public static class Menu
    extends Layout {
        private final String title;

        public Menu(String title) {
            super(200, 150);
            this.title = title;
        }

        @Override
        public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getHeaderColor());
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + this.width), (int)(y + 20), (int)color.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 20), (int)(x + this.width), (int)(y + 21), (int)color.darker().getRGB());
            mc.field_1772.method_1720(pose, this.title, (float)(x + 22), (float)(y + 6), Color.WHITE.getRGB());
            super.render(pose, laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        }
    }

    public static class SettingsTrayItem
    extends TrayItem {
        public SettingsTrayItem() {
            super(Icons.WRENCH);
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication(Devices.id("settings"));
            if (info != null) {
                Laptop.getSystem().openApplication(info);
            }
        }
    }
}

