/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system;

import com.jab125.version.VersionPredicate;
import com.jab125.version.VersionPredicateParser;
import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.IIcon;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.ScrollableLayout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.ItemList;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.api.app.renderer.ListItemRenderer;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.util.Vulnerability;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class VulnerabilityApp
extends SystemApp {
    private long lastClick = 0L;
    private static final Color ITEM_BACKGROUND = Color.decode("0x9E9E9E");
    private static final Color ITEM_SELECTED = Color.decode("0x757575");
    private Layout mainMenu;
    int marginX = 10;
    int marginY = 10;
    int paddingY = 4;

    @Override
    public void init(@Nullable class_2487 intent) {
        this.setCurrentLayout(this.createMenu());
    }

    private Layout createMenu() {
        this.mainMenu = new Layout(250, 105);
        final ItemList<Vulnerability> itemListResults = new ItemList<Vulnerability>(5, 5, 240, 5, true);
        itemListResults.setItems(Devices.getVulnerabilities());
        itemListResults.sortBy(Comparator.comparing(vulnerability -> -vulnerability.effectiveSeverity()));
        itemListResults.setListItemRenderer(new ListItemRenderer<Vulnerability>(18){

            @Override
            public void render(class_4587 pose, Vulnerability app, class_332 gui, class_310 mc, int x, int y, int width, int height, boolean selected) {
                class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? ITEM_SELECTED.getRGB() : ITEM_BACKGROUND.getRGB()));
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IIcon icon = VulnerabilityApp.this.getIconFor(app);
                pose.method_22903();
                pose.method_22904((double)x, (double)y, 0.0);
                pose.method_22904(1.5, 1.5, 0.0);
                pose.method_22905(1.5f, 1.5f, 1.0f);
                icon.draw(pose, mc, 0, 0);
                pose.method_22909();
                RenderUtil.drawStringClipped(pose, app.title(), x + 20, y + 5, itemListResults.getWidth() - 22, Color.WHITE.getRGB(), false);
            }
        });
        itemListResults.setItemClickListener((info, index, mouseButton) -> {
            if (mouseButton == 0) {
                if (System.currentTimeMillis() - this.lastClick <= 200L) {
                    this.setCurrentLayout(this.createMenuFromVulnerability((Vulnerability)info));
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            }
        });
        this.mainMenu.addComponent(itemListResults);
        return this.mainMenu;
    }

    private IIcon getIconFor(Vulnerability app) {
        if (!app.affectsCurrentVersion()) {
            return Icons.WARNING_GRAY;
        }
        int severity = app.severity();
        if (severity < 3) {
            return Icons.WARNING;
        }
        if (severity < 6) {
            return Icons.FLASHED_WARNING;
        }
        if (severity <= 10) {
            return Icons.ERROR;
        }
        return Icons.WARNING;
    }

    private Layout createMenuFromVulnerability(Vulnerability vulnerability) {
        Layout layout = new Layout(250, 105);
        Button behindTheNews = new Button(5, 5, Icons.ARROW_LEFT);
        behindTheNews.setClickListener((__, ___, ____) -> this.setCurrentLayout(this.mainMenu));
        layout.addComponent(behindTheNews);
        layout.addComponent((Component)((Object)class_156.method_654((Object)((Object)new Label(vulnerability.title(), 5, 5 + behindTheNews.getHeight() + 2)), t -> t.setScale(1.25))));
        layout.addComponent(new Label(vulnerability.reporter() == null ? "Unknown" : vulnerability.reporter(), 5, 18 + behindTheNews.getHeight() + 2));
        layout.addComponent(new Label("Affected Versions: " + this.re(vulnerability.affectedVersions()), 5, 28 + behindTheNews.getHeight() + 2));
        layout.addComponent(new Label("Fixed in: " + this.re(vulnerability.fixVersion(), true), 5, 38 + behindTheNews.getHeight() + 2));
        ScrollableLayout d = ScrollableLayout.create(5, 48 + behindTheNews.getHeight() + 2, layout.width - 5, 58 - (behindTheNews.getHeight() + 2), vulnerability.description() == null ? "No description provided" : vulnerability.description(), false);
        layout.addComponent(d);
        return layout;
    }

    private String re(Collection<VersionPredicate> d, boolean e) {
        if (e && d.isEmpty()) {
            return "!(-\u221e,\u221e)";
        }
        ArrayList<String> l = new ArrayList<String>();
        for (VersionPredicate versionPredicate : d) {
            VersionPredicateParser.SingleVersionPredicate p;
            if (versionPredicate instanceof VersionPredicateParser.SingleVersionPredicate && (p = (VersionPredicateParser.SingleVersionPredicate)versionPredicate).getInterval().getMin().equals(p.getInterval().getMax())) {
                l.add(p.getRefVersion().getFriendlyString());
                continue;
            }
            l.add(versionPredicate.getInterval().toString());
        }
        StringBuilder a = new StringBuilder();
        for (String versionInterval : l) {
            a.append(versionInterval).append(" ");
        }
        a.deleteCharAt(a.length() - 1);
        return a.toString();
    }

    private String re(Collection<VersionPredicate> d) {
        return this.re(d, false);
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }
}

