/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Dialog;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.ComboBox;
import com.ultreon.devices.api.app.component.ItemList;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.api.app.component.Spinner;
import com.ultreon.devices.api.app.listener.ItemClickListener;
import com.ultreon.devices.api.app.renderer.ListItemRenderer;
import com.ultreon.devices.api.io.Drive;
import com.ultreon.devices.api.io.File;
import com.ultreon.devices.api.io.Folder;
import com.ultreon.devices.api.task.Callback;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.core.Window;
import com.ultreon.devices.core.Wrappable;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.task.TaskGetFiles;
import com.ultreon.devices.core.io.task.TaskGetStructure;
import com.ultreon.devices.core.io.task.TaskSetupFileBrowser;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.system.SystemApp;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class FileBrowser
extends Component {
    private static final class_2960 ASSETS = new class_2960("devices:textures/gui/file_browser.png");
    private static final Color HEADER_BACKGROUND = Color.decode("0x535861");
    private static final Color ITEM_BACKGROUND = Color.decode("0x9E9E9E");
    private static final Color ITEM_SELECTED = Color.decode("0x757575");
    private static final Color PROTECTED_FILE = new Color(155, 237, 242);
    private static final ListItemRenderer<File> ITEM_RENDERER = new ListItemRenderer<File>(18){

        @Override
        public void render(class_4587 pose, File file, class_332 gui, class_310 mc, int x, int y, int width, int height, boolean selected) {
            Color bgColor = new Color(Laptop.getSystem().getSettings().getColorScheme().getBackgroundColor());
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? bgColor.brighter().brighter().getRGB() : bgColor.brighter().getRGB()));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)ASSETS);
            if (file.isFolder()) {
                RenderUtil.drawRectWithTexture(pose, x + 3, y + 2, 0.0f, 0.0f, 14, 14, 14.0f, 14.0f);
            } else {
                assert (file.getOpeningApp() != null);
                AppInfo info = ApplicationManager.getApplication(class_2960.method_12829((String)file.getOpeningApp()));
                RenderUtil.drawApplicationIcon(pose, info, x + 3, y + 2);
            }
            class_332.method_25303((class_4587)pose, (class_327)class_310.method_1551().field_1772, (String)file.getName(), (int)(x + 22), (int)(y + 5), (int)(file.isProtected() ? PROTECTED_FILE.getRGB() : Laptop.getSystem().getSettings().getColorScheme().getTextColor()));
        }
    };
    public static boolean refreshList = false;
    private final Wrappable wrappable;
    private final Mode mode;
    private Layout layoutMain;
    private ItemList<File> fileList;
    private Button btnPreviousFolder;
    private Button btnNewFolder;
    private Button btnRename;
    private Button btnCopy;
    private Button btnCut;
    private Button btnPaste;
    private Button btnDelete;
    private ComboBox.List<Drive> comboBoxDrive;
    private Label labelPath;
    private Layout layoutLoading;
    private Spinner spinnerLoading;
    private final Stack<Folder> predecessor = new Stack();
    private Drive currentDrive;
    private Folder currentFolder;
    private Drive clipboardDrive;
    private Folder clipboardDir;
    private File clipboardFile;
    private String initialFolder = "/";
    private boolean loadedStructure = false;
    private long lastClick = 0L;
    private ItemClickListener<File> itemClickListener;
    private Predicate<File> filter;

    public FileBrowser(int left, int top, Wrappable wrappable, Mode mode) {
        super(left, top);
        this.wrappable = wrappable;
        this.mode = mode;
    }

    @Override
    public void init(Layout layout) {
        this.layoutMain = new Layout(this.mode.getWidth(), this.mode.getHeight());
        this.layoutMain.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getHeaderColor());
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + 20), (int)color.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 20), (int)(x + width), (int)(y + 21), (int)color.darker().getRGB());
        });
        this.btnPreviousFolder = new Button(5, 2, Icons.ARROW_LEFT);
        this.btnPreviousFolder.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.goToPreviousFolder();
            }
        });
        this.btnPreviousFolder.setToolTip("Previous Folder", "Go back to the previous folder");
        this.btnPreviousFolder.setEnabled(false);
        this.layoutMain.addComponent(this.btnPreviousFolder);
        int btnIndex = 0;
        this.btnNewFolder = new Button(5, 25, Icons.NEW_FOLDER);
        this.btnNewFolder.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.createFolder();
            }
        });
        this.btnNewFolder.setToolTip("New Folder", "Creates a new folder in this directory");
        this.layoutMain.addComponent(this.btnNewFolder);
        this.btnRename = new Button(5, 25 + ++btnIndex * 20, Icons.RENAME);
        this.btnRename.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.renameSelectedFile();
            }
        });
        this.btnRename.setToolTip("Rename", "Change the name of the selected file or folder");
        this.btnRename.setEnabled(false);
        this.layoutMain.addComponent(this.btnRename);
        if (this.mode == Mode.FULL) {
            this.btnCopy = new Button(5, 25 + ++btnIndex * 20, Icons.COPY);
            this.btnCopy.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.setClipboardFileToSelected();
                }
            });
            this.btnCopy.setToolTip("Copy", "Copies the selected file or folder");
            this.btnCopy.setEnabled(false);
            this.layoutMain.addComponent(this.btnCopy);
            this.btnCut = new Button(5, 25 + ++btnIndex * 20, Icons.CUT);
            this.btnCut.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.cutSelectedFile();
                }
            });
            this.btnCut.setToolTip("Cut", "Cuts the selected file or folder");
            this.btnCut.setEnabled(false);
            this.layoutMain.addComponent(this.btnCut);
            this.btnPaste = new Button(5, 25 + ++btnIndex * 20, Icons.CLIPBOARD);
            this.btnPaste.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.pasteClipboardFile();
                }
            });
            this.btnPaste.setToolTip("Paste", "Pastes the copied file into this directory");
            this.btnPaste.setEnabled(false);
            this.layoutMain.addComponent(this.btnPaste);
        }
        this.btnDelete = new Button(5, 25 + ++btnIndex * 20, Icons.TRASH);
        this.btnDelete.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.deleteSelectedFile();
            }
        });
        this.btnDelete.setToolTip("Delete", "Deletes the selected file or folder");
        this.btnDelete.setEnabled(false);
        this.layoutMain.addComponent(this.btnDelete);
        this.fileList = new ItemList(this.mode.getOffset(), 25, 180, this.mode.getVisibleItems());
        this.fileList.setListItemRenderer(ITEM_RENDERER);
        this.fileList.sortBy(File.SORT_BY_NAME);
        this.fileList.setItemClickListener((E file, int index, int mouseButton) -> {
            if (mouseButton == 0) {
                this.btnRename.setEnabled(true);
                this.btnDelete.setEnabled(true);
                if (this.mode == Mode.FULL) {
                    this.btnCopy.setEnabled(true);
                    this.btnCut.setEnabled(true);
                }
                if (System.currentTimeMillis() - this.lastClick <= 200L) {
                    SystemApp systemApp;
                    Laptop laptop;
                    Wrappable patt10290$temp;
                    if (file.isFolder()) {
                        this.fileList.setSelectedIndex(-1);
                        this.openFolder((Folder)file, true, (folder, success) -> {
                            if (this.mode == Mode.FULL) {
                                this.btnRename.setEnabled(false);
                                this.btnCopy.setEnabled(false);
                                this.btnCut.setEnabled(false);
                                this.btnDelete.setEnabled(false);
                            }
                        });
                    } else if (this.mode == Mode.FULL && (patt10290$temp = this.wrappable) instanceof SystemApp && (laptop = (systemApp = (SystemApp)patt10290$temp).getLaptop()) != null) {
                        Application targetApp = laptop.getApplication(file.getOpeningApp());
                        if (targetApp != null) {
                            if (laptop.isApplicationInstalled(targetApp.getInfo())) {
                                if (!((Boolean)laptop.openApplication(targetApp.getInfo(), (File)file).right()).booleanValue()) {
                                    laptop.sendApplicationToFront(systemApp.getInfo());
                                    this.createErrorDialog(targetApp.getInfo().getName() + " was unable to open the file.");
                                }
                            } else {
                                this.createErrorDialog("This file could not be open because the application '" + class_124.field_1054 + targetApp.getInfo().getName() + class_124.field_1070 + "' is not installed.");
                            }
                        } else {
                            this.createErrorDialog("The application designed for this file does not exist.");
                        }
                    }
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            }
            if (this.itemClickListener != null) {
                this.itemClickListener.onClick((File)file, index, mouseButton);
            }
        });
        this.layoutMain.addComponent(this.fileList);
        this.comboBoxDrive = new ComboBox.List<Drive>(26, 3, 44, 100, new Drive[0]);
        this.comboBoxDrive.setChangeListener((oldValue, newValue) -> this.openDrive((Drive)newValue));
        this.comboBoxDrive.setListItemRenderer(new ListItemRenderer<Drive>(12){

            @Override
            public void render(class_4587 pose, Drive drive, class_332 gui, class_310 mc, int x, int y, int width, int height, boolean selected) {
                Color bgColor = new Color(FileBrowser.this.getColorScheme().getBackgroundColor());
                class_332.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? bgColor.brighter().brighter().getRGB() : bgColor.brighter().getRGB()));
                RenderSystem.setShaderTexture((int)0, (class_2960)ASSETS);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.drawRectWithTexture(pose, x + 2, y + 2, drive.getType().ordinal() * 8, 30.0f, 8, 8, 8.0f, 8.0f);
                Object text = drive.getName();
                if (mc.field_1772.method_1727((String)text) > 87) {
                    text = mc.field_1772.method_27523(drive.getName(), 78) + "...";
                }
                mc.field_1772.method_1720(pose, (String)text, (float)(x + 13), (float)(y + 2), Color.WHITE.getRGB());
            }
        });
        this.layoutMain.addComponent(this.comboBoxDrive);
        this.labelPath = new Label("/", 72, 6);
        this.layoutMain.addComponent(this.labelPath);
        layout.addComponent(this.layoutMain);
        this.layoutLoading = new Layout(this.mode.getOffset(), 25, this.fileList.getWidth(), this.fileList.getHeight());
        this.layoutLoading.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)Window.Color_WINDOW_DARK));
        this.layoutLoading.setVisible(false);
        this.spinnerLoading = new Spinner((this.layoutLoading.width - 12) / 2, (this.layoutLoading.height - 12) / 2);
        this.layoutLoading.addComponent(this.spinnerLoading);
        layout.addComponent(this.layoutLoading);
    }

    @Override
    public void handleLoad() {
        if (!this.loadedStructure) {
            this.setLoading(true);
            TaskSetupFileBrowser task = new TaskSetupFileBrowser(Laptop.getPos(), Laptop.getMainDrive() == null);
            task.setCallback((tag, success) -> {
                if (success) {
                    if (Laptop.getMainDrive() == null) {
                        assert (tag != null);
                        class_2487 structureTag = tag.method_10562("structure");
                        Drive drive = new Drive(tag.method_10562("main_drive"));
                        drive.syncRoot(Folder.fromTag("Root", structureTag));
                        drive.getRoot().validate();
                        Laptop.setMainDrive(drive);
                    }
                    assert (tag != null);
                    class_2499 driveList = tag.method_10554("available_drives", 10);
                    Drive[] drives = new Drive[driveList.size() + 1];
                    drives[0] = this.currentDrive = Laptop.getMainDrive();
                    for (int i = 0; i < driveList.size(); ++i) {
                        class_2487 driveTag = driveList.method_10602(i);
                        drives[i + 1] = new Drive(driveTag);
                    }
                    this.comboBoxDrive.setItems((Drive[])drives);
                    Folder folder = this.currentDrive.getFolder(this.initialFolder);
                    if (folder != null) {
                        this.pushPredecessors(folder);
                        this.openFolder(folder, false, (folder1, success1) -> {
                            if (!success1) {
                                this.createErrorDialog("A critical error occurred while initializing.");
                            }
                        });
                        return;
                    }
                    this.openFolder(this.currentDrive.getRoot(), false, (folder12, success12) -> {
                        if (success) {
                            this.createErrorDialog("Unable to open directory '" + this.initialFolder + "'");
                        } else {
                            this.createErrorDialog("A critical error occurred while initializing.");
                        }
                    });
                } else {
                    this.createErrorDialog("A critical error occurred while initializing.");
                }
                this.setLoading(false);
            });
            TaskManager.sendTask(task);
            this.loadedStructure = true;
        }
    }

    @Override
    public void handleTick() {
        if (refreshList) {
            this.fileList.removeAll();
            this.fileList.setItems(this.currentFolder.getFiles());
        }
    }

    public void openFolder(String directory) {
        this.initialFolder = directory;
    }

    private void openDrive(Drive drive) {
        this.predecessor.clear();
        if (drive.isSynced()) {
            this.openFolder(drive.getRoot(), false, (folder, success) -> {
                if (!success) {
                    this.createErrorDialog("Unable to open drive '" + drive.getName() + "'");
                }
            });
        } else {
            this.setLoading(true);
            TaskGetStructure task = new TaskGetStructure(drive, Laptop.getPos());
            task.setCallback((tag, success) -> {
                this.setLoading(false);
                if (success) {
                    assert (tag != null);
                    Folder folder = Folder.fromTag(tag.method_10558("file_name"), tag.method_10562("structure"));
                    drive.syncRoot(folder);
                    this.openFolder(drive.getRoot(), false, (folder1, success1) -> {
                        if (!success1) {
                            this.createErrorDialog("Unable to open drive '" + drive.getName() + "'");
                        }
                    });
                } else {
                    this.createErrorDialog("Unable to retrieve drive structure for '" + drive.getName() + "'");
                }
            });
            TaskManager.sendTask(task);
        }
    }

    private void openFolder(Folder folder, boolean push, Callback<Folder> callback) {
        System.out.println("Opening Folder");
        if (!folder.isSynced()) {
            class_2338 pos = Laptop.getPos();
            System.out.println("Open Folder: " + pos);
            if (pos == null) {
                if (callback != null) {
                    callback.execute(null, false);
                }
                return;
            }
            this.setLoading(true);
            TaskGetFiles task = new TaskGetFiles(folder, pos);
            task.setCallback((tag, success) -> {
                if (success) {
                    assert (tag != null);
                    if (tag.method_10573("files", 9)) {
                        class_2499 files = tag.method_10554("files", 10);
                        folder.syncFiles(files);
                        this.setCurrentFolder(folder, push);
                    }
                }
                if (callback != null) {
                    callback.execute(folder, success);
                }
                this.setLoading(false);
            });
            TaskManager.sendTask(task);
        } else {
            this.setCurrentFolder(folder, push);
            if (callback != null) {
                callback.execute(folder, true);
            }
            this.setLoading(false);
        }
    }

    private void setCurrentFolder(Folder folder, boolean push) {
        if (push) {
            this.predecessor.push(this.currentFolder);
            this.btnPreviousFolder.setEnabled(true);
        }
        this.currentDrive = folder.getDrive();
        this.currentFolder = folder;
        this.fileList.removeAll();
        List<File> files = folder.getFiles();
        if (this.filter != null) {
            files = files.stream().filter(this.filter).collect(Collectors.toList());
        }
        this.fileList.setItems(files);
        this.updatePath();
    }

    private void pushPredecessors(Folder folder) {
        ArrayList<Folder> predecessors = new ArrayList<Folder>();
        for (Folder temp = folder.getParent(); temp != null; temp = temp.getParent()) {
            predecessors.add(temp);
        }
        Collections.reverse(predecessors);
        predecessors.forEach(this.predecessor::push);
        if (this.predecessor.size() > 0) {
            this.btnPreviousFolder.setEnabled(true);
        }
    }

    private void createFolder() {
        Dialog.Input dialog = new Dialog.Input("Enter a name");
        dialog.setResponseHandler((success, v) -> {
            if (success) {
                this.addFile(new Folder((String)v));
            }
            return true;
        });
        dialog.setTitle("Create a Folder");
        dialog.setPositiveText("Create");
        this.wrappable.openDialog(dialog);
    }

    private void goToPreviousFolder() {
        if (this.predecessor.size() > 0) {
            this.setLoading(true);
            Folder folder = this.predecessor.pop();
            this.openFolder(folder, false, (folder2, success) -> {
                if (success) {
                    if (this.isRootFolder()) {
                        this.btnPreviousFolder.setEnabled(false);
                    }
                    this.updatePath();
                } else {
                    this.createErrorDialog("Unable to open previous folder");
                }
                this.setLoading(false);
            });
        }
    }

    public File getSelectedFile() {
        return this.fileList.getSelectedItem();
    }

    public void addFile(File file) {
        this.addFile(file, null);
    }

    public void addFile(File file, Callback<FileSystem.Response> callback) {
        this.setLoading(true);
        this.currentFolder.add(file, (response, success) -> {
            assert (response != null);
            if (response.getStatus() == 1) {
                this.fileList.addItem(file);
                refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
            this.setLoading(false);
        });
    }

    public void addFile(File file, boolean override, Callback<FileSystem.Response> callback) {
        this.setLoading(true);
        this.currentFolder.add(file, override, (response, success) -> {
            assert (response != null);
            if (response.getStatus() == 1) {
                this.fileList.addItem(file);
                refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
            this.setLoading(false);
        });
    }

    private void deleteSelectedFile() {
        File file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be deleted.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            Dialog.Confirmation dialog = new Dialog.Confirmation();
            StringBuilder builder = new StringBuilder();
            builder.append("Are you sure you want to delete this ");
            if (file.isFolder()) {
                builder.append("folder");
            } else {
                builder.append("file");
            }
            builder.append(" '").append(file.getName()).append("'?");
            dialog.setMessageText(builder.toString());
            dialog.setTitle("Delete");
            dialog.setPositiveText("Yes");
            dialog.setPositiveListener((mouseX, mouseY, mouseButton) -> {
                this.removeFile(this.fileList.getSelectedIndex());
                this.btnRename.setEnabled(false);
                this.btnDelete.setEnabled(false);
                if (this.mode == Mode.FULL) {
                    this.btnCopy.setEnabled(false);
                    this.btnCut.setEnabled(false);
                }
            });
            this.wrappable.openDialog(dialog);
        }
    }

    private void removeFile(int index) {
        File file = this.fileList.getItem(index);
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be deleted.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            this.setLoading(true);
            this.currentFolder.delete(file, (response, success) -> {
                if (success) {
                    this.fileList.removeItem(index);
                    refreshList = true;
                }
                this.setLoading(false);
            });
        }
    }

    public void removeFile(String name) {
        File file = this.currentFolder.getFile(name);
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be deleted.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            this.setLoading(true);
            this.currentFolder.delete(file, (o, success) -> {
                if (success) {
                    int index = this.fileList.getItems().indexOf(file);
                    this.fileList.removeItem(index);
                    refreshList = true;
                }
                this.setLoading(false);
            });
        }
    }

    private void setClipboardFileToSelected() {
        File file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be copied.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            this.clipboardDir = null;
            this.clipboardFile = file;
            this.btnPaste.setEnabled(true);
        } else {
            Dialog.Message dialog = new Dialog.Message("The file/folder you are trying to copy does not exist.");
            this.wrappable.openDialog(dialog);
        }
    }

    private void cutSelectedFile() {
        File file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be cut.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            this.clipboardDrive = (Drive)this.comboBoxDrive.getValue();
            this.clipboardDir = this.currentFolder;
            this.clipboardFile = file;
            this.btnPaste.setEnabled(true);
        } else {
            Dialog.Message dialog = new Dialog.Message("The file/folder you are trying to cut does not exist.");
            this.wrappable.openDialog(dialog);
        }
    }

    private void pasteClipboardFile() {
        if (this.clipboardFile != null) {
            if (this.canPasteHere()) {
                this.handleCopyCut(false);
            } else {
                Dialog.Message dialog = new Dialog.Message("Destination folder can't be a subfolder");
                this.wrappable.openDialog(dialog);
            }
        }
    }

    private void handleCopyCut(boolean override) {
        Callback<FileSystem.Response> CALLBACK = (response, success) -> {
            assert (response != null);
            if (response.getStatus() == 4) {
                Dialog.Confirmation dialog = new Dialog.Confirmation("A file with the same name already exists in this directory. Do you want to override it?");
                dialog.setPositiveText("Override");
                dialog.setPositiveListener((mouseX, mouseY, mouseButton) -> {
                    if (mouseButton == 0) {
                        this.handleCopyCut(true);
                    }
                });
                this.wrappable.openDialog(dialog);
            } else if (response.getStatus() == 1) {
                this.resetClipboard();
            } else {
                this.createErrorDialog(response.getMessage());
            }
            this.setLoading(false);
        };
        this.setLoading(true);
        if (this.clipboardDir != null) {
            this.clipboardFile.moveTo(this.currentFolder, override, CALLBACK);
        } else {
            this.clipboardFile.copyTo(this.currentFolder, override, CALLBACK);
        }
    }

    private void resetClipboard() {
        if (this.clipboardDir != null) {
            this.clipboardDir.refresh();
            this.clipboardDir = null;
            this.clipboardFile = null;
            this.btnPaste.setEnabled(false);
        }
        this.currentFolder.refresh();
        this.openFolder(this.currentFolder, false, (folder, success) -> {
            if (this.mode == Mode.FULL) {
                this.btnRename.setEnabled(false);
                this.btnCopy.setEnabled(false);
                this.btnCut.setEnabled(false);
                this.btnDelete.setEnabled(false);
            }
        });
    }

    private boolean canPasteHere() {
        if (this.clipboardFile != null && this.clipboardFile instanceof Folder) {
            return !this.predecessor.contains(this.clipboardFile) && this.currentFolder != this.clipboardFile;
        }
        return true;
    }

    private boolean isRootFolder() {
        return this.predecessor.size() == 0;
    }

    private void updatePath() {
        Object path = this.currentFolder.getPath();
        int width = class_310.method_1551().field_1772.method_1727((String)(path = ((String)path).replace("/", class_124.field_1065 + "/" + class_124.field_1070)));
        if (width > 144) {
            path = "..." + class_310.method_1551().field_1772.method_27524((String)path, 144, true);
        }
        this.labelPath.setText((String)path);
    }

    public void setLoading(boolean loading) {
        this.layoutLoading.setVisible(loading);
        if (loading) {
            this.disableAllButtons();
        } else {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        boolean hasSelectedFile = this.fileList.getSelectedIndex() != -1;
        this.btnNewFolder.setEnabled(true);
        this.btnRename.setEnabled(hasSelectedFile);
        this.btnDelete.setEnabled(hasSelectedFile);
        if (this.mode == Mode.FULL) {
            this.btnCopy.setEnabled(hasSelectedFile);
            this.btnCut.setEnabled(hasSelectedFile);
            this.btnPaste.setEnabled(this.clipboardFile != null);
        }
        this.btnPreviousFolder.setEnabled(!this.isRootFolder());
    }

    private void disableAllButtons() {
        this.btnPreviousFolder.setEnabled(false);
        this.btnNewFolder.setEnabled(false);
        this.btnRename.setEnabled(false);
        this.btnDelete.setEnabled(false);
        if (this.mode == Mode.FULL) {
            this.btnCopy.setEnabled(false);
            this.btnCut.setEnabled(false);
            this.btnPaste.setEnabled(false);
        }
    }

    private void renameSelectedFile() {
        File file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be renamed.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            Dialog.Input dialog = new Dialog.Input("Enter a name");
            dialog.setResponseHandler((success, s) -> {
                if (success) {
                    this.setLoading(true);
                    file.rename((String)s, (response, success1) -> {
                        assert (response != null);
                        if (response.getStatus() == 1) {
                            dialog.close();
                        } else {
                            this.createErrorDialog(response.getMessage());
                        }
                        this.setLoading(false);
                    });
                }
                return false;
            });
            dialog.setTitle("Rename " + (file instanceof Folder ? "Folder" : "File"));
            dialog.setInputText(file.getName());
            this.wrappable.openDialog(dialog);
        }
    }

    private void createErrorDialog(String message) {
        Dialog.Message dialog = new Dialog.Message(message);
        dialog.setTitle("Error");
        this.wrappable.openDialog(dialog);
    }

    public void setFilter(Predicate<File> filter) {
        this.filter = filter;
    }

    public void setItemClickListener(ItemClickListener<File> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public static enum Mode {
        FULL(225, 145, 26, 6),
        BASIC(211, 105, 26, 4);

        private final int width;
        private final int height;
        private final int offset;
        private final int visibleItems;

        private Mode(int width, int height, int offset, int visibleItems) {
            this.width = width;
            this.height = height;
            this.offset = offset;
            this.visibleItems = visibleItems;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getVisibleItems() {
            return this.visibleItems;
        }
    }
}

