/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system.component;

import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.programs.system.object.ImageEntry;
import com.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;

public class SlideShow
extends Component {
    private static final Color OVERLAY = new Color(0.0f, 0.0f, 0.0f, 0.15f);
    private static final Color OVERLAY_HOVER = new Color(0.35f, 0.35f, 0.35f, 0.15f);
    private final int width;
    private final int height;
    private final class_2371<ImageEntry> IMAGES = class_2371.method_10211();
    private final Image image;
    private int currentImage = -1;

    public SlideShow(int left, int top, int width, int height) {
        super(left, top);
        this.width = width;
        this.height = height;
        this.image = new Image(left, top, width, height);
        this.image.setBorderVisible(true);
    }

    @Override
    protected void init(Layout layout) {
        this.image.setDrawFull(true);
        this.image.init(layout);
    }

    @Override
    protected void handleLoad() {
        this.image.handleLoad();
    }

    @Override
    protected void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (!this.visible) {
            return;
        }
        this.image.render(pose, laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        if (this.currentImage > 0) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x, y, 15, this.height)) {
                class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + 15), (int)(y + this.height), (int)OVERLAY_HOVER.getRGB());
            } else {
                class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + 15), (int)(y + this.height), (int)OVERLAY.getRGB());
            }
            Icons.CHEVRON_LEFT.draw(pose, mc, x + 2, y + (this.height - 10) / 2);
        }
        if (this.currentImage < this.IMAGES.size() - 1) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + this.width - 15, y, 15, this.height)) {
                class_329.method_25294((class_4587)pose, (int)(x + this.width - 15), (int)y, (int)(x + this.width), (int)(y + this.height), (int)OVERLAY_HOVER.getRGB());
            } else {
                class_329.method_25294((class_4587)pose, (int)(x + this.width - 15), (int)y, (int)(x + this.width), (int)(y + this.height), (int)OVERLAY.getRGB());
            }
            Icons.CHEVRON_RIGHT.draw(pose, mc, x + 3 + this.width - 15, y + (this.height - 10) / 2);
        }
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled || mouseButton != 0) {
            return;
        }
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, 15, this.height) && this.currentImage > 0) {
            this.setImage(this.currentImage - 1);
        }
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + this.width - 15, this.yPosition, 15, this.height) && this.currentImage < this.IMAGES.size() - 1) {
            this.setImage(this.currentImage + 1);
        }
    }

    public void addImage(class_2960 resource) {
        this.IMAGES.add((Object)new ImageEntry(resource));
        if (this.currentImage == -1) {
            this.setImage(0);
        }
    }

    public void addImage(String url) {
        this.IMAGES.add((Object)new ImageEntry(url));
        if (this.currentImage == -1) {
            this.setImage(0);
        }
    }

    public void setImage(int index) {
        if (this.IMAGES.isEmpty() && index < 0 && index >= this.IMAGES.size()) {
            return;
        }
        this.currentImage = index;
        ImageEntry entry = (ImageEntry)this.IMAGES.get(index);
        switch (entry.getType()) {
            case LOCAL: {
                this.image.setImage(entry.getResource());
                break;
            }
            case REMOTE: {
                this.image.setImage(entry.getUrl());
            }
        }
    }
}

