/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system.layout;

import com.google.common.collect.Lists;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.ScrollableLayout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.gitweb.component.GitWebFrame;
import com.ultreon.devices.programs.system.AppStore;
import com.ultreon.devices.programs.system.component.SlideShow;
import com.ultreon.devices.programs.system.object.AppEntry;
import com.ultreon.devices.programs.system.object.LocalEntry;
import com.ultreon.devices.programs.system.object.RemoteEntry;
import com.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;

public class LayoutAppPage
extends Layout {
    private final Laptop laptop;
    private final AppEntry entry;
    private final AppStore store;
    private Image imageBanner;
    private Component imageIcon;
    private Label labelTitle;
    private Label labelVersion;
    private boolean installed;

    public LayoutAppPage(Laptop laptop, AppEntry entry, AppStore store) {
        super(250, 150);
        this.laptop = laptop;
        this.entry = entry;
        this.store = store;
    }

    @Override
    public void init() {
        if (this.entry instanceof LocalEntry) {
            this.installed = Laptop.getSystem().getInstalledApplications().contains(((LocalEntry)this.entry).info());
        }
        this.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getBackgroundColor());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 40), (int)(x + width), (int)(y + 41), (int)color.brighter().getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 41), (int)(x + width), (int)(y + 60), (int)color.getRGB());
            class_329.method_25294((class_4587)pose, (int)x, (int)(y + 60), (int)(x + width), (int)(y + 61), (int)color.darker().getRGB());
        });
        class_2960 resource = new class_2960(this.entry.id());
        this.imageBanner = new Image(0, 0, 250, 40);
        this.imageBanner.setDrawFull(true);
        this.imageBanner.setBorderVisible(true);
        this.imageBanner.setBorderThickness(0);
        if (this.entry instanceof LocalEntry) {
            this.imageBanner.setImage(new class_2960(resource.method_12836(), "textures/app/banner/" + resource.method_12832() + ".png"));
        } else if (this.entry instanceof RemoteEntry) {
            this.imageBanner.setImage("https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/assets/" + resource.method_12836() + "/" + resource.method_12832() + "/banner.png");
        }
        this.addComponent(this.imageBanner);
        if (this.entry instanceof LocalEntry) {
            LocalEntry localEntry = (LocalEntry)this.entry;
            AppInfo info = localEntry.info();
            this.imageIcon = new Image.AppImage(5, 26, 28, 28, info);
        } else if (this.entry instanceof RemoteEntry) {
            this.imageIcon = new Image(5, 26, 28, 28, "https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/assets/" + resource.method_12836() + "/" + resource.method_12832() + "/icon.png");
        }
        this.addComponent(this.imageIcon);
        if (this.store.certifiedApps.contains(this.entry)) {
            int width2 = Laptop.getFont().method_1727(this.entry.name()) * 2;
            Image certifiedIcon = new Image(38 + width2 + 3, 29, 20, 20, Icons.VERIFIED);
            this.addComponent(certifiedIcon);
        }
        this.labelTitle = new Label(this.entry.name(), 38, 32);
        this.labelTitle.setScale(2.0);
        this.addComponent(this.labelTitle);
        String version = this.entry instanceof LocalEntry ? "v" + this.entry.version() + " - " + this.entry.author() : this.entry.author();
        this.labelVersion = new Label(version, 38, 50);
        this.addComponent(this.labelVersion);
        String description = GitWebFrame.parseFormatting(this.entry.description());
        ScrollableLayout descriptionLayout = ScrollableLayout.create(130, 67, 115, 78, description);
        this.addComponent(descriptionLayout);
        SlideShow slideShow = new SlideShow(5, 67, 120, 78);
        if (this.entry instanceof LocalEntry) {
            if (this.entry.screenshots() != null) {
                for (String image : this.entry.screenshots()) {
                    if (image.startsWith("http://") || image.startsWith("https://")) {
                        slideShow.addImage(image);
                        continue;
                    }
                    slideShow.addImage(new class_2960(image));
                }
            }
        } else if (this.entry instanceof RemoteEntry) {
            RemoteEntry remoteEntry = (RemoteEntry)this.entry;
            String screenshotUrl = "https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/assets/" + resource.method_12836() + "/" + resource.method_12832() + "/screenshots/screenshot_%d.png";
            for (int i = 0; i < remoteEntry.screenshots; ++i) {
                slideShow.addImage(String.format(screenshotUrl, i));
            }
        }
        this.addComponent(slideShow);
        if (this.entry instanceof LocalEntry) {
            AppInfo info = ((LocalEntry)this.entry).info();
            Button btnInstall = new Button(20, 2, this.installed ? "Delete" : "Install", this.installed ? Icons.CROSS : Icons.PLUS);
            btnInstall.setSize(55, 16);
            btnInstall.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    if (this.installed) {
                        this.laptop.removeApplication(info, (o, success) -> {
                            btnInstall.setText("Install");
                            btnInstall.setIcon(Icons.PLUS);
                            this.installed = false;
                        });
                    } else {
                        this.laptop.installApplication(info, (o, success) -> {
                            System.out.println("Installation Succeeded: " + success);
                            btnInstall.setText("Delete");
                            btnInstall.setIcon(Icons.CROSS);
                            this.installed = true;
                        });
                    }
                }
            });
            this.addComponent(btnInstall);
            if (info.getSupport() != null) {
                Button btnDonate = new Button(234, 44, Icons.COIN);
                btnDonate.setToolTip("Donate", "Opens a link to donate to author of the application");
                btnDonate.setSize(14, 14);
                this.addComponent(btnDonate);
            }
        } else if (this.entry instanceof RemoteEntry) {
            Button btnDownload = new Button(20, 2, "Download", Icons.IMPORT);
            btnDownload.setSize(66, 16);
            btnDownload.setClickListener((mouseX, mouseY, mouseButton) -> this.openWebLink("https://minecraft.curseforge.com/projects/" + ((RemoteEntry)this.entry).projectId));
            this.addComponent(btnDownload);
        }
    }

    @Override
    public void renderOverlay(class_4587 pose, Laptop laptop, class_310 mc, int mouseX, int mouseY, boolean windowActive) {
        int width;
        super.renderOverlay(pose, laptop, mc, mouseX, mouseY, windowActive);
        if (this.store.certifiedApps.contains(this.entry) && GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + 38 + (width = Laptop.getFont().method_1727(this.entry.name()) * 2) + 3, this.yPosition + 29, 20, 20)) {
            laptop.method_30901(pose, Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43470((String)"Certified App").method_27692(class_124.field_1060)}), mouseX, mouseY);
        }
    }

    private void openWebLink(String url) {
        class_156.method_668().method_670(url);
    }
}

