/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system.layout;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.ItemList;
import com.ultreon.devices.api.app.component.TextField;
import com.ultreon.devices.api.app.renderer.ListItemRenderer;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.system.AppStore;
import com.ultreon.devices.programs.system.layout.LayoutAppPage;
import com.ultreon.devices.programs.system.layout.StandardLayout;
import com.ultreon.devices.programs.system.object.LocalEntry;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.apache.commons.lang3.StringUtils;

public class LayoutSearchApps
extends StandardLayout {
    private static final Color ITEM_BACKGROUND = Color.decode("0x9E9E9E");
    private static final Color ITEM_SELECTED = Color.decode("0x757575");
    private final AppStore appStore;
    private long lastClick = 0L;

    public LayoutSearchApps(AppStore appStore, Layout previous) {
        super("Search", 250, 150, appStore, previous);
        this.appStore = appStore;
    }

    @Override
    public void init() {
        super.init();
        final ItemList<AppInfo> itemListResults = new ItemList<AppInfo>(5, 48, 240, 5, true);
        itemListResults.setItems(ApplicationManager.getAvailableApplications());
        itemListResults.sortBy(Comparator.comparing(AppInfo::getName));
        itemListResults.setListItemRenderer(new ListItemRenderer<AppInfo>(18){

            @Override
            public void render(class_4587 pose, AppInfo info, class_332 gui, class_310 mc, int x, int y, int width, int height, boolean selected) {
                class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? ITEM_SELECTED.getRGB() : ITEM_BACKGROUND.getRGB()));
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.drawApplicationIcon(pose, info, x + 2, y + 2);
                RenderUtil.drawStringClipped(pose, info.getName() + class_124.field_1080 + " - " + class_124.field_1063 + info.getDescription(), x + 20, y + 5, itemListResults.getWidth() - 22, Color.WHITE.getRGB(), false);
            }
        });
        itemListResults.setItemClickListener((info, index, mouseButton) -> {
            if (mouseButton == 0) {
                if (System.currentTimeMillis() - this.lastClick <= 200L) {
                    this.openApplication((AppInfo)info);
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            }
        });
        this.addComponent(itemListResults);
        TextField textFieldSearch = new TextField(5, 26, 240);
        textFieldSearch.setIcon(Icons.SEARCH);
        textFieldSearch.setPlaceholder("...");
        textFieldSearch.setKeyListener(c -> {
            Predicate<AppInfo> FILTERED = info -> StringUtils.containsIgnoreCase((CharSequence)info.getName(), (CharSequence)textFieldSearch.getText()) || StringUtils.containsIgnoreCase((CharSequence)info.getDescription(), (CharSequence)textFieldSearch.getText());
            List filteredItems = ApplicationManager.getAvailableApplications().stream().filter(FILTERED).collect(Collectors.toList());
            itemListResults.setItems(filteredItems);
            return false;
        });
        this.addComponent(textFieldSearch);
    }

    private void openApplication(AppInfo info) {
        LayoutAppPage layout = new LayoutAppPage(this.appStore.getLaptop(), new LocalEntry(info), this.appStore);
        this.app.setCurrentLayout(layout);
        Button btnPrevious = new Button(2, 2, Icons.ARROW_LEFT);
        btnPrevious.setClickListener((mouseX1, mouseY1, mouseButton1) -> this.app.setCurrentLayout(this));
        layout.addComponent(btnPrevious);
    }
}

