/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.programs.system.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.api.utils.BankUtil;
import com.ultreon.devices.programs.system.object.Account;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

public class TaskPay
extends Task {
    private String uuid;
    private int amount;

    public TaskPay() {
        super("bank_pay");
    }

    public TaskPay(String uuid, int amount) {
        this();
        this.uuid = uuid;
        this.amount = amount;
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10582("player", this.uuid);
        tag.method_10569("amount", this.amount);
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        String uuid = tag.method_10558("uuid");
        int amount = tag.method_10550("amount");
        Account sender = BankUtil.INSTANCE.getAccount(player);
        Account recipient = BankUtil.INSTANCE.getAccount(UUID.fromString(uuid));
        if (recipient != null && sender.hasAmount(amount)) {
            recipient.add(amount);
            sender.remove(amount);
            this.amount = sender.getBalance();
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        if (this.isSucessful()) {
            tag.method_10569("balance", this.amount);
        }
    }

    @Override
    public void processResponse(class_2487 tag) {
    }
}

