/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.version.Version;
import com.jab125.version.VersionPredicate;
import com.ultreon.devices.Devices;
import com.ultreon.devices.Reference;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.object.TrayItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public record Vulnerability(@Nullable String reporter, String title, @Nullable String description, int severity, Collection<VersionPredicate> affectedVersions, Collection<VersionPredicate> fixVersion, boolean affectsCurrentVersion) {
    public static List<Vulnerability> parseArray(JsonArray array) {
        ArrayList<Vulnerability> arraylist = new ArrayList<Vulnerability>(){

            @Override
            public boolean add(@Nullable Vulnerability vulnerability) {
                if (vulnerability != null) {
                    return super.add(vulnerability);
                }
                return false;
            }
        };
        for (JsonElement jsonElement : array) {
            if (!jsonElement.isJsonObject()) continue;
            System.out.println(Arrays.toString(Reference.getVerInfo()));
            arraylist.add(Vulnerability.parseObject(jsonElement.getAsJsonObject()));
        }
        return ImmutableList.copyOf((Collection)arraylist);
    }

    public static Vulnerability parseObject(JsonObject array) {
        boolean hasReporter = array.has("reporter");
        boolean hasDescription = array.has("description");
        boolean hasFixVersion = array.has("fixVersions");
        Collection<VersionPredicate> affectedVersions = Vulnerability.toStringList(array.getAsJsonArray("affectedVersions"));
        System.out.println(Arrays.toString(Reference.getVerInfo()));
        boolean d = false;
        for (VersionPredicate affectedVersion : affectedVersions) {
            try {
                d = affectedVersion.test(Version.parse(Reference.getVerInfo()[0]));
                if (!d) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Vulnerability(hasReporter ? array.get("reporter").getAsString() : null, array.get("title").getAsString(), hasDescription ? array.get("description").getAsString() : null, array.get("severity").getAsInt(), affectedVersions, !hasFixVersion ? new ArrayList() : Vulnerability.toStringList(array.get("fixVersions").getAsJsonArray()), d);
    }

    private static Collection<VersionPredicate> toStringList(JsonArray array) {
        ArrayList<String> l = new ArrayList<String>();
        for (JsonElement jsonElement : array) {
            l.add(jsonElement.getAsString());
        }
        try {
            return VersionPredicate.parse(l);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<VersionPredicate>();
        }
    }

    @Override
    public String toString() {
        return "Vulnerability{reporter='" + this.reporter + "', title='" + this.title + "', description='" + this.description + "', severity=" + this.severity + ", affectedVersions=" + this.affectedVersions + ", fixVersion='" + this.fixVersion + "'}";
    }

    public int effectiveSeverity() {
        return this.affectsCurrentVersion ? this.severity : 0;
    }

    public static class VulnerabilityTrayItem
    extends TrayItem {
        private final boolean vulnerabilities = VulnerabilityTrayItem.vulnerabilitiesAffectUs();
        private int tick;
        private boolean stat = false;

        public VulnerabilityTrayItem() {
            super(VulnerabilityTrayItem.vulnerabilitiesAffectUs() ? Icons.WARNING : Icons.WARNING_GRAY);
        }

        private static boolean vulnerabilitiesAffectUs() {
            return Devices.getVulnerabilities().stream().anyMatch(Vulnerability::affectsCurrentVersion);
        }

        @Override
        public void tick() {
            super.tick();
            if (!this.vulnerabilities) {
                return;
            }
            if (this.tick >= 15) {
                this.tick = 0;
                this.setIcon(this.stat ? Icons.FLASHED_WARNING : Icons.WARNING);
                this.stat = !this.stat;
            }
            ++this.tick;
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication(Devices.id("vulnerability"));
            if (info != null) {
                Laptop.getSystem().openApplication(info);
            }
        }
    }
}

