/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft.platform;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;

public class MarkdownRenderer {
    private final MatrixStack pose;

    public MarkdownRenderer(MatrixStack pose) {
        this.pose = pose;
    }

    public void push() {
        this.getPose().func_227860_a_();
    }

    public void pop() {
        this.getPose().func_227865_b_();
    }

    public void scale(float x, float y, float z) {
        this.getPose().func_227862_a_(x, y, z);
    }

    public void drawText(String text, int x, int y, float scale, int color, boolean hasShadow) {
        FontRenderer textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.push();
        this.scale(scale, scale, 1.0f);
        if (hasShadow) {
            textRenderer.func_238405_a_(this.pose, text, (float)((int)((float)x / scale)), (float)((int)((float)y / scale)), color);
        } else {
            textRenderer.func_238421_b_(this.pose, text, (float)((int)((float)x / scale)), (float)((int)((float)y / scale)), color);
        }
        this.pop();
    }

    public float getTextWidth(String text, float scale) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        return (float)font.func_78256_a(text) * scale;
    }

    public void drawRect(int x, int y, int width, int height, int color) {
        AbstractGui.func_238467_a_((MatrixStack)this.pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public void drawTexture(ResourceLocation location, int x, int y, int width, int height) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        AbstractGui.func_238463_a_((MatrixStack)this.pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }

    public MatrixStack getPose() {
        return this.pose;
    }
}

