/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft.utils;

import dev.dediamondpro.minemark.providers.ImageProvider;
import dev.jab125.minemark.minecraft.platform.MarkdownDynamicImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_156;

public class MinecraftImageProvider
implements ImageProvider<MarkdownDynamicImage> {
    public static final MinecraftImageProvider INSTANCE = new MinecraftImageProvider();

    private MinecraftImageProvider() {
    }

    public void getImage(String src, Consumer<ImageProvider.Dimension> dimensionCallback, Consumer<MarkdownDynamicImage> imageCallback) {
        CompletableFuture.runAsync(() -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(this.getInputStream(src));
                dimensionCallback.accept(new ImageProvider.Dimension((float)bufferedImage.getWidth(), (float)bufferedImage.getHeight()));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", out);
                class_1011 nativeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(out.toByteArray()));
                imageCallback.accept(MarkdownDynamicImage.of(nativeImage));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, class_156.method_27958());
    }

    public InputStream getInputStream(String src) throws IOException {
        return new URL(src).openStream();
    }
}

