/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft.elements;

import dev.dediamondpro.minemark.LayoutData;
import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.elements.impl.TextElement;
import dev.dediamondpro.minemark.style.Style;
import dev.jab125.minemark.minecraft.platform.MarkdownRenderer;
import dev.jab125.minemark.minecraft.style.MarkdownStyle;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class MarkdownTextElement
extends TextElement<MarkdownStyle, MarkdownRenderer> {
    public MarkdownTextElement(@NotNull String text, @NotNull MarkdownStyle style, @NotNull LayoutStyle layoutStyle, @Nullable Element<MarkdownStyle, MarkdownRenderer> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(text, (Style)style, layoutStyle, parent, qName, attributes);
    }

    protected void drawText(@NotNull String text, float x, float y, float fontSize, Color color, boolean hovered, LayoutData.MarkDownElementPosition position, @NotNull MarkdownRenderer renderer) {
        renderer.drawText(this.getPrefix(hovered) + text, (int)x, (int)y, fontSize, color.getRGB(), ((MarkdownStyle)this.style).getTextStyle().hasShadow());
    }

    protected void drawInlineCodeBlock(float x, float y, float width, float height, Color color, @NotNull MarkdownRenderer renderer) {
        renderer.drawRect((int)x, (int)y, (int)width, (int)height, color.getRGB());
    }

    protected float getTextWidth(@NotNull String text, float fontSize, MarkdownRenderer renderer) {
        return renderer.getTextWidth(this.getPrefix(false) + text, fontSize);
    }

    private String getPrefix(boolean hovered) {
        StringBuilder prefixBuilder = new StringBuilder();
        if (this.layoutStyle.isBold()) {
            prefixBuilder.append("\u00a7l");
        }
        if (this.layoutStyle.isItalic()) {
            prefixBuilder.append("\u00a7o");
        }
        if (this.layoutStyle.isStrikethrough()) {
            prefixBuilder.append("\u00a7m");
        }
        if (this.layoutStyle.isUnderlined() || this.layoutStyle.isPartOfLink() && hovered) {
            prefixBuilder.append("\u00a7n");
        }
        return prefixBuilder.toString();
    }

    protected float getBaselineHeight(float fontSize, MarkdownRenderer renderer) {
        return 8.0f * fontSize;
    }

    protected float getDescender(float fontSize, MarkdownRenderer renderData) {
        return fontSize;
    }
}

