/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft.platform;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class MarkdownRenderer {
    private final PoseStack pose;

    public MarkdownRenderer(PoseStack pose) {
        this.pose = pose;
    }

    public void push() {
        this.getPose().m_85836_();
    }

    public void pop() {
        this.getPose().m_85849_();
    }

    public void scale(float x, float y, float z) {
        this.getPose().m_85841_(x, y, z);
    }

    public void drawText(String text, int x, int y, float scale, int color, boolean hasShadow) {
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        this.push();
        this.scale(scale, scale, 1.0f);
        if (hasShadow) {
            textRenderer.m_92750_(this.pose, text, (float)((int)((float)x / scale)), (float)((int)((float)y / scale)), color);
        } else {
            textRenderer.m_92883_(this.pose, text, (float)((int)((float)x / scale)), (float)((int)((float)y / scale)), color);
        }
        this.pop();
    }

    public float getTextWidth(String text, float scale) {
        Font font = Minecraft.m_91087_().f_91062_;
        return (float)font.m_92895_(text) * scale;
    }

    public void drawRect(int x, int y, int width, int height, int color) {
        GuiComponent.m_93172_((PoseStack)this.pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public void drawTexture(ResourceLocation location, int x, int y, int width, int height) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        GuiComponent.m_93133_((PoseStack)this.pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }

    public PoseStack getPose() {
        return this.pose;
    }
}

