/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft;

import dev.dediamondpro.minemark.MineMarkCore;
import dev.dediamondpro.minemark.MineMarkCoreBuilder;
import dev.dediamondpro.minemark.elements.Elements;
import dev.dediamondpro.minemark.elements.MineMarkElement;
import dev.dediamondpro.minemark.style.Style;
import dev.dediamondpro.minemark.utils.MouseButton;
import dev.jab125.minemark.minecraft.elements.MarkdownBlockQuoteElement;
import dev.jab125.minemark.minecraft.elements.MarkdownCodeBlockElement;
import dev.jab125.minemark.minecraft.elements.MarkdownHeadingElement;
import dev.jab125.minemark.minecraft.elements.MarkdownHorizontalRuleElement;
import dev.jab125.minemark.minecraft.elements.MarkdownImageElement;
import dev.jab125.minemark.minecraft.elements.MarkdownListElement;
import dev.jab125.minemark.minecraft.elements.MarkdownTableCellElement;
import dev.jab125.minemark.minecraft.elements.MarkdownTextElement;
import dev.jab125.minemark.minecraft.platform.MarkdownRenderer;
import dev.jab125.minemark.minecraft.style.MarkdownStyle;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_332;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.xml.sax.SAXException;

public class MineMarkDrawable {
    public static final MineMarkCore<MarkdownStyle, MarkdownRenderer> DEFAULT_CORE = MineMarkDrawable.addMinecraftExtensions((MineMarkCoreBuilder<MarkdownStyle, MarkdownRenderer>)MineMarkCore.builder()).addExtension(StrikethroughExtension.create()).addExtension(TablesExtension.create()).build();
    private final MineMarkElement<MarkdownStyle, MarkdownRenderer> parsedMarkdown;

    public MineMarkDrawable(MineMarkElement<MarkdownStyle, MarkdownRenderer> parsedMarkdown) {
        this.parsedMarkdown = parsedMarkdown;
    }

    public MineMarkDrawable(String markdown, MarkdownStyle style, MineMarkCore<MarkdownStyle, MarkdownRenderer> core) throws IOException, SAXException {
        this((MineMarkElement<MarkdownStyle, MarkdownRenderer>)core.parse((Style)style, markdown));
    }

    public MineMarkDrawable(String markdown, MarkdownStyle style) throws IOException, SAXException {
        this(markdown, style, DEFAULT_CORE);
    }

    public MineMarkDrawable(String markdown) throws IOException, SAXException {
        this(markdown, new MarkdownStyle());
    }

    public MineMarkDrawable(Reader markdown, MarkdownStyle style, MineMarkCore<MarkdownStyle, MarkdownRenderer> core) throws IOException, SAXException {
        this((MineMarkElement<MarkdownStyle, MarkdownRenderer>)core.parse((Style)style, markdown));
    }

    public MineMarkDrawable(Reader markdown, MarkdownStyle style) throws IOException, SAXException {
        this(markdown, style, DEFAULT_CORE);
    }

    public MineMarkDrawable(Reader markdown) throws IOException, SAXException {
        this(markdown, new MarkdownStyle());
    }

    public void draw(float x, float y, float width, float mouseX, float mouseY, class_332 graphics) {
        this.parsedMarkdown.draw(x, y, width, mouseX, mouseY, (Object)new MarkdownRenderer(graphics));
    }

    public void beforeDraw(float x, float y, float width, float mouseX, float mouseY, class_332 graphics) {
        this.parsedMarkdown.beforeDraw(x, y, width, mouseX, mouseY, (Object)new MarkdownRenderer(graphics));
    }

    public void onMouseClicked(float x, float y, float mouseX, float mouseY, int button) {
        this.parsedMarkdown.onMouseClicked(x, y, switch (button) {
            default -> MouseButton.LEFT;
            case 1 -> MouseButton.RIGHT;
            case 2 -> MouseButton.MIDDLE;
        }, mouseX, mouseY);
    }

    public MineMarkElement<MarkdownStyle, MarkdownRenderer> getParsedMarkdown() {
        return this.parsedMarkdown;
    }

    public float getHeight() {
        return this.parsedMarkdown.getHeight();
    }

    public void close() {
        this.parsedMarkdown.close();
    }

    public static MineMarkCoreBuilder<MarkdownStyle, MarkdownRenderer> addMinecraftExtensions(MineMarkCoreBuilder<MarkdownStyle, MarkdownRenderer> core) {
        return core.setTextElement(MarkdownTextElement::new).addElement(Elements.HEADING, MarkdownHeadingElement::new).addElement(Elements.CODE_BLOCK, MarkdownCodeBlockElement::new).addElement(Elements.BLOCKQUOTE, MarkdownBlockQuoteElement::new).addElement(Elements.LIST_ELEMENT, MarkdownListElement::new).addElement(Elements.HORIZONTAL_RULE, MarkdownHorizontalRuleElement::new).addElement(Elements.TABLE_CELL, MarkdownTableCellElement::new).addElement(Elements.IMAGE, MarkdownImageElement::new);
    }
}

