/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft.elements;

import dev.dediamondpro.minemark.LayoutData;
import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.elements.impl.list.ListElement;
import dev.dediamondpro.minemark.style.Style;
import dev.jab125.minemark.minecraft.platform.MarkdownRenderer;
import dev.jab125.minemark.minecraft.style.MarkdownStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class MarkdownListElement
extends ListElement<MarkdownStyle, MarkdownRenderer> {
    private final String markerStr;

    public MarkdownListElement(@NotNull MarkdownStyle style, @NotNull LayoutStyle layoutStyle, @Nullable Element<MarkdownStyle, MarkdownRenderer> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super((Style)style, layoutStyle, parent, qName, attributes);
        switch (this.listType) {
            case ORDERED: {
                this.markerStr = this.elementIndex + 1 + ". ";
                break;
            }
            default: {
                this.markerStr = "\u25cf ";
            }
        }
    }

    protected void drawMarker(float x, float y, MarkdownRenderer renderer) {
        renderer.drawText(this.markerStr, (int)x, (int)y, this.layoutStyle.getFontSize(), this.layoutStyle.getTextColor().getRGB(), ((MarkdownStyle)this.style).getTextStyle().hasShadow());
    }

    protected float getListMarkerWidth(LayoutData layoutData, MarkdownRenderer renderer) {
        return renderer.getTextWidth(this.markerStr, this.layoutStyle.getFontSize());
    }

    protected float getMarkerHeight(LayoutData layoutData, MarkdownRenderer renderData) {
        return 8.0f * this.layoutStyle.getFontSize();
    }
}

