/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft.platform;

import com.mojang.blaze3d.platform.NativeImage;
import dev.jab125.minemark.minecraft.platform.MarkdownRenderer;
import java.io.Closeable;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class MarkdownDynamicImage
implements Closeable {
    private final ResourceLocation location;

    public MarkdownDynamicImage(ResourceLocation location) {
        this.location = location;
    }

    public void draw(int x, int y, int width, int height, MarkdownRenderer renderer) {
        renderer.drawTexture(this.location, x, y, width, height);
    }

    @Override
    public void close() {
        Minecraft.getInstance().getTextureManager().release(this.location);
    }

    public static MarkdownDynamicImage of(NativeImage image) throws IOException {
        DynamicTexture texture = new DynamicTexture(image);
        ResourceLocation location = Minecraft.getInstance().getTextureManager().register("minemark", texture);
        return new MarkdownDynamicImage(location);
    }
}

