/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.minemark.minecraft.platform;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class MarkdownRenderer {
    private final GuiGraphics graphics;

    public MarkdownRenderer(GuiGraphics graphics) {
        this.graphics = graphics;
    }

    public void push() {
        this.getPose().pushPose();
    }

    public void pop() {
        this.getPose().popPose();
    }

    public void scale(float x, float y, float z) {
        this.getPose().scale(x, y, z);
    }

    public void drawText(String text, int x, int y, float scale, int color, boolean hasShadow) {
        Font textRenderer = Minecraft.getInstance().font;
        this.push();
        this.scale(scale, scale, 1.0f);
        this.graphics.drawString(textRenderer, text, (int)((float)x / scale), (int)((float)y / scale), color, hasShadow);
        this.pop();
    }

    public float getTextWidth(String text, float scale) {
        Font font = Minecraft.getInstance().font;
        return (float)font.width(text) * scale;
    }

    public void drawRect(int x, int y, int width, int height, int color) {
        this.graphics.fill(x, y, x + width, y + height, color);
    }

    public void drawTexture(ResourceLocation location, int x, int y, int width, int height) {
        this.graphics.blit(location, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public PoseStack getPose() {
        return this.graphics.pose();
    }
}

