/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.compiler;

import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import dev.jab125.lavendermd.util.TextBuilder;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class TextCompiler
implements MarkdownCompiler<class_2561> {
    private final TextBuilder builder = new TextBuilder();
    private final int assumedOutputWidth;
    private int quoteDepth = 0;
    private int listDepth = 0;

    public TextCompiler() {
        this(50);
    }

    public TextCompiler(int assumedOutputWidth) {
        this.assumedOutputWidth = assumedOutputWidth;
    }

    @Override
    public void visitText(String text) {
        if (this.quoteDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append(this.quoteMarker());
            } else {
                for (String line : text.split("\n")) {
                    this.builder.append(this.quoteMarker().method_10852((class_2561)new class_2585(line)));
                }
            }
        } else if (this.listDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append((class_5250)new class_2585("\n   " + "  ".repeat(this.listDepth - 1)));
            } else {
                String[] lines = text.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    this.builder.append(new class_2585((i > 0 ? "\n   " : "   ") + "  ".repeat(this.listDepth - 1)).method_10852((class_2561)new class_2585(lines[i])));
                }
            }
        } else {
            this.builder.append((class_5250)new class_2585(text));
        }
    }

    @Override
    public void visitStyle(UnaryOperator<class_2583> style) {
        this.builder.pushStyle(style);
    }

    @Override
    public void visitStyleEnd() {
        this.builder.popStyle();
    }

    @Override
    public void visitBlockQuote() {
        ++this.quoteDepth;
        this.builder.append(this.quoteMarker());
        this.builder.pushStyle(style -> style.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)));
    }

    @Override
    public void visitBlockQuoteEnd() {
        this.builder.popStyle();
        --this.quoteDepth;
        if (this.quoteDepth > 0) {
            this.builder.append(this.quoteMarker());
        } else {
            this.builder.append((class_5250)new class_2585("\n"));
        }
    }

    private class_5250 quoteMarker() {
        return new class_2585("\n >" + ">".repeat(this.quoteDepth) + " ").method_27692(class_124.field_1063);
    }

    @Override
    public void visitHorizontalRule() {
        this.builder.append(new class_2585("-".repeat(this.assumedOutputWidth)).method_27692(class_124.field_1063));
    }

    @Override
    public void visitImage(class_2960 image, String description, boolean fit) {
        this.builder.append(new class_2585("[" + description + "]").method_27692(class_124.field_1054));
    }

    @Override
    public void visitListItem(OptionalInt ordinal) {
        String listPrefix;
        String string = listPrefix = ordinal.isPresent() ? " " + ordinal.getAsInt() + ". " : " \u2022 ";
        if (this.listDepth > 0) {
            this.builder.append((class_5250)new class_2585("\n" + "   ".repeat(this.listDepth) + listPrefix));
        } else {
            this.builder.append((class_5250)new class_2585(listPrefix));
        }
        ++this.listDepth;
    }

    @Override
    public void visitListItemEnd() {
        --this.listDepth;
        if (this.listDepth > 0) {
            this.builder.append((class_5250)new class_2585("   ".repeat(this.listDepth)));
        } else {
            this.builder.append((class_5250)new class_2585("\n"));
        }
    }

    @Override
    public class_2561 compile() {
        return this.builder.build();
    }

    @Override
    public String name() {
        return "lavender_builtin_text";
    }
}

