/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd;

import com.google.common.collect.ImmutableList;
import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import dev.jab125.lavendermd.compiler.TextCompiler;
import dev.jab125.lavendermd.feature.BasicFormattingFeature;
import dev.jab125.lavendermd.feature.BlockQuoteFeature;
import dev.jab125.lavendermd.feature.ColorFeature;
import dev.jab125.lavendermd.feature.LinkFeature;
import dev.jab125.lavendermd.feature.ListFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;

public class MarkdownProcessor<R> {
    private final Supplier<MarkdownCompiler<R>> compilerFactory;
    private final List<MarkdownFeature> features;
    private final Lexer lexer;
    private final Parser parser;

    public MarkdownProcessor(Supplier<MarkdownCompiler<R>> compilerFactory, MarkdownFeature ... features) {
        this(compilerFactory, Arrays.asList(features));
    }

    public MarkdownProcessor(Supplier<MarkdownCompiler<R>> compilerFactory, List<MarkdownFeature> features) {
        this.compilerFactory = compilerFactory;
        this.features = ImmutableList.copyOf(features);
        MarkdownCompiler<R> testCompiler = this.compilerFactory.get();
        for (MarkdownFeature feature : this.features) {
            if (feature.supportsCompiler(testCompiler)) continue;
            throw new IllegalStateException("Feature '" + feature.name() + "' is incompatible with compiler '" + testCompiler.name() + "'");
        }
        this.lexer = new Lexer();
        this.parser = new Parser();
        for (MarkdownFeature extension : features) {
            extension.registerTokens(this.lexer);
            extension.registerNodes(this.parser);
        }
    }

    public Collection<MarkdownFeature> installedFeatures() {
        return this.features;
    }

    public boolean hasFeature(Class<?> featureClass) {
        for (MarkdownFeature extension : this.features) {
            if (!featureClass.isInstance(extension)) continue;
            return true;
        }
        return false;
    }

    public R process(String markdown) {
        MarkdownCompiler<R> compiler = this.compilerFactory.get();
        this.parser.parse(this.lexer.lex(markdown)).visit(compiler);
        return compiler.compile();
    }

    public MarkdownProcessor<R> copyWith(MarkdownFeature ... features) {
        ArrayList<MarkdownFeature> newFeatures = new ArrayList<MarkdownFeature>(this.features);
        for (MarkdownFeature feature : features) {
            if (this.hasFeature(feature.getClass())) continue;
            newFeatures.add(feature);
        }
        return new MarkdownProcessor<R>(this.compilerFactory, newFeatures);
    }

    public <R2> MarkdownProcessor<R2> copyWith(Supplier<MarkdownCompiler<R2>> compilerFactory) {
        return new MarkdownProcessor<R>(compilerFactory, this.features);
    }

    public static MarkdownProcessor<ITextComponent> text() {
        return new MarkdownProcessor<ITextComponent>(TextCompiler::new, new BasicFormattingFeature(false), new ColorFeature());
    }

    public static MarkdownProcessor<ITextComponent> richText(int assumedOutputWidth) {
        return new MarkdownProcessor<ITextComponent>(() -> new TextCompiler(assumedOutputWidth), new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature());
    }
}

