/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd;

import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import dev.jab125.lavendermd.util.ListNibbler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.util.text.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parser
implements MarkdownFeature.NodeRegistrar {
    private final Map<BiFunction<Lexer.Token, ListNibbler<Lexer.Token>, ?>, ParseFunction<?>> parseFunctions = new HashMap();

    public Parser() {
        this.registerNode((parser, text, tokens) -> {
            String content = text.content();
            if (tokens.peek(-2) == null || tokens.peek(-2) instanceof Lexer.NewlineToken) {
                content = content.stripLeading();
            }
            Lexer.Token peek = null;
            peek = (Lexer.Token)tokens.peek();
            if (peek instanceof Lexer.NewlineToken && !((Lexer.NewlineToken)peek).isBoundary()) {
                content = content.stripTrailing();
            }
            return new TextNode(content);
        }, (token, tokens) -> token instanceof Lexer.TextToken ? (Lexer.TextToken)token : null);
    }

    @Override
    public <T extends Lexer.Token> void registerNode(ParseFunction<T> parser, BiFunction<Lexer.Token, ListNibbler<Lexer.Token>, @Nullable T> trigger) {
        this.parseFunctions.put(trigger, parser);
    }

    public Node parse(List<Lexer.Token> tokens) {
        ListNibbler<Lexer.Token> tokenNibbler = new ListNibbler<Lexer.Token>(tokens);
        Node node = Node.empty();
        while (tokenNibbler.hasElements()) {
            node.addChild(this.parseNode(tokenNibbler));
        }
        return node;
    }

    @NotNull
    private Node parseNode(ListNibbler<Lexer.Token> tokens) {
        Lexer.Token token = tokens.nibble();
        for (Map.Entry<BiFunction<Lexer.Token, ListNibbler<Lexer.Token>, ?>, ParseFunction<?>> function : this.parseFunctions.entrySet()) {
            Object first = function.getKey().apply(token, tokens);
            if (first == null) continue;
            return function.getValue().parse(this, token, tokens);
        }
        if (token != null) {
            return new TextNode(token.content());
        }
        return Node.empty();
    }

    public Node parseUntil(ListNibbler<Lexer.Token> tokens, Class<? extends Lexer.Token> until) {
        return this.parseUntil(tokens, token -> token.isBoundary() || until.isInstance(token), token -> false);
    }

    public Node parseUntil(ListNibbler<Lexer.Token> tokens, Predicate<Lexer.Token> until, Predicate<Lexer.Token> skip) {
        Node node = this.parseNode(tokens);
        while (tokens.hasElements()) {
            Lexer.Token next = tokens.peek();
            if (skip.test(next)) {
                tokens.nibble();
                continue;
            }
            if (until.test(next)) break;
            node.addChild(this.parseNode(tokens));
        }
        return node;
    }

    @FunctionalInterface
    public static interface ParseFunction<T extends Lexer.Token> {
        public Node parse(Parser var1, T var2, ListNibbler<Lexer.Token> var3);
    }

    public static abstract class Node {
        protected final List<Node> children = new ArrayList<Node>();

        public Node addChild(Node child) {
            this.children.add(child);
            return this;
        }

        public void visit(MarkdownCompiler<?> compiler) {
            this.visitStart(compiler);
            for (Node child : this.children) {
                child.visit(compiler);
            }
            this.visitEnd(compiler);
        }

        protected abstract void visitStart(MarkdownCompiler<?> var1);

        protected abstract void visitEnd(MarkdownCompiler<?> var1);

        public static Node empty() {
            return new Node(){

                @Override
                protected void visitStart(MarkdownCompiler<?> compiler) {
                }

                @Override
                protected void visitEnd(MarkdownCompiler<?> compiler) {
                }
            };
        }
    }

    public static final class TextNode
    extends Node {
        private final String content;

        public TextNode(String content) {
            this.content = content;
        }

        @Override
        public void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitText(this.content);
        }

        @Override
        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }

    public static class FormattingNode
    extends Node {
        private final UnaryOperator<Style> formatting;

        public FormattingNode(UnaryOperator<Style> formatting) {
            this.formatting = formatting;
        }

        @Override
        public void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitStyle(this::applyStyle);
        }

        @Override
        protected void visitEnd(MarkdownCompiler<?> compiler) {
            compiler.visitStyleEnd();
        }

        protected Style applyStyle(Style style) {
            return (Style)this.formatting.apply(style);
        }
    }
}

