/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.compiler;

import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import dev.jab125.lavendermd.util.TextBuilder;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextCompiler
implements MarkdownCompiler<ITextComponent> {
    private final TextBuilder builder = new TextBuilder();
    private final int assumedOutputWidth;
    private int quoteDepth = 0;
    private int listDepth = 0;

    public TextCompiler() {
        this(50);
    }

    public TextCompiler(int assumedOutputWidth) {
        this.assumedOutputWidth = assumedOutputWidth;
    }

    @Override
    public void visitText(String text) {
        if (this.quoteDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append(this.quoteMarker());
            } else {
                for (String line : text.split("\n")) {
                    this.builder.append(this.quoteMarker().func_230529_a_((ITextComponent)new StringTextComponent(line)));
                }
            }
        } else if (this.listDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append((IFormattableTextComponent)new StringTextComponent("\n   " + "  ".repeat(this.listDepth - 1)));
            } else {
                String[] lines = text.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    this.builder.append(new StringTextComponent((i > 0 ? "\n   " : "   ") + "  ".repeat(this.listDepth - 1)).func_230529_a_((ITextComponent)new StringTextComponent(lines[i])));
                }
            }
        } else {
            this.builder.append((IFormattableTextComponent)new StringTextComponent(text));
        }
    }

    @Override
    public void visitStyle(UnaryOperator<Style> style) {
        this.builder.pushStyle(style);
    }

    @Override
    public void visitStyleEnd() {
        this.builder.popStyle();
    }

    @Override
    public void visitBlockQuote() {
        ++this.quoteDepth;
        this.builder.append(this.quoteMarker());
        this.builder.pushStyle(style -> style.func_240712_a_(TextFormatting.GRAY).func_240722_b_(Boolean.valueOf(true)));
    }

    @Override
    public void visitBlockQuoteEnd() {
        this.builder.popStyle();
        --this.quoteDepth;
        if (this.quoteDepth > 0) {
            this.builder.append(this.quoteMarker());
        } else {
            this.builder.append((IFormattableTextComponent)new StringTextComponent("\n"));
        }
    }

    private IFormattableTextComponent quoteMarker() {
        return new StringTextComponent("\n >" + ">".repeat(this.quoteDepth) + " ").func_240699_a_(TextFormatting.DARK_GRAY);
    }

    @Override
    public void visitHorizontalRule() {
        this.builder.append(new StringTextComponent("-".repeat(this.assumedOutputWidth)).func_240699_a_(TextFormatting.DARK_GRAY));
    }

    @Override
    public void visitImage(ResourceLocation image, String description, boolean fit) {
        this.builder.append(new StringTextComponent("[" + description + "]").func_240699_a_(TextFormatting.YELLOW));
    }

    @Override
    public void visitListItem(OptionalInt ordinal) {
        String listPrefix;
        String string = listPrefix = ordinal.isPresent() ? " " + ordinal.getAsInt() + ". " : " \u2022 ";
        if (this.listDepth > 0) {
            this.builder.append((IFormattableTextComponent)new StringTextComponent("\n" + "   ".repeat(this.listDepth) + listPrefix));
        } else {
            this.builder.append((IFormattableTextComponent)new StringTextComponent(listPrefix));
        }
        ++this.listDepth;
    }

    @Override
    public void visitListItemEnd() {
        --this.listDepth;
        if (this.listDepth > 0) {
            this.builder.append((IFormattableTextComponent)new StringTextComponent("   ".repeat(this.listDepth)));
        } else {
            this.builder.append((IFormattableTextComponent)new StringTextComponent("\n"));
        }
    }

    @Override
    public ITextComponent compile() {
        return this.builder.build();
    }

    @Override
    public String name() {
        return "lavender_builtin_text";
    }
}

